/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.ipc.CallerContext;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.JobSubmissionFiles;
import org.apache.hadoop.mapreduce.RssMRConfig;
import org.apache.hadoop.mapreduce.RssMRUtils;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.MRAppMaster;
import org.apache.hadoop.mapreduce.v2.app.client.ClientService;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.impl.JobImpl;
import org.apache.hadoop.mapreduce.v2.app.local.LocalContainerAllocator;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerAllocator;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerAllocatorEvent;
import org.apache.hadoop.mapreduce.v2.app.rm.RMCommunicator;
import org.apache.hadoop.mapreduce.v2.app.rm.RMHeartbeatHandler;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.mapreduce.v2.util.MRWebAppUtil;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceOperations;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.yarn.YarnUncaughtExceptionHandler;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.uniffle.client.api.ShuffleWriteClient;
import org.apache.uniffle.client.util.ClientUtils;
import org.apache.uniffle.common.PartitionRange;
import org.apache.uniffle.common.RemoteStorageInfo;
import org.apache.uniffle.common.ShuffleAssignmentsInfo;
import org.apache.uniffle.common.ShuffleDataDistributionType;
import org.apache.uniffle.common.ShuffleServerInfo;
import org.apache.uniffle.common.config.RssClientConf;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.util.RetryUtils;
import org.apache.uniffle.hadoop.shim.HadoopShimImpl;
import org.apache.uniffle.proto.RssProtos;
import org.apache.uniffle.shaded.com.google.common.collect.Lists;
import org.apache.uniffle.shaded.com.google.common.collect.Sets;
import org.apache.uniffle.storage.util.StorageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RssMRAppMaster
extends MRAppMaster {
    private final String rssNmHost;
    private final int rssNmPort;
    private final int rssNmHttpPort;
    private final ContainerId rssContainerID;
    private RssContainerAllocatorRouter rssContainerAllocator;
    private ShuffleWriteClient shuffleWriteClient;
    private static final Logger LOG = LoggerFactory.getLogger(RssMRAppMaster.class);

    public RssMRAppMaster(ApplicationAttemptId applicationAttemptId, ContainerId containerId, String nmHost, int nmPort, int nmHttpPort, long appSubmitTime, ShuffleWriteClient client) {
        super(applicationAttemptId, containerId, nmHost, nmPort, nmHttpPort, (Clock)new SystemClock(), appSubmitTime);
        this.rssNmHost = nmHost;
        this.rssNmPort = nmPort;
        this.rssNmHttpPort = nmHttpPort;
        this.rssContainerID = containerId;
        this.rssContainerAllocator = null;
        this.shuffleWriteClient = client;
    }

    protected void serviceStop() throws Exception {
        LOG.info("Unregister shuffle for app {}", (Object)this.getAttemptID());
        if (this.shuffleWriteClient != null) {
            this.shuffleWriteClient.unregisterShuffle(this.getAttemptID().toString(), 0);
        }
        super.serviceStop();
    }

    public static void main(String[] args) {
        JobConf conf = new JobConf((Configuration)new YarnConfiguration());
        conf.addResource(new Path("job.xml"));
        ShuffleWriteClient shuffleWriteClient = null;
        int numReduceTasks = conf.getInt("mapreduce.job.reduces", 0);
        if (numReduceTasks > 0) {
            ShuffleAssignmentsInfo response;
            ShuffleWriteClient client;
            String coordinators = conf.get("mapreduce.rss.coordinator.quorum");
            shuffleWriteClient = client = RssMRUtils.createShuffleClient(conf);
            LOG.info("Registering coordinators {}", (Object)coordinators);
            client.registerCoordinators(coordinators);
            ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = Executors.defaultThreadFactory().newThread(r);
                    t.setDaemon(true);
                    return t;
                }
            });
            JobConf extraConf = new JobConf(false);
            extraConf.clear();
            RssMRUtils.applyClientConf((Configuration)extraConf, conf);
            boolean dynamicConfEnabled = conf.getBoolean("mapreduce.rss.dynamicClientConf.enabled", true);
            if (dynamicConfEnabled) {
                Map<String, String> clusterClientConf = client.fetchClientConf(conf.getInt("mapreduce.rss.access.timeout.ms", 10000));
                RssMRUtils.applyDynamicClientConf((Configuration)extraConf, clusterClientConf);
            }
            HashSet<String> assignmentTags = new HashSet<String>();
            String rawTags = conf.get("mapreduce.rss.client.assignment.tags", "");
            if (StringUtils.isNotEmpty((CharSequence)rawTags)) {
                rawTags = rawTags.trim();
                assignmentTags.addAll(Arrays.asList(rawTags.split(",")));
            }
            assignmentTags.add("ss_v5");
            String clientType = extraConf.get("mapreduce.rss.client.type", "GRPC_NETTY");
            ClientUtils.validateClientType(clientType);
            assignmentTags.add(clientType);
            String storageType = RssMRUtils.getString((Configuration)extraConf, "mapreduce.rss.storage.type");
            boolean testMode = RssMRUtils.getBoolean((Configuration)extraConf, "mapreduce.rss.test.mode.enable", false);
            ClientUtils.validateTestModeConf(testMode, storageType);
            ApplicationAttemptId applicationAttemptId = RssMRUtils.getApplicationAttemptId();
            String appId = applicationAttemptId.toString();
            RemoteStorageInfo defaultRemoteStorage = new RemoteStorageInfo(extraConf.get("mapreduce.rss.remote.storage.path", ""));
            RemoteStorageInfo remoteStorage = ClientUtils.fetchRemoteStorage(appId, defaultRemoteStorage, dynamicConfEnabled, storageType, client);
            extraConf.set("mapreduce.rss.remote.storage.path", remoteStorage.getPath());
            extraConf.set("mapreduce.rss.remote.storage.conf", remoteStorage.getConfString());
            RssMRUtils.validateRssClientConf((Configuration)extraConf);
            if (conf.getBoolean("mapreduce.rss.reduce.remote.spill.enable", false)) {
                if (remoteStorage.isEmpty()) {
                    throw new IllegalArgumentException("Remote spill only supports " + StorageType.MEMORY_LOCALFILE_HDFS.name() + " mode with " + remoteStorage);
                }
                int originalAttempts = conf.getInt("mapreduce.reduce.maxattempts", 4);
                int inc = conf.getInt("mapreduce.rss.reduce.remote.spill.attempt.inc", 1);
                if (inc < 0) {
                    throw new IllegalArgumentException("mapreduce.rss.reduce.remote.spill.attempt.inc cannot be negative");
                }
                conf.setInt("mapreduce.reduce.maxattempts", originalAttempts + inc);
            }
            int requiredAssignmentShuffleServersNum = RssMRUtils.getRequiredShuffleServerNumber(conf);
            long retryInterval = conf.getLong("mapreduce.rss.client.assignment.retry.interval", 65000L);
            int retryTimes = conf.getInt("mapreduce.rss.client.assignment.retry.times", 3);
            boolean remoteMergeEnable = conf.getBoolean("mapreduce.rss.remote.merge.enable", false);
            try {
                response = RetryUtils.retry(() -> {
                    ShuffleAssignmentsInfo shuffleAssignments = client.getShuffleAssignments(appId, 0, numReduceTasks, 1, Sets.newHashSet(assignmentTags), requiredAssignmentShuffleServersNum, -1);
                    Map<ShuffleServerInfo, List<PartitionRange>> serverToPartitionRanges = shuffleAssignments.getServerToPartitionRanges();
                    if (serverToPartitionRanges == null || serverToPartitionRanges.isEmpty()) {
                        return null;
                    }
                    LOG.info("Start to register shuffle");
                    long start = System.currentTimeMillis();
                    serverToPartitionRanges.entrySet().forEach(entry -> client.registerShuffle((ShuffleServerInfo)entry.getKey(), appId, 0, (List<PartitionRange>)((List)entry.getValue()), remoteStorage, ShuffleDataDistributionType.NORMAL, (int)RssMRConfig.toRssConf((Configuration)conf).get(RssClientConf.MAX_CONCURRENCY_PER_PARTITION_TO_WRITE), remoteMergeEnable ? RssProtos.MergeContext.newBuilder().setKeyClass(conf.getMapOutputKeyClass().getName()).setValueClass(conf.getMapOutputValueClass().getName()).setComparatorClass(conf.getOutputKeyComparator().getClass().getName()).setMergedBlockSize(conf.getInt("mapreduce.rss.merged.block.size", -1)).setMergeClassLoader(conf.get("mapreduce.rss.remote.merge.classloader", "")).build() : null));
                    LOG.info("Finish register shuffle with " + (System.currentTimeMillis() - start) + " ms");
                    return shuffleAssignments;
                }, retryInterval, retryTimes);
            }
            catch (Throwable throwable) {
                throw new RssException("registerShuffle failed!", throwable);
            }
            if (response == null) {
                return;
            }
            long heartbeatInterval = conf.getLong("mapreduce.rss.heartbeat.interval", 10000L);
            long heartbeatTimeout = conf.getLong("mapreduce.rss.heartbeat.timeout", heartbeatInterval / 2L);
            client.registerApplicationInfo(appId, heartbeatTimeout, "user");
            scheduledExecutorService.scheduleAtFixedRate(() -> {
                try {
                    client.sendAppHeartbeat(appId, heartbeatTimeout);
                    LOG.info("Finish send heartbeat to coordinator and servers");
                }
                catch (Exception e) {
                    LOG.warn("Fail to send heartbeat to coordinator and servers", (Throwable)e);
                }
            }, heartbeatInterval / 2L, heartbeatInterval, TimeUnit.MILLISECONDS);
            response.getPartitionToServers().entrySet().forEach(arg_0 -> RssMRAppMaster.lambda$main$3((Configuration)extraConf, arg_0));
            RssMRAppMaster.writeExtraConf(conf, (Configuration)extraConf);
            conf.setFloat("mapreduce.job.reduce.slowstart.completedmaps", 1.0f);
            LOG.warn("close slow start, because RSS does not support it yet");
            conf.setBoolean("yarn.app.mapreduce.am.job.recovery.enable", false);
            LOG.warn("close recovery enable, because RSS doesn't support it yet");
            String jobDirStr = conf.get("mapreduce.job.dir");
            if (jobDirStr == null) {
                throw new RssException("jobDir is empty");
            }
        }
        try {
            RssMRAppMaster.setMainStartedTrue();
            Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new YarnUncaughtExceptionHandler());
            String containerIdStr = System.getenv(ApplicationConstants.Environment.CONTAINER_ID.name());
            RssMRAppMaster.validateInputParam(containerIdStr, ApplicationConstants.Environment.CONTAINER_ID.name());
            String nodeHostString = System.getenv(ApplicationConstants.Environment.NM_HOST.name());
            RssMRAppMaster.validateInputParam(nodeHostString, ApplicationConstants.Environment.NM_HOST.name());
            String nodePortString = System.getenv(ApplicationConstants.Environment.NM_PORT.name());
            RssMRAppMaster.validateInputParam(nodePortString, ApplicationConstants.Environment.NM_PORT.name());
            String nodeHttpPortString = System.getenv(ApplicationConstants.Environment.NM_HTTP_PORT.name());
            RssMRAppMaster.validateInputParam(nodeHttpPortString, ApplicationConstants.Environment.NM_HTTP_PORT.name());
            String appSubmitTimeStr = System.getenv("APP_SUBMIT_TIME_ENV");
            RssMRAppMaster.validateInputParam(appSubmitTimeStr, "APP_SUBMIT_TIME_ENV");
            ContainerId containerId = ContainerId.fromString((String)containerIdStr);
            ApplicationAttemptId applicationAttemptId = containerId.getApplicationAttemptId();
            if (applicationAttemptId != null) {
                CallerContext.setCurrent((CallerContext)new CallerContext.Builder("mr_appmaster_" + applicationAttemptId.toString()).build());
            }
            long appSubmitTime = Long.parseLong(appSubmitTimeStr);
            RssMRAppMaster appMaster = new RssMRAppMaster(applicationAttemptId, containerId, nodeHostString, Integer.parseInt(nodePortString), Integer.parseInt(nodeHttpPortString), appSubmitTime, shuffleWriteClient);
            ShutdownHookManager.get().addShutdownHook((Runnable)new RssMRAppMasterShutdownHook(appMaster), 30);
            MRWebAppUtil.initialize((Configuration)conf);
            String systemPropsToLog = MRApps.getSystemPropertiesToLog((Configuration)conf);
            if (systemPropsToLog != null) {
                LOG.info(systemPropsToLog);
            }
            String jobUserName = System.getenv(ApplicationConstants.Environment.USER.name());
            conf.set("mapreduce.job.user.name", jobUserName);
            RssMRAppMaster.initAndStartAppMaster((MRAppMaster)appMaster, (JobConf)conf, (String)jobUserName);
        }
        catch (Throwable t) {
            LOG.error("Error starting MRAppMaster", t);
            ExitUtil.terminate((int)1, (Throwable)t);
        }
    }

    private static void setMainStartedTrue() throws Exception {
        Field field = MRAppMaster.class.getDeclaredField("mainStarted");
        field.setAccessible(true);
        field.setBoolean(null, true);
        field.setAccessible(false);
    }

    protected ContainerAllocator createContainerAllocator(ClientService clientService, AppContext context) {
        this.rssContainerAllocator = new RssContainerAllocatorRouter(clientService, context);
        return this.rssContainerAllocator;
    }

    private static void validateInputParam(String value, String param) throws IOException {
        if (value == null) {
            String msg = param + " is null";
            LOG.error(msg);
            throw new IOException(msg);
        }
    }

    static void writeExtraConf(JobConf conf, Configuration extraConf) {
        try {
            FileSystem fs = new Cluster((Configuration)conf).getFileSystem();
            String jobDirStr = conf.get("mapreduce.job.dir");
            Path assignmentFile = new Path(jobDirStr, "rss_conf.xml");
            try (FSDataOutputStream out = FileSystem.create((FileSystem)fs, (Path)assignmentFile, (FsPermission)new FsPermission(JobSubmissionFiles.JOB_FILE_PERMISSION));){
                extraConf.writeXml((OutputStream)out);
            }
            FileStatus status = fs.getFileStatus(assignmentFile);
            long currentTs = status.getModificationTime();
            String uri = fs.getUri() + "/" + assignmentFile.toUri();
            String files = conf.get("mapreduce.job.cache.files");
            conf.set("mapreduce.job.cache.files", files == null ? uri : uri + "," + files);
            String ts = conf.get("mapreduce.job.cache.files.timestamps");
            conf.set("mapreduce.job.cache.files.timestamps", ts == null ? String.valueOf(currentTs) : currentTs + "," + ts);
            String vis = conf.get("mapreduce.job.cache.files.visibilities");
            conf.set("mapreduce.job.cache.files.visibilities", vis == null ? "false" : "false," + vis);
            long size = status.getLen();
            String sizes = conf.get("mapreduce.job.cache.files.filesizes");
            conf.set("mapreduce.job.cache.files.filesizes", sizes == null ? String.valueOf(size) : size + "," + sizes);
        }
        catch (IOException | InterruptedException e) {
            LOG.error("Upload extra conf exception", (Throwable)e);
            throw new RssException("Upload extra conf exception ", e);
        }
    }

    public void notifyIsLastAMRetry(boolean isLastAMRetry) {
        LOG.info("Notify RMCommunicator isAMLastRetry: " + isLastAMRetry);
        if (this.rssContainerAllocator != null) {
            this.rssContainerAllocator.setShouldUnregister(isLastAMRetry);
        }
        super.notifyIsLastAMRetry(isLastAMRetry);
    }

    private Job getJob() {
        try {
            Field field = RssMRAppMaster.class.getSuperclass().getDeclaredField("job");
            field.setAccessible(true);
            JobImpl job = (JobImpl)field.get((Object)this);
            field.setAccessible(false);
            return job;
        }
        catch (Exception e) {
            LOG.error("getJob error !" + e.getMessage());
            return null;
        }
    }

    private static /* synthetic */ void lambda$main$3(Configuration extraConf, Map.Entry entry) {
        ArrayList<String> servers = Lists.newArrayList();
        for (ShuffleServerInfo server : (List)entry.getValue()) {
            if (server.getNettyPort() > 0) {
                servers.add(server.getHost() + ":" + server.getGrpcPort() + ":" + server.getNettyPort());
                continue;
            }
            servers.add(server.getHost() + ":" + server.getGrpcPort());
        }
        extraConf.set("mapreduce.rss.assignment.partition." + entry.getKey(), StringUtils.join(servers, (String)","));
    }

    static class RssMRAppMasterShutdownHook
    implements Runnable {
        RssMRAppMaster appMaster;

        RssMRAppMasterShutdownHook(RssMRAppMaster appMaster) {
            this.appMaster = appMaster;
        }

        @Override
        public void run() {
            LOG.info("MRAppMaster received a signal. Signaling RMCommunicator and JobHistoryEventHandler.");
            RssContainerAllocatorRouter allocatorRouter = this.appMaster.rssContainerAllocator;
            if (allocatorRouter != null) {
                allocatorRouter.setSignalled(true);
            }
            this.appMaster.notifyIsLastAMRetry(this.appMaster.isLastAMRetry);
            this.appMaster.stop();
        }
    }

    private final class RssContainerAllocatorRouter
    extends AbstractService
    implements ContainerAllocator,
    RMHeartbeatHandler {
        private final ClientService clientService;
        private final AppContext context;
        private ContainerAllocator containerAllocator;

        RssContainerAllocatorRouter(ClientService clientService, AppContext context) {
            super(RssContainerAllocatorRouter.class.getName());
            this.clientService = clientService;
            this.context = context;
        }

        protected void serviceStart() throws Exception {
            if (RssMRAppMaster.this.getJob().isUber()) {
                MRApps.setupDistributedCacheLocal((Configuration)this.getConfig());
                this.containerAllocator = new LocalContainerAllocator(this.clientService, this.context, RssMRAppMaster.this.rssNmHost, RssMRAppMaster.this.rssNmPort, RssMRAppMaster.this.rssNmHttpPort, RssMRAppMaster.this.rssContainerID);
            } else {
                this.containerAllocator = HadoopShimImpl.createRMContainerAllocator(this.clientService, this.context);
            }
            ((Service)this.containerAllocator).init(this.getConfig());
            ((Service)this.containerAllocator).start();
            super.serviceStart();
        }

        protected void serviceStop() throws Exception {
            ServiceOperations.stop((Service)((Service)this.containerAllocator));
            super.serviceStop();
        }

        public void handle(ContainerAllocatorEvent event) {
            this.containerAllocator.handle((Event)event);
        }

        public void setSignalled(boolean isSignalled) {
            ((RMCommunicator)this.containerAllocator).setSignalled(isSignalled);
        }

        public void setShouldUnregister(boolean shouldUnregister) {
            ((RMCommunicator)this.containerAllocator).setShouldUnregister(shouldUnregister);
        }

        public long getLastHeartbeatTime() {
            return ((RMCommunicator)this.containerAllocator).getLastHeartbeatTime();
        }

        public void runOnNextHeartbeat(Runnable callback) {
            ((RMCommunicator)this.containerAllocator).runOnNextHeartbeat(callback);
        }
    }
}

