/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.coordinator.conf;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import org.apache.uniffle.common.util.RssUtils;
import org.apache.uniffle.coordinator.CoordinatorConf;
import org.apache.uniffle.coordinator.conf.AbstractRssClientConfApplyStrategy;
import org.apache.uniffle.coordinator.conf.DynamicClientConfService;
import org.apache.uniffle.coordinator.conf.RssClientConfFetchInfo;
import org.apache.uniffle.shaded.guava.annotations.VisibleForTesting;

public class RssClientConfApplyManager
implements Closeable {
    private final AbstractRssClientConfApplyStrategy strategy;
    private final DynamicClientConfService dynamicClientConfService;

    public RssClientConfApplyManager(CoordinatorConf conf, DynamicClientConfService dynamicClientConfService) {
        this.dynamicClientConfService = dynamicClientConfService;
        String strategyCls = (String)conf.get(CoordinatorConf.COORDINATOR_CLIENT_CONF_APPLY_STRATEGY);
        this.strategy = (AbstractRssClientConfApplyStrategy)RssUtils.loadExtension(AbstractRssClientConfApplyStrategy.class, (String)strategyCls, (Object)dynamicClientConfService);
    }

    public Map<String, String> apply(RssClientConfFetchInfo rssClientConfFetchInfo) {
        if (rssClientConfFetchInfo.isEmpty()) {
            return this.dynamicClientConfService.getRssClientConf();
        }
        return this.strategy.apply(rssClientConfFetchInfo);
    }

    @VisibleForTesting
    protected AbstractRssClientConfApplyStrategy getStrategy() {
        return this.strategy;
    }

    @Override
    public void close() throws IOException {
    }
}

