/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.coordinator;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.uniffle.client.impl.grpc.ShuffleServerInternalGrpcClient;
import org.apache.uniffle.client.request.RssCancelDecommissionRequest;
import org.apache.uniffle.client.request.RssDecommissionRequest;
import org.apache.uniffle.common.ReconfigurableConfManager;
import org.apache.uniffle.common.ServerStatus;
import org.apache.uniffle.common.exception.InvalidRequestException;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.filesystem.HadoopFilesystemProvider;
import org.apache.uniffle.common.util.JavaUtils;
import org.apache.uniffle.common.util.ThreadUtils;
import org.apache.uniffle.coordinator.ClusterManager;
import org.apache.uniffle.coordinator.CoordinatorConf;
import org.apache.uniffle.coordinator.ServerNode;
import org.apache.uniffle.coordinator.metric.CoordinatorMetrics;
import org.apache.uniffle.shaded.guava.annotations.VisibleForTesting;
import org.apache.uniffle.shaded.guava.cache.Cache;
import org.apache.uniffle.shaded.guava.cache.CacheBuilder;
import org.apache.uniffle.shaded.guava.collect.Lists;
import org.apache.uniffle.shaded.guava.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleClusterManager
implements ClusterManager {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleClusterManager.class);
    private final Map<String, ServerNode> servers = JavaUtils.newConcurrentMap();
    private final Cache<ServerNode, ShuffleServerInternalGrpcClient> clientCache;
    private Set<String> excludedNodes = Sets.newConcurrentHashSet();
    Set<ServerNode> lostNodes = Sets.newHashSet();
    Set<ServerNode> unhealthyNodes = Sets.newHashSet();
    private Map<String, Set<ServerNode>> tagToNodes = JavaUtils.newConcurrentMap();
    private Map<String, String[]> dynamicNodeToTags = new HashMap<String, String[]>();
    private AtomicLong excludeLastModify = new AtomicLong(0L);
    private final AtomicLong nodeTagLastModify = new AtomicLong(0L);
    private long heartbeatTimeout;
    private ReconfigurableConfManager.Reconfigurable<Integer> shuffleNodesMax;
    private ScheduledExecutorService scheduledExecutorService;
    private ScheduledExecutorService checkNodesExecutorService;
    private FileSystem hadoopFileSystem;
    private ScheduledExecutorService checkNodeTagExecutorService;
    private FileSystem fsForNodeTags;
    private long outputAliveServerCount = 0L;
    private final long periodicOutputIntervalTimes;
    private long startTime;
    private boolean startupSilentPeriodEnabled;
    private long startupSilentPeriodDurationMs;
    private boolean readyForServe = false;
    private String excludedNodesPath;
    private Gson gson = new Gson();

    public SimpleClusterManager(CoordinatorConf conf, Configuration hadoopConf) throws Exception {
        String nodeTagsPath;
        this.shuffleNodesMax = conf.getReconfigurableConf(CoordinatorConf.COORDINATOR_SHUFFLE_NODES_MAX);
        this.heartbeatTimeout = conf.getLong(CoordinatorConf.COORDINATOR_HEARTBEAT_TIMEOUT);
        this.scheduledExecutorService = ThreadUtils.getDaemonSingleThreadScheduledExecutor((String)"SimpleClusterManager");
        this.startupSilentPeriodEnabled = (Boolean)conf.get(CoordinatorConf.COORDINATOR_START_SILENT_PERIOD_ENABLED);
        this.startupSilentPeriodDurationMs = (Long)conf.get(CoordinatorConf.COORDINATOR_START_SILENT_PERIOD_DURATION);
        this.periodicOutputIntervalTimes = (Long)conf.get(CoordinatorConf.COORDINATOR_NODES_PERIODIC_OUTPUT_INTERVAL_TIMES);
        this.scheduledExecutorService.scheduleAtFixedRate(this::nodesCheck, this.heartbeatTimeout / 3L, this.heartbeatTimeout / 3L, TimeUnit.MILLISECONDS);
        this.excludedNodesPath = conf.getString(CoordinatorConf.COORDINATOR_EXCLUDE_NODES_FILE_PATH, "");
        if (!StringUtils.isEmpty((CharSequence)this.excludedNodesPath)) {
            this.hadoopFileSystem = HadoopFilesystemProvider.getFilesystem((Path)new Path(this.excludedNodesPath), (Configuration)hadoopConf);
            long updateNodesInterval = conf.getLong(CoordinatorConf.COORDINATOR_EXCLUDE_NODES_CHECK_INTERVAL);
            this.checkNodesExecutorService = ThreadUtils.getDaemonSingleThreadScheduledExecutor((String)"UpdateExcludedNodes");
            this.checkNodesExecutorService.scheduleAtFixedRate(() -> this.updateExcludedNodes(this.excludedNodesPath), 0L, updateNodesInterval, TimeUnit.MILLISECONDS);
        }
        if (!StringUtils.isEmpty((CharSequence)(nodeTagsPath = (String)conf.get(CoordinatorConf.COORDINATOR_NODE_TAGS_FILE_PATH)))) {
            this.fsForNodeTags = HadoopFilesystemProvider.getFilesystem((Path)new Path(nodeTagsPath), (Configuration)hadoopConf);
            long updateNodeTagsInterval = conf.getLong(CoordinatorConf.COORDINATOR_NODE_TAGS_CHECK_INTERVAL);
            this.checkNodeTagExecutorService = ThreadUtils.getDaemonSingleThreadScheduledExecutor((String)"UpdateNodeTags");
            this.checkNodeTagExecutorService.scheduleAtFixedRate(() -> this.updateNodeTag(nodeTagsPath), 0L, updateNodeTagsInterval, TimeUnit.MILLISECONDS);
        }
        long clientExpiredTime = (Long)conf.get(CoordinatorConf.COORDINATOR_NODES_CLIENT_CACHE_EXPIRED);
        int maxClient = (Integer)conf.get(CoordinatorConf.COORDINATOR_NODES_CLIENT_CACHE_MAX);
        this.clientCache = CacheBuilder.newBuilder().expireAfterAccess(clientExpiredTime, TimeUnit.MILLISECONDS).maximumSize(maxClient).removalListener(notify -> ((ShuffleServerInternalGrpcClient)notify.getValue()).close()).build();
        this.startTime = System.currentTimeMillis();
    }

    void nodesCheck() {
        try {
            long timestamp = System.currentTimeMillis();
            for (ServerNode sn : this.servers.values()) {
                if (timestamp - sn.getTimestamp() > this.heartbeatTimeout) {
                    LOG.warn("Heartbeat timeout detect, {} will be removed from node list.", (Object)sn);
                    sn.setStatus(ServerStatus.LOST);
                    this.lostNodes.add(sn);
                    continue;
                }
                if (ServerStatus.UNHEALTHY.equals((Object)sn.getStatus())) {
                    LOG.warn("Found server {} was unhealthy, will not assign it.", (Object)sn);
                    this.unhealthyNodes.add(sn);
                    this.lostNodes.remove(sn);
                    continue;
                }
                this.lostNodes.remove(sn);
                this.unhealthyNodes.remove(sn);
            }
            for (ServerNode server : this.lostNodes) {
                ServerNode sn = this.servers.remove(server.getId());
                this.unhealthyNodes.remove(sn);
                if (sn == null) continue;
                this.clientCache.invalidate(sn);
                for (Set<ServerNode> nodesWithTag : this.tagToNodes.values()) {
                    nodesWithTag.remove(sn);
                }
            }
            if (!this.lostNodes.isEmpty() || this.outputAliveServerCount % this.periodicOutputIntervalTimes == 0L) {
                LOG.info("Alive servers number: {}, ids: {}", (Object)this.servers.size(), this.servers.keySet().stream().collect(Collectors.toList()));
            }
            ++this.outputAliveServerCount;
            CoordinatorMetrics.gaugeUnhealthyServerNum.set((double)this.unhealthyNodes.size());
            CoordinatorMetrics.gaugeTotalServerNum.set((double)this.servers.size());
            CoordinatorMetrics.gaugeLostServerNum.set((double)this.lostNodes.size());
            HashSet<String> allServers = new HashSet<String>(this.servers.keySet());
            allServers.removeAll(this.excludedNodes);
            for (ServerNode unhealthyNode : this.unhealthyNodes) {
                allServers.remove(unhealthyNode.getId());
            }
            CoordinatorMetrics.gaugeActiveServerNum.set((double)allServers.size());
        }
        catch (Exception e) {
            LOG.warn("Error happened in nodesCheck", (Throwable)e);
        }
    }

    @VisibleForTesting
    public void nodesCheckTest() {
        this.nodesCheck();
    }

    private void updateNodeTag(String path) {
        try {
            Path hadoopPath = new Path(path);
            FileStatus fileStatus = this.fsForNodeTags.getFileStatus(hadoopPath);
            if (fileStatus != null && fileStatus.isFile()) {
                long latestModificationTime = fileStatus.getModificationTime();
                if (this.nodeTagLastModify.get() != latestModificationTime) {
                    this.dynamicNodeToTags = this.parseNodeTagFile((DataInputStream)this.fsForNodeTags.open(hadoopPath));
                    this.nodeTagLastModify.set(latestModificationTime);
                    System.out.println("Updated node tags [{}]" + this.gson.toJson(this.dynamicNodeToTags));
                    LOG.info("Updated node tags [{}]", (Object)this.gson.toJson(this.dynamicNodeToTags));
                }
            } else {
                LOG.info("Node tags file not found, resetting node tags to empty.");
                this.dynamicNodeToTags = new HashMap<String, String[]>();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOG.info("Node tags file not found, resetting node tags to empty.");
            this.dynamicNodeToTags = new HashMap<String, String[]>();
        }
        catch (Exception e) {
            LOG.warn("Error when updating node tags, the node tags file path: {}.", (Object)path, (Object)e);
        }
    }

    private Map<String, String[]> parseNodeTagFile(DataInputStream fsDataInputStream) throws IOException {
        HashMap<String, String[]> tagsMap = new HashMap<String, String[]>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fsDataInputStream, StandardCharsets.UTF_8));){
            String line;
            while ((line = br.readLine()) != null) {
                if (StringUtils.isEmpty((CharSequence)line) || line.trim().startsWith("#")) continue;
                String[] segments = StringUtils.split((String)line, (String)" ");
                if (segments.length != 2) {
                    LOG.warn("Invalid tag line: {}, ignored.", (Object)line);
                }
                String node = segments[0];
                String tagStr = segments[1];
                String[] tags = StringUtils.split((String)tagStr, (String)",");
                tagsMap.put(node, tags);
            }
        }
        return tagsMap;
    }

    private synchronized void updateExcludedNodes(String path) {
        int originalExcludedNodesNumber = this.excludedNodes.size();
        try {
            Path hadoopPath = new Path(path);
            FileStatus fileStatus = this.hadoopFileSystem.getFileStatus(hadoopPath);
            if (fileStatus != null && fileStatus.isFile()) {
                long latestModificationTime = fileStatus.getModificationTime();
                if (this.excludeLastModify.get() != latestModificationTime) {
                    this.excludedNodes = this.parseExcludedNodesFile((DataInputStream)this.hadoopFileSystem.open(hadoopPath));
                    LOG.info("Updated exclude nodes and {} nodes were marked as excluded nodes", (Object)this.excludedNodes.size());
                    this.excludeLastModify.set(latestModificationTime);
                }
            } else {
                this.excludedNodes = Sets.newConcurrentHashSet();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.excludedNodes = Sets.newConcurrentHashSet();
        }
        catch (Exception e) {
            LOG.warn("Error when updating exclude nodes, the exclude nodes file path: {}.", (Object)path, (Object)e);
        }
        int newlyExcludedNodesNumber = this.excludedNodes.size();
        if (newlyExcludedNodesNumber != originalExcludedNodesNumber) {
            LOG.info("Exclude nodes number: {}, nodes list: {}", (Object)newlyExcludedNodesNumber, this.excludedNodes);
        }
        CoordinatorMetrics.gaugeExcludeServerNum.set((double)this.excludedNodes.size());
    }

    private Set<String> parseExcludedNodesFile(DataInputStream fsDataInputStream) throws IOException {
        Set<String> nodes = Sets.newConcurrentHashSet();
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fsDataInputStream, StandardCharsets.UTF_8));){
            String line;
            while ((line = br.readLine()) != null) {
                if (StringUtils.isEmpty((CharSequence)line) || line.trim().startsWith("#")) continue;
                nodes.add(line.trim());
            }
        }
        return nodes;
    }

    private void writeExcludedNodes2File(List<String> excludedNodes) throws IOException {
        if (this.hadoopFileSystem == null) {
            return;
        }
        Path hadoopPath = new Path(this.excludedNodesPath);
        FileStatus fileStatus = this.hadoopFileSystem.getFileStatus(hadoopPath);
        if (fileStatus != null && fileStatus.isFile()) {
            String tempExcludedNodesPath = this.excludedNodesPath.concat("_tmp");
            Path tmpHadoopPath = new Path(tempExcludedNodesPath);
            if (this.hadoopFileSystem.exists(tmpHadoopPath)) {
                this.hadoopFileSystem.delete(tmpHadoopPath, true);
            }
            try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)this.hadoopFileSystem.create(tmpHadoopPath, true), StandardCharsets.UTF_8));){
                for (String excludedNode : excludedNodes) {
                    bufferedWriter.write(excludedNode);
                    bufferedWriter.newLine();
                }
            }
            this.hadoopFileSystem.delete(hadoopPath, true);
            this.hadoopFileSystem.rename(tmpHadoopPath, hadoopPath);
        }
    }

    private synchronized boolean putInExcludedNodesFile(List<String> excludedNodes) throws IOException {
        if (this.hadoopFileSystem == null) {
            return false;
        }
        Path hadoopPath = new Path(this.excludedNodesPath);
        Set<String> alreadyExistExcludedNodes = this.parseExcludedNodesFile((DataInputStream)this.hadoopFileSystem.open(hadoopPath));
        List<String> newAddExcludedNodes = excludedNodes.stream().filter(node -> !alreadyExistExcludedNodes.contains(node)).collect(Collectors.toList());
        newAddExcludedNodes.addAll(alreadyExistExcludedNodes);
        this.writeExcludedNodes2File(newAddExcludedNodes);
        return true;
    }

    private synchronized boolean removeExcludedNodesFile(List<String> excludedNodes) throws IOException {
        if (this.hadoopFileSystem == null) {
            return false;
        }
        Path hadoopPath = new Path(this.excludedNodesPath);
        Set<String> alreadyExistExcludedNodes = this.parseExcludedNodesFile((DataInputStream)this.hadoopFileSystem.open(hadoopPath));
        alreadyExistExcludedNodes.removeAll(excludedNodes);
        this.writeExcludedNodes2File(Lists.newArrayList(alreadyExistExcludedNodes));
        return true;
    }

    @Override
    public void add(ServerNode node) {
        if (!this.servers.containsKey(node.getId())) {
            LOG.info("Newly registering node: {}", (Object)node.getId());
        }
        Set<String> tags = node.getTags();
        for (Set<ServerNode> nodes : this.tagToNodes.values()) {
            nodes.remove(node);
        }
        for (String tag : tags) {
            Set nodes = this.tagToNodes.computeIfAbsent(tag, key -> Sets.newConcurrentHashSet());
            nodes.add(node);
        }
        this.servers.put(node.getId(), node);
        String[] dynamicTags = this.dynamicNodeToTags.get(node.getId());
        if (dynamicTags != null) {
            for (String tag : dynamicTags) {
                Set nodes = this.tagToNodes.computeIfAbsent(tag, key -> Sets.newConcurrentHashSet());
                node.getTags().add(tag);
                nodes.add(node);
            }
        }
    }

    @Override
    public List<ServerNode> getServerList(Set<String> requiredTags) {
        ArrayList<ServerNode> availableNodes = Lists.newArrayList();
        for (ServerNode node : this.servers.values()) {
            if (!ServerStatus.ACTIVE.equals((Object)node.getStatus()) || this.excludedNodes.contains(node.getId()) || !node.getTags().containsAll(requiredTags)) continue;
            availableNodes.add(node);
        }
        return availableNodes;
    }

    @Override
    public List<ServerNode> getServerList(Set<String> requiredTags, Set<String> faultyServerIds) {
        ArrayList<ServerNode> availableNodes = Lists.newArrayList();
        for (ServerNode node : this.servers.values()) {
            if (!ServerStatus.ACTIVE.equals((Object)node.getStatus()) || !this.isNodeAvailable(requiredTags, faultyServerIds, node)) continue;
            availableNodes.add(node);
        }
        return availableNodes;
    }

    private boolean isNodeAvailable(Set<String> requiredTags, Set<String> faultyServerIds, ServerNode node) {
        if (faultyServerIds != null && faultyServerIds.contains(node.getId())) {
            return false;
        }
        return !this.excludedNodes.contains(node.getId()) && node.getTags().containsAll(requiredTags);
    }

    @Override
    public List<ServerNode> getLostServerList() {
        return Lists.newArrayList(this.lostNodes);
    }

    @Override
    public List<ServerNode> getUnhealthyServerList() {
        return Lists.newArrayList(this.unhealthyNodes);
    }

    @Override
    public Set<String> getExcludedNodes() {
        return this.excludedNodes;
    }

    public Map<String, Set<ServerNode>> getTagToNodes() {
        return this.tagToNodes;
    }

    @VisibleForTesting
    Map<String, String[]> getDynamicNodeToTags() {
        return this.dynamicNodeToTags;
    }

    @Override
    public int getNodesNum() {
        return this.servers.size();
    }

    @Override
    public List<ServerNode> list() {
        for (Map.Entry<String, ServerNode> entry : this.servers.entrySet()) {
            ServerNode serverNode = entry.getValue();
        }
        return Lists.newArrayList(this.servers.values());
    }

    @Override
    public boolean deleteLostServerById(String serverId) {
        if (StringUtils.isNotBlank((CharSequence)serverId)) {
            return this.lostNodes.remove(new ServerNode(serverId));
        }
        return false;
    }

    @Override
    public boolean addExcludedNodes(List<String> excludedNodeIds) {
        try {
            boolean successFlag = this.putInExcludedNodesFile(excludedNodeIds);
            this.excludedNodes.addAll(excludedNodeIds);
            return successFlag;
        }
        catch (IOException e) {
            LOG.warn("Because {}, failed to add blacklist.", (Object)e.getMessage());
            return false;
        }
    }

    @Override
    public boolean removeExcludedNodesFromFile(List<String> excludedNodeIds) {
        try {
            if (this.removeExcludedNodesFile(excludedNodeIds)) {
                this.excludedNodes.removeAll(excludedNodeIds);
                return true;
            }
        }
        catch (IOException e) {
            LOG.warn("Because {}, failed to add blacklist.", (Object)e.getMessage());
        }
        return false;
    }

    @VisibleForTesting
    public void clear() {
        this.servers.clear();
    }

    @Override
    public int getShuffleNodesMax() {
        return (Integer)this.shuffleNodesMax.get();
    }

    @Override
    public boolean isReadyForServe() {
        if (!this.startupSilentPeriodEnabled) {
            return true;
        }
        if (!this.readyForServe && System.currentTimeMillis() - this.startTime > this.startupSilentPeriodDurationMs) {
            this.readyForServe = true;
        }
        return this.readyForServe;
    }

    @Override
    public void decommission(String serverId) {
        ServerNode serverNode = this.getServerNodeById(serverId);
        this.getShuffleServerClient(serverNode).decommission(new RssDecommissionRequest());
    }

    @Override
    public void cancelDecommission(String serverId) {
        ServerNode serverNode = this.getServerNodeById(serverId);
        this.getShuffleServerClient(serverNode).cancelDecommission(new RssCancelDecommissionRequest());
    }

    private ShuffleServerInternalGrpcClient getShuffleServerClient(ServerNode serverNode) {
        try {
            return this.clientCache.get(serverNode, () -> new ShuffleServerInternalGrpcClient(serverNode.getIp(), serverNode.getGrpcPort()));
        }
        catch (ExecutionException e) {
            throw new RssException((Throwable)e);
        }
    }

    @Override
    public ServerNode getServerNodeById(String serverId) {
        ServerNode serverNode = this.servers.get(serverId);
        if (serverNode == null) {
            throw new InvalidRequestException("Server Id [" + serverId + "] not found!");
        }
        return serverNode;
    }

    @Override
    public void close() throws IOException {
        if (this.hadoopFileSystem != null) {
            this.hadoopFileSystem.close();
        }
        if (this.fsForNodeTags != null) {
            this.fsForNodeTags.close();
        }
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdown();
        }
        if (this.checkNodesExecutorService != null) {
            this.checkNodesExecutorService.shutdown();
        }
        if (this.checkNodeTagExecutorService != null) {
            this.checkNodeTagExecutorService.shutdown();
        }
    }

    @VisibleForTesting
    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    @VisibleForTesting
    public void setReadyForServe(boolean readyForServe) {
        this.readyForServe = readyForServe;
    }

    @VisibleForTesting
    public void setStartupSilentPeriodEnabled(boolean startupSilentPeriodEnabled) {
        this.startupSilentPeriodEnabled = startupSilentPeriodEnabled;
    }

    @VisibleForTesting
    public Map<String, ServerNode> getServers() {
        return this.servers;
    }
}

