/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.client.impl.grpc;

import java.util.concurrent.TimeUnit;
import org.apache.uniffle.client.api.ShuffleManagerClient;
import org.apache.uniffle.client.impl.grpc.GrpcClient;
import org.apache.uniffle.client.request.RssGetShuffleResultForMultiPartRequest;
import org.apache.uniffle.client.request.RssGetShuffleResultRequest;
import org.apache.uniffle.client.request.RssPartitionToShuffleServerRequest;
import org.apache.uniffle.client.request.RssReassignOnBlockSendFailureRequest;
import org.apache.uniffle.client.request.RssReportShuffleFetchFailureRequest;
import org.apache.uniffle.client.request.RssReportShuffleReadMetricRequest;
import org.apache.uniffle.client.request.RssReportShuffleResultRequest;
import org.apache.uniffle.client.request.RssReportShuffleWriteFailureRequest;
import org.apache.uniffle.client.request.RssReportShuffleWriteMetricRequest;
import org.apache.uniffle.client.response.RssGetShuffleResultResponse;
import org.apache.uniffle.client.response.RssReassignOnBlockSendFailureResponse;
import org.apache.uniffle.client.response.RssReassignOnStageRetryResponse;
import org.apache.uniffle.client.response.RssReportShuffleFetchFailureResponse;
import org.apache.uniffle.client.response.RssReportShuffleReadMetricResponse;
import org.apache.uniffle.client.response.RssReportShuffleResultResponse;
import org.apache.uniffle.client.response.RssReportShuffleWriteFailureResponse;
import org.apache.uniffle.client.response.RssReportShuffleWriteMetricResponse;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.proto.RssProtos;
import org.apache.uniffle.proto.ShuffleManagerGrpc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuffleManagerGrpcClient
extends GrpcClient
implements ShuffleManagerClient {
    private static final Logger LOG = LoggerFactory.getLogger(ShuffleManagerGrpcClient.class);
    private final long rpcTimeout;
    private ShuffleManagerGrpc.ShuffleManagerBlockingStub blockingStub;

    public ShuffleManagerGrpcClient(String host, int port, long rpcTimeout) {
        this(host, port, rpcTimeout, 3);
    }

    public ShuffleManagerGrpcClient(String host, int port, long rpcTimeout, int maxRetryAttempts) {
        this(host, port, rpcTimeout, maxRetryAttempts, true);
    }

    public ShuffleManagerGrpcClient(String host, int port, long rpcTimeout, int maxRetryAttempts, boolean usePlaintext) {
        super(host, port, maxRetryAttempts, usePlaintext);
        this.blockingStub = ShuffleManagerGrpc.newBlockingStub(this.channel);
        this.rpcTimeout = rpcTimeout;
    }

    public ShuffleManagerGrpc.ShuffleManagerBlockingStub getBlockingStub() {
        return (ShuffleManagerGrpc.ShuffleManagerBlockingStub)this.blockingStub.withDeadlineAfter(this.rpcTimeout, TimeUnit.MILLISECONDS);
    }

    public String getDesc() {
        return "Shuffle manager grpc client ref " + this.host + ":" + this.port;
    }

    @Override
    public RssReportShuffleFetchFailureResponse reportShuffleFetchFailure(RssReportShuffleFetchFailureRequest request) {
        RssProtos.ReportShuffleFetchFailureRequest protoRequest = request.toProto();
        try {
            RssProtos.ReportShuffleFetchFailureResponse response = this.getBlockingStub().reportShuffleFetchFailure(protoRequest);
            return RssReportShuffleFetchFailureResponse.fromProto(response);
        }
        catch (Exception e) {
            String msg = "Report shuffle fetch failure to host:port[" + this.host + ":" + this.port + "] failed";
            LOG.warn(msg, (Throwable)e);
            throw new RssException(msg, e);
        }
    }

    @Override
    public RssReassignOnStageRetryResponse getPartitionToShufflerServerWithStageRetry(RssPartitionToShuffleServerRequest req) {
        RssProtos.PartitionToShuffleServerRequest protoRequest = req.toProto();
        RssProtos.ReassignOnStageRetryResponse partitionToShufflerServer = this.getBlockingStub().getPartitionToShufflerServerWithStageRetry(protoRequest);
        RssReassignOnStageRetryResponse rssReassignOnStageRetryResponse = RssReassignOnStageRetryResponse.fromProto(partitionToShufflerServer);
        return rssReassignOnStageRetryResponse;
    }

    @Override
    public RssReassignOnBlockSendFailureResponse getPartitionToShufflerServerWithBlockRetry(RssPartitionToShuffleServerRequest req) {
        RssProtos.PartitionToShuffleServerRequest protoRequest = req.toProto();
        RssProtos.ReassignOnBlockSendFailureResponse partitionToShufflerServer = this.getBlockingStub().getPartitionToShufflerServerWithBlockRetry(protoRequest);
        RssReassignOnBlockSendFailureResponse rssReassignOnBlockSendFailureResponse = RssReassignOnBlockSendFailureResponse.fromProto(partitionToShufflerServer);
        return rssReassignOnBlockSendFailureResponse;
    }

    @Override
    public RssReportShuffleWriteFailureResponse reportShuffleWriteFailure(RssReportShuffleWriteFailureRequest request) {
        RssProtos.ReportShuffleWriteFailureRequest protoRequest = request.toProto();
        try {
            RssProtos.ReportShuffleWriteFailureResponse response = this.getBlockingStub().reportShuffleWriteFailure(protoRequest);
            return RssReportShuffleWriteFailureResponse.fromProto(response);
        }
        catch (Exception e) {
            String msg = "Report shuffle fetch failure to host:port[" + this.host + ":" + this.port + "] failed";
            LOG.warn(msg, (Throwable)e);
            throw new RssException(msg, e);
        }
    }

    @Override
    public RssReassignOnBlockSendFailureResponse reassignOnBlockSendFailure(RssReassignOnBlockSendFailureRequest request) {
        RssProtos.RssReassignOnBlockSendFailureRequest protoReq = RssReassignOnBlockSendFailureRequest.toProto(request);
        RssProtos.ReassignOnBlockSendFailureResponse response = this.getBlockingStub().reassignOnBlockSendFailure(protoReq);
        return RssReassignOnBlockSendFailureResponse.fromProto(response);
    }

    @Override
    public RssGetShuffleResultResponse getShuffleResult(RssGetShuffleResultRequest request) {
        RssProtos.GetShuffleResultResponse response = this.getBlockingStub().getShuffleResult(request.toProto());
        return RssGetShuffleResultResponse.fromProto(response);
    }

    @Override
    public RssGetShuffleResultResponse getShuffleResultForMultiPart(RssGetShuffleResultForMultiPartRequest request) {
        RssProtos.GetShuffleResultForMultiPartResponse response = this.getBlockingStub().getShuffleResultForMultiPart(request.toProto());
        return RssGetShuffleResultResponse.fromProto(response);
    }

    @Override
    public RssReportShuffleResultResponse reportShuffleResult(RssReportShuffleResultRequest request) {
        RssProtos.ReportShuffleResultResponse response = this.getBlockingStub().reportShuffleResult(request.toProto());
        return RssReportShuffleResultResponse.fromProto(response);
    }

    @Override
    public RssReportShuffleWriteMetricResponse reportShuffleWriteMetric(RssReportShuffleWriteMetricRequest request) {
        RssProtos.ReportShuffleWriteMetricResponse response = this.getBlockingStub().reportShuffleWriteMetric(request.toProto());
        return RssReportShuffleWriteMetricResponse.fromProto(response);
    }

    @Override
    public RssReportShuffleReadMetricResponse reportShuffleReadMetric(RssReportShuffleReadMetricRequest request) {
        RssProtos.ReportShuffleReadMetricResponse response = this.getBlockingStub().reportShuffleReadMetric(request.toProto());
        return RssReportShuffleReadMetricResponse.fromProto(response);
    }

    @Override
    public boolean isClosed() {
        return this.channel.isShutdown() || this.channel.isTerminated();
    }
}

