/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.client.api;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.uniffle.client.PartitionDataReplicaRequirementTracking;
import org.apache.uniffle.client.response.SendShuffleDataResult;
import org.apache.uniffle.common.PartitionRange;
import org.apache.uniffle.common.RemoteStorageInfo;
import org.apache.uniffle.common.ShuffleAssignmentsInfo;
import org.apache.uniffle.common.ShuffleBlockInfo;
import org.apache.uniffle.common.ShuffleDataDistributionType;
import org.apache.uniffle.common.ShuffleServerInfo;
import org.apache.uniffle.proto.RssProtos;
import org.apache.uniffle.shaded.org.roaringbitmap.longlong.Roaring64NavigableMap;

public interface ShuffleWriteClient {
    default public SendShuffleDataResult sendShuffleData(String appId, int stageAttemptNumber, List<ShuffleBlockInfo> shuffleBlockInfoList, Supplier<Boolean> needCancelRequest) {
        throw new UnsupportedOperationException(this.getClass().getName() + " doesn't implement getShuffleAssignments with faultyServerIds");
    }

    public SendShuffleDataResult sendShuffleData(String var1, List<ShuffleBlockInfo> var2, Supplier<Boolean> var3);

    public void sendAppHeartbeat(String var1, long var2);

    public void registerApplicationInfo(String var1, long var2, String var4);

    default public void registerShuffle(ShuffleServerInfo shuffleServerInfo, String appId, int shuffleId, List<PartitionRange> partitionRanges, RemoteStorageInfo remoteStorage, ShuffleDataDistributionType dataDistributionType, int maxConcurrencyPerPartitionToWrite) {
        this.registerShuffle(shuffleServerInfo, appId, shuffleId, partitionRanges, remoteStorage, dataDistributionType, maxConcurrencyPerPartitionToWrite, null, Collections.emptyMap());
    }

    default public void registerShuffle(ShuffleServerInfo shuffleServerInfo, String appId, int shuffleId, List<PartitionRange> partitionRanges, RemoteStorageInfo remoteStorage, ShuffleDataDistributionType dataDistributionType, int maxConcurrencyPerPartitionToWrite, Map<String, String> properties) {
        this.registerShuffle(shuffleServerInfo, appId, shuffleId, partitionRanges, remoteStorage, dataDistributionType, maxConcurrencyPerPartitionToWrite, null, properties);
    }

    default public void registerShuffle(ShuffleServerInfo shuffleServerInfo, String appId, int shuffleId, List<PartitionRange> partitionRanges, RemoteStorageInfo remoteStorage, ShuffleDataDistributionType dataDistributionType, int maxConcurrencyPerPartitionToWrite, RssProtos.MergeContext mergeContext) {
        this.registerShuffle(shuffleServerInfo, appId, shuffleId, partitionRanges, remoteStorage, dataDistributionType, maxConcurrencyPerPartitionToWrite, mergeContext, Collections.emptyMap());
    }

    public void registerShuffle(ShuffleServerInfo var1, String var2, int var3, List<PartitionRange> var4, RemoteStorageInfo var5, ShuffleDataDistributionType var6, int var7, RssProtos.MergeContext var8, Map<String, String> var9);

    public boolean sendCommit(Set<ShuffleServerInfo> var1, String var2, int var3, int var4);

    @Deprecated
    default public void registerCoordinators(String coordinators) {
        this.registerCoordinators(coordinators, 0L, 0);
    }

    public void registerCoordinators(String var1, long var2, int var4);

    public Map<String, String> fetchClientConf(int var1);

    public RemoteStorageInfo fetchRemoteStorage(String var1);

    public void reportShuffleResult(Map<ShuffleServerInfo, Map<Integer, Set<Long>>> var1, String var2, int var3, long var4, int var6);

    default public void reportShuffleResult(Map<ShuffleServerInfo, Map<Integer, Set<Long>>> serverToPartitionToBlockIds, String appId, int shuffleId, long taskAttemptId, int bitmapNum, Set<ShuffleServerInfo> reportFailureServers, boolean enableWriteFailureRetry) {
    }

    public ShuffleAssignmentsInfo getShuffleAssignments(String var1, int var2, int var3, int var4, Set<String> var5, int var6, int var7, Set<String> var8, long var9, int var11);

    default public ShuffleAssignmentsInfo getShuffleAssignments(String appId, int shuffleId, int partitionNum, int partitionNumPerRange, Set<String> requiredTags, int assignmentShuffleServerNumber, int estimateTaskConcurrency, Set<String> faultyServerIds) {
        return this.getShuffleAssignments(appId, shuffleId, partitionNum, partitionNumPerRange, requiredTags, assignmentShuffleServerNumber, estimateTaskConcurrency, faultyServerIds, 0L, 0);
    }

    default public ShuffleAssignmentsInfo getShuffleAssignments(String appId, int shuffleId, int partitionNum, int partitionNumPerRange, Set<String> requiredTags, int assignmentShuffleServerNumber, int estimateTaskConcurrency) {
        return this.getShuffleAssignments(appId, shuffleId, partitionNum, partitionNumPerRange, requiredTags, assignmentShuffleServerNumber, estimateTaskConcurrency, Collections.emptySet());
    }

    public Roaring64NavigableMap getShuffleResult(String var1, Set<ShuffleServerInfo> var2, String var3, int var4, int var5);

    public Roaring64NavigableMap getShuffleResultForMultiPart(String var1, Map<ShuffleServerInfo, Set<Integer>> var2, String var3, int var4, Set<Integer> var5, PartitionDataReplicaRequirementTracking var6);

    public void close();

    public void unregisterShuffle(String var1, int var2);

    public void unregisterShuffle(String var1);

    public void startSortMerge(Set<ShuffleServerInfo> var1, String var2, int var3, int var4, Roaring64NavigableMap var5);
}

