/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ps.service.main;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.ducc.ps.service.IService;
import org.apache.uima.ducc.ps.service.ServiceConfiguration;
import org.apache.uima.ducc.ps.service.builders.PullServiceStepBuilder;
import org.apache.uima.ducc.ps.service.dgen.DeployableGeneration;
import org.apache.uima.ducc.ps.service.errors.IServiceErrorHandler;
import org.apache.uima.ducc.ps.service.errors.ServiceException;
import org.apache.uima.ducc.ps.service.errors.ServiceInitializationException;
import org.apache.uima.ducc.ps.service.errors.builtin.WindowBasedErrorHandler;
import org.apache.uima.ducc.ps.service.jmx.JMXAgent;
import org.apache.uima.ducc.ps.service.main.Application;
import org.apache.uima.ducc.ps.service.processor.IServiceProcessor;
import org.apache.uima.ducc.ps.service.processor.uima.UimaAsServiceProcessor;
import org.apache.uima.ducc.ps.service.processor.uima.UimaServiceProcessor;
import org.apache.uima.ducc.ps.service.registry.IRegistryClient;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public class ServiceWrapper
implements Application {
    private Logger logger = UIMAFramework.getLogger(ServiceWrapper.class);
    private IService service = null;
    private ServiceConfiguration serviceConfiguration = new ServiceConfiguration();
    private JMXAgent jmxAgent;

    private void addShutdownHook() {
        ServiceShutdownHook shutdownHook = new ServiceShutdownHook(this, this.logger);
        Runtime.getRuntime().addShutdownHook(shutdownHook);
    }

    private String startJmxAgent() throws ServiceInitializationException {
        this.jmxAgent = new JMXAgent(this.serviceConfiguration.getServiceJmxConnectURL(), this.logger);
        int rmiRegistryPort = this.jmxAgent.initialize();
        return this.jmxAgent.start(rmiRegistryPort);
    }

    private IServiceProcessor createProcessor(String analysisEngineDescriptorPath, String[] args) throws ServiceInitializationException {
        IServiceProcessor serviceProcessor = null;
        if (this.serviceConfiguration.getCustomProcessorClass() != null) {
            try {
                Class<?> clz = Class.forName(this.serviceConfiguration.getCustomProcessorClass());
                if (!IServiceProcessor.class.isAssignableFrom(clz)) {
                    throw new ServiceInitializationException(this.serviceConfiguration.getCustomProcessorClass() + " Processor Class does not implement IServiceProcessor ");
                }
                serviceProcessor = (IServiceProcessor)clz.newInstance();
                int maxErrors = 0;
                int windowSize = 0;
                if (this.serviceConfiguration.getMaxErrors() != null) {
                    maxErrors = Integer.parseInt(this.serviceConfiguration.getMaxErrors());
                }
                if (this.serviceConfiguration.getMaxErrors() != null) {
                    windowSize = Integer.parseInt(this.serviceConfiguration.getErrorWindowSize());
                }
                serviceProcessor.setErrorHandlerWindow(maxErrors, windowSize);
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "", (Throwable)e);
                throw new ServiceInitializationException("Unable to instantiate Custom Processor from class:" + this.serviceConfiguration.getCustomProcessorClass());
            }
        } else if ("uima".equals(this.serviceConfiguration.getJpType())) {
            serviceProcessor = new UimaServiceProcessor(analysisEngineDescriptorPath, this.serviceConfiguration);
        } else if ("uima-as".equals(this.serviceConfiguration.getJpType())) {
            serviceProcessor = new UimaAsServiceProcessor(args, this.serviceConfiguration);
        } else {
            throw new RuntimeException("Invalid deployment. Set either -Dducc.deploy.JpType=[uima,uima-as] or provide -Dducc.deploy.custom.processor.class=XX where XX implements IServiceProcessor ");
        }
        return serviceProcessor;
    }

    private IServiceErrorHandler getErrorHandler() {
        int maxErrors = 1;
        int windowSize = 1;
        if (this.serviceConfiguration.getMaxErrors() != null) {
            maxErrors = Integer.parseInt(this.serviceConfiguration.getMaxErrors());
        }
        if (this.serviceConfiguration.getErrorWindowSize() != null) {
            windowSize = Integer.parseInt(this.serviceConfiguration.getErrorWindowSize());
        }
        return new WindowBasedErrorHandler().withMaxFrameworkErrors(maxErrors).withProcessErrorWindow(windowSize).build();
    }

    private boolean isPiecesParts(ServiceConfiguration serviceConfiguration) {
        return "uima".equals(serviceConfiguration.getJpType());
    }

    private boolean generateDD(ServiceConfiguration serviceConfiguration) {
        return serviceConfiguration.getAnalysisEngineDescriptorPath() == null || serviceConfiguration.getAnalysisEngineDescriptorPath().endsWith(".xml") && !new File(serviceConfiguration.getAnalysisEngineDescriptorPath()).canRead();
    }

    public void initialize(String[] args) throws ServiceInitializationException, ServiceException {
        String analysisEngineDescriptorPath;
        this.serviceConfiguration.collectProperties(args);
        this.serviceConfiguration.validateProperties();
        this.addShutdownHook();
        String serviceJmxConnectString = this.startJmxAgent();
        this.logger.log(Level.INFO, "Deploying service with JMX enabled - clients can connect using jmx URL:" + serviceJmxConnectString);
        this.serviceConfiguration.setServiceJmxConnectURL(serviceJmxConnectString);
        if (this.isPiecesParts(this.serviceConfiguration)) {
            if (this.generateDD(this.serviceConfiguration)) {
                DeployableGeneration dg = new DeployableGeneration(this.serviceConfiguration);
                try {
                    analysisEngineDescriptorPath = dg.generate(true);
                    this.logger.log(Level.INFO, "Deploying UIMA based service using generated (pieces-parts) AE descriptor " + analysisEngineDescriptorPath);
                }
                catch (Exception e) {
                    throw new ServiceException("Unable to generate AE descriptor from parts");
                }
            } else {
                analysisEngineDescriptorPath = this.serviceConfiguration.getAnalysisEngineDescriptorPath();
            }
        } else {
            analysisEngineDescriptorPath = this.serviceConfiguration.getAnalysisEngineDescriptorPath();
            if (analysisEngineDescriptorPath != null) {
                this.logger.log(Level.INFO, "Deploying UIMA based service using provided descriptor " + analysisEngineDescriptorPath);
            }
        }
        IServiceProcessor processor = this.createProcessor(analysisEngineDescriptorPath, args);
        Objects.requireNonNull(processor, "Unable to instantiate IServiceProcessor");
        this.service = this.serviceConfiguration.getCustomRegistryClass() != null ? PullServiceStepBuilder.newBuilder(this).withProcessor(processor).withRegistry(this.getRegistryClient()).withType(this.serviceConfiguration.getServiceType()).withScaleout(Integer.valueOf(this.serviceConfiguration.getThreadCount())).withWaitOnNoTask(this.serviceConfiguration.getWaitTime()).withOptionalsDone().build() : PullServiceStepBuilder.newBuilder(this).withProcessor(processor).withClientURL(this.serviceConfiguration.getClientURL()).withType(this.serviceConfiguration.getServiceType()).withScaleout(Integer.valueOf(this.serviceConfiguration.getThreadCount())).withWaitOnNoTask(this.serviceConfiguration.getWaitTime()).withOptionalsDone().build();
        this.service.initialize();
    }

    private IRegistryClient getRegistryClient() throws ServiceInitializationException {
        IRegistryClient registryClient = null;
        if (this.serviceConfiguration.getCustomRegistryClass() != null) {
            try {
                Class<?> clz = Class.forName(this.serviceConfiguration.getCustomRegistryClass());
                if (!IRegistryClient.class.isAssignableFrom(clz)) {
                    throw new ServiceInitializationException(this.serviceConfiguration.getCustomRegistryClass() + " Registry Client Class does not implement IRegistryClient ");
                }
                try {
                    Constructor<?> ctor = clz.getConstructor(String.class);
                    registryClient = (IRegistryClient)ctor.newInstance(this.serviceConfiguration.getClientURL());
                }
                catch (NoSuchMethodException ee) {
                    registryClient = (IRegistryClient)clz.newInstance();
                }
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "", (Throwable)e);
                throw new ServiceInitializationException("Unable to instantiate Custom Registry Client from class:" + this.serviceConfiguration.getCustomRegistryClass());
            }
        }
        return registryClient;
    }

    public void start() throws ServiceException, ExecutionException {
        this.service.start();
    }

    public void stopJmx() {
        try {
            if (Objects.nonNull(this.jmxAgent)) {
                this.jmxAgent.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stop() {
        try {
            this.service.stop();
            System.out.println(">>>>>> ServiceWrapper stopping JMX Agent");
            this.jmxAgent.stop();
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "", (Throwable)e);
        }
    }

    public void quiesceAndStop() {
        try {
            this.service.quiesceAndStop();
            this.logger.log(Level.INFO, "Stoppng JMX Agent");
            System.out.println("Stopping JMX Agent");
            this.jmxAgent.stop();
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "", (Throwable)e);
        }
    }

    public static void main(String[] args) {
        ServiceWrapper wrapper = null;
        try {
            wrapper = new ServiceWrapper();
            wrapper.initialize(args);
            wrapper.start();
        }
        catch (Throwable e) {
            UIMAFramework.getLogger().log(Level.WARNING, "", e);
            if (wrapper != null) {
                wrapper.stop();
            }
            System.exit(-1);
        }
    }

    @Override
    public void onServiceStop() {
        this.stopJmx();
    }

    static class ServiceShutdownHook
    extends Thread {
        private ServiceWrapper serviceWrapper;
        private Logger logger;

        public ServiceShutdownHook(ServiceWrapper serviceWrapper, Logger logger) {
            this.serviceWrapper = serviceWrapper;
            this.logger = logger;
        }

        @Override
        public void run() {
            try {
                System.out.println("Pull Service Caught SIGTERM Signal - Stopping (Quiescing) ...");
                this.serviceWrapper.quiesceAndStop();
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "", (Throwable)e);
            }
        }
    }
}

