/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.database.lifetime;

import java.util.List;
import org.apache.log4j.Level;
import org.apache.uima.ducc.database.lifetime.DbDaemonLifetime;
import org.apache.uima.ducc.database.lifetime.DbDaemonLifetimeCommon;
import org.apache.uima.ducc.database.lifetime.IDbDaemonLifetime;

public class DbDaemonLifetimeUI {
    public static final Integer RC_Failure = DbDaemonLifetimeCommon.RC_Failure;
    public static final Integer RC_Success = DbDaemonLifetimeCommon.RC_Success;
    public static final Integer RC_Help = DbDaemonLifetimeCommon.RC_Help;
    private String __delete = "--delete";
    private String __query = "--query";
    private String __quiesce = "--quiesce";
    private String __start = "--start";
    private String __stop = "--stop";
    private String[] kw_list = new String[]{this.__delete, this.__query, this.__quiesce, this.__start, this.__stop};
    private String[] daemon_list = new String[]{IDbDaemonLifetime.Daemon.Ag.lcname(), IDbDaemonLifetime.Daemon.Or.lcname(), IDbDaemonLifetime.Daemon.Pm.lcname(), IDbDaemonLifetime.Daemon.Rm.lcname(), IDbDaemonLifetime.Daemon.Sm.lcname(), IDbDaemonLifetime.Daemon.Ws.lcname(), IDbDaemonLifetime.Daemon.Br.lcname(), IDbDaemonLifetime.Daemon.Db.lcname()};
    private String help_selector = "<" + this.__delete + "|" + this.__query + "|" + this.__quiesce + "|" + this.__start + "|" + this.__stop + ">";
    private String help_host = "<host>";
    private String help_daemons = "<" + IDbDaemonLifetime.Daemon.Ag.lcname() + "|" + IDbDaemonLifetime.Daemon.Or.lcname() + "|" + IDbDaemonLifetime.Daemon.Pm.lcname() + "|" + IDbDaemonLifetime.Daemon.Rm.lcname() + "|" + IDbDaemonLifetime.Daemon.Sm.lcname() + "|" + IDbDaemonLifetime.Daemon.Ws.lcname() + "|" + IDbDaemonLifetime.Daemon.Br.lcname() + "|" + IDbDaemonLifetime.Daemon.Db.lcname() + ">";
    private String message_specify = "specify one of " + this.__delete + ", " + this.__query + ", " + this.__quiesce + ", " + this.__start + ", " + this.__stop + "";
    private String help_msg = this.help_selector + " " + this.help_host + " " + this.help_daemons + "\n";
    private DbDaemonLifetime dbDaemonLifetime = null;

    private DbDaemonLifetimeUI() {
        Level level = Level.DEBUG;
        this.dbDaemonLifetime = new DbDaemonLifetime(level);
    }

    private void help() {
        System.out.println(this.help_msg);
        System.exit(RC_Help);
    }

    private boolean is_valid_host(String arg) {
        boolean retVal = false;
        if (arg.length() > 0) {
            retVal = true;
        }
        return retVal;
    }

    private boolean is_valid(String needle, String[] haystack) {
        boolean retVal = false;
        if (needle != null && haystack != null) {
            for (String item : haystack) {
                if (!needle.equalsIgnoreCase(item)) continue;
                retVal = true;
                break;
            }
        }
        return retVal;
    }

    private boolean is_valid_kw(String arg) {
        return this.is_valid(arg, this.kw_list);
    }

    private boolean is_valid_daemon(String arg) {
        return this.is_valid(arg, this.daemon_list);
    }

    private int delete(String host, String daemon) {
        IDbDaemonLifetime.DbResult dbResult = this.dbDaemonLifetime.delete(host, daemon);
        return dbResult.rc;
    }

    private int query(String host, String daemon) {
        IDbDaemonLifetime.DbResult dbResult = this.dbDaemonLifetime.query(host, daemon);
        List<IDbDaemonLifetime.DaemonInfo> list = dbResult.list;
        if (list != null) {
            for (IDbDaemonLifetime.DaemonInfo di : list) {
                System.out.println(di.host + "." + di.daemon + "=" + di.state);
            }
        }
        return dbResult.rc;
    }

    private int quiesce(String host, String daemon, Long tod) {
        IDbDaemonLifetime.DbResult dbResult = this.dbDaemonLifetime.quiesce(host, daemon, tod);
        return dbResult.rc;
    }

    private int start(String host, String daemon, Long tod) {
        IDbDaemonLifetime.DbResult dbResult = this.dbDaemonLifetime.start(host, daemon, tod);
        return dbResult.rc;
    }

    private int stop(String host, String daemon, Long tod) {
        IDbDaemonLifetime.DbResult dbResult;
        if (host == null || daemon == null) {
            List<IDbDaemonLifetime.DaemonInfo> list;
            dbResult = this.dbDaemonLifetime.query(host, daemon);
            if (dbResult.rc == RC_Success && (list = dbResult.list) != null) {
                for (IDbDaemonLifetime.DaemonInfo di : list) {
                    this.stop(di.host, di.daemon, tod);
                }
            }
        } else {
            dbResult = this.dbDaemonLifetime.stop(host, daemon, tod);
        }
        return dbResult.rc;
    }

    private int mainline(String[] args) {
        String message;
        int rc = RC_Failure;
        Long tod = System.currentTimeMillis();
        String kw = null;
        if (args.length > 0) {
            kw = DbDaemonLifetimeCommon.normalize_kw(args[0]);
        }
        String host = null;
        if (args.length > 1) {
            host = DbDaemonLifetimeCommon.normalize_host(args[1]);
        }
        String daemon = null;
        if (args.length > 2) {
            daemon = DbDaemonLifetimeCommon.normalize_daemon(args[2]);
        }
        if (args.length < 1) {
            message = "no arguments specified";
            System.out.println(message);
            this.help();
        }
        if (args.length == 1) {
            if (!this.is_valid_kw(kw)) {
                System.out.println(this.message_specify);
                this.help();
            }
            if (kw.equalsIgnoreCase(this.__query)) {
                rc = this.query(host, daemon);
            } else if (kw.equalsIgnoreCase(this.__stop)) {
                rc = this.stop(host, daemon, tod);
            } else {
                message = "specify host and daemon";
                System.out.println(message);
                this.help();
            }
        } else if (args.length == 2) {
            if (!this.is_valid_kw(kw)) {
                System.out.println(this.message_specify);
                this.help();
            }
            if (!this.is_valid_host(host)) {
                this.help();
            }
            if (kw.equalsIgnoreCase(this.__query)) {
                rc = this.query(host, daemon);
            } else if (kw.equalsIgnoreCase(this.__stop)) {
                rc = this.stop(host, daemon, tod);
            } else {
                message = "specify host and daemon";
                System.out.println(message);
                this.help();
            }
        } else if (args.length == 3) {
            if (!this.is_valid_kw(kw)) {
                System.out.println(this.message_specify);
                this.help();
            }
            if (!this.is_valid_host(host)) {
                this.help();
            }
            if (!this.is_valid_daemon(daemon)) {
                this.help();
            }
            if (kw.equalsIgnoreCase(this.__query)) {
                rc = this.query(host, daemon);
            } else if (kw.equalsIgnoreCase(this.__delete)) {
                rc = this.delete(host, daemon);
            } else if (kw.equalsIgnoreCase(this.__quiesce)) {
                rc = this.quiesce(host, daemon, tod);
            } else if (kw.equalsIgnoreCase(this.__start)) {
                rc = this.start(host, daemon, tod);
            } else if (kw.equalsIgnoreCase(this.__stop)) {
                rc = this.stop(host, daemon, tod);
            } else {
                System.out.println(this.message_specify);
                this.help();
            }
        } else {
            message = "too many arguments";
            System.out.println(message);
            this.help();
        }
        return rc;
    }

    public static void main(String[] args) {
        int rc = RC_Failure;
        try {
            DbDaemonLifetimeUI instance = new DbDaemonLifetimeUI();
            rc = instance.mainline(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(rc);
    }
}

