/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.orchestrator.utilities;

import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;

public class TrackSync {
    private static DuccLogger logger = DuccLogger.getLogger(TrackSync.class);
    private static DuccId jobid = null;
    private static String sep = ".";
    private static ConcurrentSkipListMap<String, ConcurrentSkipListMap<String, AtomicLong>> map = new ConcurrentSkipListMap();
    private static ConcurrentSkipListMap<String, TrackSync> mapHeldBy = new ConcurrentSkipListMap();
    private static long msPerSecond = 1000L;
    private static long timeLimit = 10L * msPerSecond;
    private String target = null;
    private String requester = null;
    private AtomicLong t0 = new AtomicLong(0L);
    private AtomicLong t1 = new AtomicLong(0L);
    private AtomicLong t2 = new AtomicLong(0L);

    private static void addPending(String target, String requester) {
        String location = "addPending";
        try {
            ConcurrentSkipListMap<Object, Object> tMap = new ConcurrentSkipListMap();
            map.putIfAbsent(target, tMap);
            tMap = map.get(target);
            AtomicLong rCount = new AtomicLong(0L);
            tMap.putIfAbsent(requester, rCount);
            rCount = (AtomicLong)tMap.get(requester);
            rCount.getAndIncrement();
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    private static void delPending(String target, String requester) {
        String location = "delPending";
        try {
            ConcurrentSkipListMap<Object, Object> tMap = new ConcurrentSkipListMap();
            map.putIfAbsent(target, tMap);
            tMap = map.get(target);
            AtomicLong rCount = new AtomicLong(1L);
            tMap.putIfAbsent(requester, rCount);
            rCount = (AtomicLong)tMap.get(requester);
            rCount.getAndDecrement();
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    private static long getPending(String target) {
        String location = "getPending";
        long retVal = 0L;
        try {
            ConcurrentSkipListMap<String, AtomicLong> oMap = map.get(target);
            if (oMap != null) {
                for (Map.Entry<String, AtomicLong> entry : oMap.entrySet()) {
                    retVal += entry.getValue().get();
                }
            }
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    private static void report(String target) {
        String location = "report";
        try {
            ConcurrentSkipListMap<String, AtomicLong> oMap = map.get(target);
            if (oMap != null) {
                for (Map.Entry<String, AtomicLong> entry : oMap.entrySet()) {
                    String requester = entry.getKey();
                    long pending = entry.getValue().longValue();
                    if (pending <= 0L) continue;
                    logger.info(location, jobid, new Object[]{"target: " + target + " requester: " + requester + "  pending: " + pending});
                }
            }
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    private static void overtime(TrackSync ts, String target) {
        String location = "overtime";
        try {
            long timeHeld;
            if (ts != null && (timeHeld = ts.getTimeHeld()) > timeLimit) {
                logger.info(location, jobid, new Object[]{"target: " + ts.target + " requester: " + ts.requester + " wait: " + ts.getTimeWait() + " held: " + ts.getTimeHeld()});
                TrackSync.report(target);
            }
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    private static void blocked(TrackSync ts, String target, String requester) {
        String location = "blocked";
        try {
            long timeHeld;
            if (ts != null && (timeHeld = ts.getTimeHeld()) > timeLimit) {
                logger.info(location, jobid, new Object[]{"target: " + ts.target + " requester: " + ts.requester + " time: " + ts.getTimeHeld() + " blocking: " + requester});
            }
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    public static TrackSync await(Object targetObject, Class<?> requesterClass, String requesterLocation) {
        String location = "await";
        TrackSync ts = new TrackSync();
        try {
            ts.target = targetObject.getClass().getSimpleName();
            ts.requester = requesterClass.getSimpleName() + sep + requesterLocation;
            TrackSync tsHolder = mapHeldBy.get(ts.target);
            TrackSync.addPending(ts.target, ts.requester);
            TrackSync.blocked(tsHolder, ts.target, ts.requester);
            logger.trace(location, jobid, new Object[]{"target: " + ts.target + " requester: " + ts.requester});
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return ts;
    }

    public TrackSync() {
        this.setT0(this);
    }

    private void setT0(TrackSync ts) {
        if (ts != null && ts.t0.get() == 0L) {
            ts.t0.compareAndSet(0L, System.currentTimeMillis());
        }
    }

    private void setT1(TrackSync ts) {
        if (ts != null && ts.t1.get() == 0L) {
            ts.t1.compareAndSet(0L, System.currentTimeMillis());
        }
    }

    private void setT2(TrackSync ts) {
        if (ts != null && ts.t2.get() == 0L) {
            ts.t2.compareAndSet(0L, System.currentTimeMillis());
        }
    }

    public long getT0() {
        long value = this.t0.get();
        if (value == 0L) {
            value = System.currentTimeMillis();
        }
        return value;
    }

    public long getT1() {
        long value = this.t1.get();
        if (value == 0L) {
            value = System.currentTimeMillis();
        }
        return value;
    }

    public long getT2() {
        long value = this.t2.get();
        if (value == 0L) {
            value = System.currentTimeMillis();
        }
        return value;
    }

    private String target() {
        return "target: " + this.target;
    }

    private String requester() {
        return "requester: " + this.requester;
    }

    private String timeWait() {
        return "wait: " + this.getTimeWait();
    }

    private String timeHeld() {
        return "held: " + this.getTimeHeld();
    }

    private String pending() {
        return "pending: " + TrackSync.getPending(this.target);
    }

    public void using() {
        String location = "using";
        try {
            TrackSync tsHolder = mapHeldBy.get(this.target);
            this.setT2(tsHolder);
            TrackSync.overtime(tsHolder, this.target);
            this.setT1(this);
            TrackSync.delPending(this.target, this.requester);
            mapHeldBy.put(this.target, this);
            logger.trace(location, jobid, new Object[]{this.target() + " " + this.requester() + " " + this.timeWait()});
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    public void ended() {
        String location = "ended";
        try {
            this.setT2(this);
            logger.trace(location, jobid, new Object[]{this.target() + " " + this.requester() + " " + this.timeWait() + " " + this.timeHeld() + " " + this.pending()});
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    public long getTimeWait() {
        return this.getT1() - this.getT0();
    }

    public long getTimeHeld() {
        return this.getT2() - this.getT1();
    }
}

