/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.management;

import java.net.SocketAddress;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoService;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoServiceListener;
import org.apache.mina.common.IoSession;
import org.apache.mina.management.IoSessionStat;

public class StatCollector {
    public static final String KEY = StatCollector.class.getName() + ".stat";
    private static volatile int nextId = 0;
    private final int id = nextId++;
    private final Object calcLock = new Object();
    private final IoService service;
    private Worker worker;
    private int pollingInterval = 5000;
    private Queue<IoSession> polledSessions;
    private AtomicLong totalProcessedSessions = new AtomicLong();
    private float msgWrittenThroughput = 0.0f;
    private float msgReadThroughput = 0.0f;
    private float bytesWrittenThroughput = 0.0f;
    private float bytesReadThroughput = 0.0f;
    private final IoServiceListener serviceListener = new IoServiceListener(){

        public void serviceActivated(IoService service, SocketAddress serviceAddress, IoHandler handler, IoServiceConfig config) {
        }

        public void serviceDeactivated(IoService service, SocketAddress serviceAddress, IoHandler handler, IoServiceConfig config) {
        }

        public void sessionCreated(IoSession session) {
            StatCollector.this.addSession(session);
        }

        public void sessionDestroyed(IoSession session) {
            StatCollector.this.removeSession(session);
        }
    };

    public StatCollector(IoService service) {
        this(service, 5000);
    }

    public StatCollector(IoService service, int pollingInterval) {
        this.service = service;
        this.pollingInterval = pollingInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        StatCollector statCollector = this;
        synchronized (statCollector) {
            if (this.worker != null && this.worker.isAlive()) {
                throw new RuntimeException("Stat collecting already started");
            }
            this.polledSessions = new ConcurrentLinkedQueue<IoSession>();
            for (SocketAddress element : this.service.getManagedServiceAddresses()) {
                Iterator<IoSession> iter2 = this.service.getManagedSessions(element).iterator();
                while (iter2.hasNext()) {
                    this.addSession(iter2.next());
                }
            }
            this.service.addListener(this.serviceListener);
            this.worker = new Worker();
            this.worker.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        StatCollector statCollector = this;
        synchronized (statCollector) {
            if (this.worker == null) {
                return;
            }
            this.service.removeListener(this.serviceListener);
            this.worker.stop = true;
            this.worker.interrupt();
            while (this.worker.isAlive()) {
                try {
                    this.worker.join();
                }
                catch (InterruptedException e) {}
            }
            for (IoSession session : this.polledSessions) {
                session.removeAttribute(KEY);
            }
            this.polledSessions.clear();
            this.worker = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        StatCollector statCollector = this;
        synchronized (statCollector) {
            return this.worker != null && !this.worker.stop;
        }
    }

    private void addSession(IoSession session) {
        IoSessionStat sessionStats = new IoSessionStat();
        session.setAttribute(KEY, sessionStats);
        this.totalProcessedSessions.incrementAndGet();
        this.polledSessions.add(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSession(IoSession session) {
        this.polledSessions.remove(session);
        IoSessionStat sessStat = (IoSessionStat)session.getAttribute(KEY);
        long currentTime = System.currentTimeMillis();
        Object object = this.calcLock;
        synchronized (object) {
            this.bytesReadThroughput += (float)(session.getReadBytes() - sessStat.lastByteRead) / ((float)(currentTime - sessStat.lastPollingTime) / 1000.0f);
            this.bytesWrittenThroughput += (float)(session.getWrittenBytes() - sessStat.lastByteWrite) / ((float)(currentTime - sessStat.lastPollingTime) / 1000.0f);
            this.msgReadThroughput += (float)(session.getReadMessages() - sessStat.lastMessageRead) / ((float)(currentTime - sessStat.lastPollingTime) / 1000.0f);
            this.msgWrittenThroughput += (float)(session.getWrittenMessages() - sessStat.lastMessageWrite) / ((float)(currentTime - sessStat.lastPollingTime) / 1000.0f);
        }
        session.removeAttribute(KEY);
    }

    public long getTotalProcessedSessions() {
        return this.totalProcessedSessions.get();
    }

    public float getBytesReadThroughput() {
        return this.bytesReadThroughput;
    }

    public float getBytesWrittenThroughput() {
        return this.bytesWrittenThroughput;
    }

    public float getMsgReadThroughput() {
        return this.msgReadThroughput;
    }

    public float getMsgWrittenThroughput() {
        return this.msgWrittenThroughput;
    }

    public long getSessionCount() {
        return this.polledSessions.size();
    }

    private class Worker
    extends Thread {
        boolean stop;

        private Worker() {
            super("StatCollectorWorker-" + StatCollector.this.id);
            this.stop = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.stop) {
                for (IoSession session : StatCollector.this.polledSessions) {
                    IoSessionStat sessStat = (IoSessionStat)session.getAttribute(KEY);
                    sessStat.lastByteRead = session.getReadBytes();
                    sessStat.lastByteWrite = session.getWrittenBytes();
                    sessStat.lastMessageRead = session.getReadMessages();
                    sessStat.lastMessageWrite = session.getWrittenMessages();
                }
                try {
                    Thread.sleep(StatCollector.this.pollingInterval);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                float tmpMsgWrittenThroughput = 0.0f;
                float tmpMsgReadThroughput = 0.0f;
                float tmpBytesWrittenThroughput = 0.0f;
                float tmpBytesReadThroughput = 0.0f;
                for (IoSession session : StatCollector.this.polledSessions) {
                    IoSessionStat sessStat = (IoSessionStat)session.getAttribute(KEY);
                    sessStat.byteReadThroughput = (float)(session.getReadBytes() - sessStat.lastByteRead) / ((float)StatCollector.this.pollingInterval / 1000.0f);
                    tmpBytesReadThroughput += sessStat.byteReadThroughput;
                    sessStat.byteWrittenThroughput = (float)(session.getWrittenBytes() - sessStat.lastByteWrite) / ((float)StatCollector.this.pollingInterval / 1000.0f);
                    tmpBytesWrittenThroughput += sessStat.byteWrittenThroughput;
                    sessStat.messageReadThroughput = (float)(session.getReadMessages() - sessStat.lastMessageRead) / ((float)StatCollector.this.pollingInterval / 1000.0f);
                    tmpMsgReadThroughput += sessStat.messageReadThroughput;
                    sessStat.messageWrittenThroughput = (float)(session.getWrittenMessages() - sessStat.lastMessageWrite) / ((float)StatCollector.this.pollingInterval / 1000.0f);
                    tmpMsgWrittenThroughput += sessStat.messageWrittenThroughput;
                    Object object = StatCollector.this.calcLock;
                    synchronized (object) {
                        StatCollector.this.msgWrittenThroughput = tmpMsgWrittenThroughput;
                        StatCollector.this.msgReadThroughput = tmpMsgReadThroughput;
                        StatCollector.this.bytesWrittenThroughput = tmpBytesWrittenThroughput;
                        StatCollector.this.bytesReadThroughput = tmpBytesReadThroughput;
                        sessStat.lastPollingTime = System.currentTimeMillis();
                    }
                }
            }
        }
    }
}

