/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.sm;

import java.io.File;
import java.io.FileInputStream;
import java.util.NavigableSet;
import org.apache.uima.ducc.common.persistence.services.IStateServices;
import org.apache.uima.ducc.common.persistence.services.StateServicesDirectory;
import org.apache.uima.ducc.common.persistence.services.StateServicesFactory;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.common.utils.id.DuccIdFactory;
import org.apache.uima.ducc.common.utils.id.IDuccIdFactory;

public class ServiceManagerHelper {
    private static DuccLogger logger = DuccLogger.getLogger((String)ServiceManagerHelper.class.getName(), (String)"SM");
    private static DuccId jobid = null;
    private static String service_seqno = "service.seqno";

    public static IDuccIdFactory getDuccIdFactory() {
        String location = "getDuccIdFactory";
        long fileSeqNo = ServiceManagerHelper.getFileSeqNo() + 1L;
        long dbSeqNo = ServiceManagerHelper.getDbSeqNo() + 1L;
        long seqNo = 0L;
        if (fileSeqNo > seqNo) {
            seqNo = fileSeqNo;
        }
        if (dbSeqNo > seqNo) {
            seqNo = dbSeqNo;
        }
        logger.info(location, jobid, new Object[]{"seqNo:", seqNo, "dbSeqNo:", dbSeqNo, "fileSeqNo:", fileSeqNo});
        DuccIdFactory duccIdFactory = new DuccIdFactory(seqNo);
        return duccIdFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getFileSeqNo() {
        long seqNo;
        block5: {
            String location = "getFileSeqNo";
            seqNo = -1L;
            try {
                String state_dir = System.getProperty("DUCC_HOME") + "/state";
                String state_file = state_dir + "/sm.properties";
                DuccProperties sm_props = new DuccProperties();
                File sf = new File(state_file);
                if (!sf.exists()) break block5;
                try (FileInputStream fos = new FileInputStream(state_file);){
                    sm_props.load(fos);
                    String s = sm_props.getProperty(service_seqno);
                    seqNo = Integer.parseInt(s) + 1;
                }
            }
            catch (Exception e) {
                logger.error(location, jobid, (Throwable)e, new Object[0]);
            }
        }
        return seqNo;
    }

    public static long getDbSeqNo() {
        String location = "getDbSeqNo";
        long seqno = -1L;
        try {
            IStateServices iss = StateServicesFactory.getInstance((String)ServiceManagerHelper.class.getName(), (String)"SM");
            StateServicesDirectory ssd = iss.getStateServicesDirectory();
            NavigableSet keys = ssd.getDescendingKeySet();
            if (!keys.isEmpty()) {
                seqno = (Long)keys.first();
            }
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return seqno;
    }
}

