/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.container.jd.wi.perf;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.uima.ducc.common.utils.FormatHelper;
import org.apache.uima.ducc.common.utils.IOHelper;
import org.apache.uima.ducc.container.common.FlagsExtendedHelper;
import org.apache.uima.ducc.container.common.MessageBuffer;
import org.apache.uima.ducc.container.common.Standardize;
import org.apache.uima.ducc.container.common.SynchronizedStats;
import org.apache.uima.ducc.container.common.logger.IComponent;
import org.apache.uima.ducc.container.common.logger.ILogger;
import org.apache.uima.ducc.container.common.logger.Logger;
import org.apache.uima.ducc.container.jd.wi.perf.IWorkItemPerformanceIndividualInfo;
import org.apache.uima.ducc.container.jd.wi.perf.IWorkItemPerformanceIndividualKeeper;
import org.apache.uima.ducc.container.jd.wi.perf.PerfKey;
import org.apache.uima.ducc.container.jd.wi.perf.WorkItemPerformanceIndividualInfo;
import org.apache.uima.ducc.container.jd.wi.perf.files.JobPerformanceIndividual;
import org.apache.uima.ducc.container.jd.wi.perf.files.JobPerformanceIndividualData;
import org.apache.uima.ducc.container.jd.wi.perf.files.JobPerformanceIndividualJsonGz;
import org.apache.uima.ducc.container.jd.wi.perf.files.PerformanceMetricsIndividualItem;

public class WorkItemPerformanceIndividualKeeper
implements IWorkItemPerformanceIndividualKeeper {
    private static Logger logger = Logger.getLogger(WorkItemPerformanceIndividualKeeper.class, IComponent.Id.JD.name());
    boolean isIndividualWorkItemPerformance = FlagsExtendedHelper.getInstance().isIndividualWorkItemPerformance();
    private String logFolder = null;
    private String wiNo = null;
    private ConcurrentHashMap<PerfKey, PerfStats> map = new ConcurrentHashMap();

    public WorkItemPerformanceIndividualKeeper(String logDir, String wiNo) {
        if (this.isIndividualWorkItemPerformance) {
            String logFolder = IOHelper.marryDir2File((String)logDir, (String)"work-item-performance");
            IOHelper.mkdirs((String)logFolder);
            this.setLogFolder(logFolder);
            this.setWiNo(wiNo);
        }
    }

    private void setLogFolder(String value) {
        this.logFolder = value;
    }

    private void setWiNo(String value) {
        this.wiNo = value;
    }

    @Override
    public List<IWorkItemPerformanceIndividualInfo> dataGet() {
        ArrayList<IWorkItemPerformanceIndividualInfo> list = new ArrayList<IWorkItemPerformanceIndividualInfo>();
        if (this.isIndividualWorkItemPerformance) {
            for (Map.Entry<PerfKey, PerfStats> entry : this.map.entrySet()) {
                String name = entry.getKey().getName();
                String uniqueName = entry.getKey().getUniqueName();
                PerfStats perfStats = entry.getValue();
                SynchronizedStats stats = perfStats.ss;
                long tasks = perfStats.tasks;
                double time = stats.getSum();
                WorkItemPerformanceIndividualInfo item = new WorkItemPerformanceIndividualInfo(name, uniqueName, time, tasks);
                list.add(item);
            }
        }
        return list;
    }

    @Override
    public void dataAdd(String name, String uniqueName, long time, long tasks) {
        String location = "dataAdd";
        if (this.isIndividualWorkItemPerformance) {
            try {
                PerfKey perfKey = new PerfKey(name, uniqueName);
                if (!this.map.containsKey(perfKey)) {
                    this.map.putIfAbsent(perfKey, new PerfStats());
                }
                PerfStats perfStats = this.map.get(perfKey);
                SynchronizedStats stats = perfStats.ss;
                stats.addValue(time);
                long lTimeSum = (long)stats.getSum();
                String timeSum = FormatHelper.duration((long)lTimeSum, (FormatHelper.Precision)FormatHelper.Precision.Tenths);
                perfStats.tasks = tasks;
                MessageBuffer mb = new MessageBuffer();
                mb.append(Standardize.Label.name.get() + name);
                mb.append(Standardize.Label.sum.get() + timeSum);
                mb.append(Standardize.Label.tasks.get() + tasks);
                if (lTimeSum < 0L) {
                    logger.warn(location, ILogger.null_id, mb.toString());
                } else {
                    logger.debug(location, ILogger.null_id, mb.toString());
                }
            }
            catch (Exception e) {
                logger.error(location, ILogger.null_id, e, new Object[0]);
            }
        }
    }

    private PerformanceMetricsIndividualItem create(IWorkItemPerformanceIndividualInfo wipii) {
        PerformanceMetricsIndividualItem retVal = new PerformanceMetricsIndividualItem(wipii.getName(), wipii.getUniqueName(), (long)wipii.getTime());
        return retVal;
    }

    @Override
    public void publish() {
        String location = "publish";
        if (this.isIndividualWorkItemPerformance) {
            try {
                List<IWorkItemPerformanceIndividualInfo> list = this.dataGet();
                ConcurrentSkipListMap<String, JobPerformanceIndividual> map = new ConcurrentSkipListMap<String, JobPerformanceIndividual>();
                for (IWorkItemPerformanceIndividualInfo wipii : list) {
                    PerformanceMetricsIndividualItem item = this.create(wipii);
                    JobPerformanceIndividual jps = new JobPerformanceIndividual();
                    jps.setAnalysisTime(item.getAnalysisTime());
                    jps.setName(item.getName());
                    jps.setUniqueName(item.getUniqueName());
                    map.put(jps.getUniqueName(), jps);
                }
                JobPerformanceIndividualData data = new JobPerformanceIndividualData(map);
                JobPerformanceIndividualJsonGz jsonGz = new JobPerformanceIndividualJsonGz(this.logFolder, this.wiNo);
                jsonGz.exportData(data);
            }
            catch (Exception e) {
                logger.error(location, ILogger.null_id, e, new Object[0]);
            }
        }
    }

    private class PerfStats {
        SynchronizedStats ss = new SynchronizedStats();
        long tasks = 0L;
    }
}

