/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.container.jd.wi;

import org.apache.uima.ducc.container.common.Assertion;
import org.apache.uima.ducc.container.common.SynchronizedStats;
import org.apache.uima.ducc.container.jd.wi.IWorkItem;
import org.apache.uima.ducc.container.jd.wi.IWorkItemStatistics;

public class WorkItemStatistics
implements IWorkItemStatistics {
    private SynchronizedStats stats = new SynchronizedStats();
    private long mintime = 0L;

    @Override
    public void ended(IWorkItem wi) {
        long time = wi.getMillisOperating();
        Assertion.nonNegative(time);
        if (time < this.mintime) {
            time = this.mintime;
        }
        this.stats.addValue(time);
    }

    @Override
    public long getCount() {
        return this.stats.getNum();
    }

    @Override
    public long getMillisMin() {
        double stat = this.stats.getMin();
        if (stat == Double.MAX_VALUE) {
            stat = 0.0;
        }
        long value = (long)stat;
        return value;
    }

    @Override
    public long getMillisMax() {
        double stat = this.stats.getMax();
        long value = (long)stat;
        return value;
    }

    @Override
    public long getMillisAvg() {
        double stat = this.stats.getMean();
        long value = (long)stat;
        return value;
    }

    @Override
    public long getMillisStdDev() {
        double stat = this.stats.getStandardDeviation();
        long value = (long)stat;
        return value;
    }
}

