/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.container.common.logger;

import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.container.common.logger.ILogger;
import org.apache.uima.ducc.container.common.logger.id.Id;

public class Logger
implements ILogger {
    private DuccLogger duccLogger = null;

    public static Logger getLogger(Class<?> clazz) {
        return new Logger(clazz, null);
    }

    public static Logger getLogger(Class<?> clazz, String component) {
        return new Logger(clazz, component);
    }

    private static DuccId toDuccId(Id id) {
        DuccId retVal = null;
        try {
            Long value = Long.parseLong(id.toString());
            retVal = new DuccId(value.longValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private Logger(Class<?> clazz, String component) {
        this.duccLogger = DuccLogger.getLogger(clazz, (String)component);
    }

    @Override
    public void fatal(String location, Id jobId, Object ... args) {
        this.duccLogger.fatal(location, Logger.toDuccId(jobId), args);
    }

    @Override
    public void fatal(String location, Id jobId, Throwable t, Object ... args) {
        this.duccLogger.fatal(location, Logger.toDuccId(jobId), t, args);
    }

    @Override
    public void fatal(String location, Id jobId, Id processId, Object ... args) {
        this.duccLogger.fatal(location, Logger.toDuccId(jobId), Logger.toDuccId(processId), args);
    }

    @Override
    public void fatal(String location, Id jobId, Id processId, Throwable t, Object ... args) {
        this.duccLogger.fatal(location, Logger.toDuccId(jobId), Logger.toDuccId(processId), t, args);
    }

    @Override
    public void debug(String location, Id jobId, Object ... args) {
        this.duccLogger.debug(location, Logger.toDuccId(jobId), args);
    }

    @Override
    public void debug(String location, Id jobId, Throwable t, Object ... args) {
        this.duccLogger.debug(location, Logger.toDuccId(jobId), t, args);
    }

    @Override
    public void debug(String location, Id jobId, Id processId, Object ... args) {
        this.duccLogger.debug(location, Logger.toDuccId(jobId), Logger.toDuccId(processId), args);
    }

    @Override
    public void debug(String location, Id jobId, Id processId, Throwable t, Object ... args) {
        this.duccLogger.debug(location, Logger.toDuccId(jobId), Logger.toDuccId(processId), t, args);
    }

    @Override
    public void error(String location, Id jobId, Object ... args) {
        this.duccLogger.error(location, Logger.toDuccId(jobId), args);
    }

    @Override
    public void error(String location, Id jobId, Throwable t, Object ... args) {
        this.duccLogger.error(location, Logger.toDuccId(jobId), t, args);
    }

    @Override
    public void error(String location, Id jobId, Id processId, Object ... args) {
        this.duccLogger.error(location, Logger.toDuccId(jobId), Logger.toDuccId(processId), args);
    }

    @Override
    public void error(String location, Id jobId, Id processId, Throwable t, Object ... args) {
        this.duccLogger.error(location, Logger.toDuccId(jobId), Logger.toDuccId(processId), t, args);
    }

    @Override
    public void info(String location, Id jobId, Object ... args) {
        this.duccLogger.info(location, Logger.toDuccId(jobId), args);
    }

    @Override
    public void info(String location, Id jobId, Throwable t, Object ... args) {
        this.duccLogger.info(location, Logger.toDuccId(jobId), t, args);
    }

    @Override
    public void info(String location, Id jobId, Id processId, Object ... args) {
        this.duccLogger.info(location, Logger.toDuccId(jobId), Logger.toDuccId(processId), args);
    }

    @Override
    public void info(String location, Id jobId, Id processId, Throwable t, Object ... args) {
        this.duccLogger.info(location, Logger.toDuccId(jobId), Logger.toDuccId(processId), t, args);
    }

    @Override
    public void trace(String location, Id jobId, Object ... args) {
        this.duccLogger.trace(location, Logger.toDuccId(jobId), args);
    }

    @Override
    public void trace(String location, Id jobId, Throwable t, Object ... args) {
        this.duccLogger.trace(location, Logger.toDuccId(jobId), t, args);
    }

    @Override
    public void trace(String location, Id jobId, Id processId, Object ... args) {
        this.duccLogger.trace(location, Logger.toDuccId(jobId), Logger.toDuccId(processId), args);
    }

    @Override
    public void trace(String location, Id jobId, Id processId, Throwable t, Object ... args) {
        this.duccLogger.trace(location, Logger.toDuccId(jobId), Logger.toDuccId(processId), t, args);
    }

    @Override
    public void warn(String location, Id jobId, Object ... args) {
        this.duccLogger.warn(location, Logger.toDuccId(jobId), args);
    }

    @Override
    public void warn(String location, Id jobId, Throwable t, Object ... args) {
        this.duccLogger.warn(location, Logger.toDuccId(jobId), t, args);
    }

    @Override
    public void warn(String location, Id jobId, Id processId, Object ... args) {
        this.duccLogger.warn(location, Logger.toDuccId(jobId), Logger.toDuccId(processId), args);
    }

    @Override
    public void warn(String location, Id jobId, Id processId, Throwable t, Object ... args) {
        this.duccLogger.warn(location, Logger.toDuccId(jobId), Logger.toDuccId(processId), t, args);
    }

    @Override
    public boolean isDebug() {
        return this.duccLogger.isDebug();
    }
}

