/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.uima.ducc.common.IDuccEnv;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.ws.server.DuccAbstractHandler;
import org.apache.uima.ducc.ws.server.DuccWebServer;
import org.apache.uima.ducc.ws.server.DuccWebUtil;
import org.eclipse.jetty.server.Request;

public class DuccHandlerHttpRequestFilter
extends DuccAbstractHandler {
    private static DuccLogger duccLogger = DuccLogger.getLogger(DuccHandlerHttpRequestFilter.class);
    private static volatile DuccId jobid = null;
    private long expiryMillis = 60000L;
    private AtomicLong saveMillisUpdate = new AtomicLong(0L);
    private volatile UserDataAccessMode userDataAccessMode = UserDataAccessMode.unrestricted;
    private volatile List<String> listEncryptionExemption = new ArrayList<String>();
    private String filePath = IDuccEnv.DUCC_HOME_DIR + File.separator + "webserver" + File.separator + "etc" + File.separator + "http-uri-encryption-exemption.list";

    public DuccHandlerHttpRequestFilter(DuccWebServer duccWebServer) {
        super.init(duccWebServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshListEncryptionExemption() {
        String location = "refreshListEncryptionExemption";
        try {
            ArrayList<String> listRefresh = new ArrayList<String>();
            BufferedReader br = null;
            try {
                String line;
                br = new BufferedReader(new FileReader(this.filePath));
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).startsWith("#") || line.length() <= 0) continue;
                    listRefresh.add(line);
                }
                this.listEncryptionExemption = listRefresh;
            }
            catch (IOException e) {
                duccLogger.trace(location, jobid, (Throwable)e, new Object[0]);
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException e) {
                    duccLogger.error(location, jobid, (Throwable)e, new Object[0]);
                }
            }
            duccLogger.debug(location, jobid, new Object[]{"size:" + this.listEncryptionExemption.size()});
        }
        catch (Exception e) {
            duccLogger.error(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    private List<String> getListEncryptionExemption() {
        return this.listEncryptionExemption;
    }

    private void refreshUserDataAccessMode() {
        String location = "refreshUserDataAccessMode";
        try {
            DuccPropertiesResolver dpr = DuccPropertiesResolver.getInstance();
            String property = dpr.getFileProperty("ducc.ws.user.data.access");
            if (property != null) {
                if ((property = property.trim()).equals(UserDataAccessMode.unrestricted.name())) {
                    this.userDataAccessMode = UserDataAccessMode.unrestricted;
                } else if (property.equals(UserDataAccessMode.encrypted.name())) {
                    this.userDataAccessMode = UserDataAccessMode.encrypted;
                } else if (property.equals(UserDataAccessMode.blocked.name())) {
                    this.userDataAccessMode = UserDataAccessMode.blocked;
                } else {
                    String message = "no change, unrecognized value: " + property;
                    duccLogger.warn(location, jobid, new Object[]{message});
                }
            } else {
                this.userDataAccessMode = UserDataAccessMode.unrestricted;
            }
        }
        catch (Exception e) {
            duccLogger.error(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    private UserDataAccessMode getUserDataAccessMode() {
        return this.userDataAccessMode;
    }

    private boolean isRestrictedHttp() {
        boolean retVal = false;
        UserDataAccessMode uda = this.getUserDataAccessMode();
        switch (uda) {
            default: {
                break;
            }
            case encrypted: 
            case blocked: {
                retVal = true;
            }
        }
        return retVal;
    }

    private boolean isRestrictedHttps() {
        boolean retVal = false;
        UserDataAccessMode uda = this.getUserDataAccessMode();
        switch (uda) {
            default: {
                break;
            }
            case blocked: {
                retVal = true;
            }
        }
        return retVal;
    }

    private boolean isRestrictedScheme(String scheme) {
        boolean retVal = false;
        if (scheme.equals("http")) {
            retVal = this.isRestrictedHttp();
        } else if (scheme.equals("https")) {
            retVal = this.isRestrictedHttps();
        }
        return retVal;
    }

    private void refresh() {
        long timeMillisLastUpdate;
        long timeMillisNow = System.currentTimeMillis();
        if (timeMillisNow - (timeMillisLastUpdate = this.saveMillisUpdate.get()) > this.expiryMillis) {
            this.refreshUserDataAccessMode();
            this.refreshListEncryptionExemption();
            this.saveMillisUpdate.set(timeMillisNow);
        }
    }

    private String getContentForbiddenPage() {
        StringBuffer sb = new StringBuffer();
        sb.append("<html>");
        sb.append("<body>");
        sb.append("<p>");
        sb.append("Forbidden.");
        sb.append("</p>");
        sb.append("</body>");
        sb.append("</html>");
        return sb.toString();
    }

    private boolean isRestrictedUri(String reqUri) {
        boolean retVal = true;
        List<String> list = this.getListEncryptionExemption();
        for (String includeUri : list) {
            if (!reqUri.startsWith(includeUri)) continue;
            retVal = false;
            break;
        }
        return retVal;
    }

    public void handleForbidden(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String reqUri;
        String scheme;
        String location = "handleForbidden";
        if (!baseRequest.isHandled() && this.isRestrictedScheme(scheme = request.getScheme()) && this.isRestrictedUri(reqUri = request.getRequestURI())) {
            String content = this.getContentForbiddenPage();
            response.getWriter().println(content);
            StringBuffer sb = new StringBuffer();
            sb.append("forbidden: " + reqUri);
            duccLogger.info(location, jobid, new Object[]{sb});
            response.setContentType("text/html;charset=utf-8");
            response.setStatus(403);
            baseRequest.setHandled(true);
            DuccWebUtil.noCache(response);
        }
    }

    private String getContentRedirect(String url) {
        StringBuffer sb = new StringBuffer();
        sb.append("<html>");
        sb.append("<head>");
        sb.append("<script type=\"text/javascript\">");
        sb.append(" window.location.href = \"" + url + "\"");
        sb.append("</script>");
        sb.append("</head>");
        sb.append("<body>");
        sb.append("Redirecting to ");
        sb.append("<a href='" + url + "'>" + url + "</a>");
        sb.append("</body>");
        sb.append("</html>");
        return sb.toString();
    }

    public void handleRedirect(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String location = "handleRedirect";
        if (!baseRequest.isHandled()) {
            UserDataAccessMode uda = this.getUserDataAccessMode();
            switch (uda) {
                case encrypted: {
                    String reqUri;
                    String scheme = request.getScheme();
                    if (!scheme.equals("http") || !this.isRestrictedUri(reqUri = request.getRequestURI())) break;
                    String url = request.getRequestURL().toString();
                    String encodedQS = request.getQueryString();
                    if (encodedQS != null) {
                        String qs = URLDecoder.decode(encodedQS, "UTF-8");
                        url = url + "?" + qs;
                    }
                    String portHttps = "" + DuccWebServer.ConfigValue.PortHttps.getInt(DuccPropertiesResolver.get((String)"ducc.ws.port.ssl"));
                    String portHttp = "" + DuccWebServer.ConfigValue.PortHttp.getInt(DuccPropertiesResolver.get((String)"ducc.ws.port"));
                    String s1Before = "http:";
                    String s1After = "https:";
                    String s2Before = ":" + portHttp;
                    String s2After = ":" + portHttps;
                    if (!url.contains(s1Before) || !url.contains(s2Before)) break;
                    String redirect = new String(url);
                    redirect = redirect.replace(s1Before, s1After);
                    if (url.equals(redirect = redirect.replace(s2Before, s2After))) break;
                    String content = this.getContentRedirect(redirect);
                    response.getWriter().println(content);
                    duccLogger.info(location, jobid, new Object[]{redirect});
                    response.setContentType("text/html;charset=utf-8");
                    response.setStatus(200);
                    baseRequest.setHandled(true);
                    DuccWebUtil.noCache(response);
                    break;
                }
            }
        }
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String location = "handle";
        try {
            duccLogger.debug(location, jobid, new Object[]{request.toString()});
            this.refresh();
            this.handleRedirect(target, baseRequest, request, response);
            this.handleForbidden(target, baseRequest, request, response);
        }
        catch (Throwable t) {
            if (this.isIgnorable(t)) {
                duccLogger.debug(location, jobid, t, new Object[0]);
            }
            duccLogger.info(location, jobid, new Object[]{"", t.getMessage(), t});
            duccLogger.error(location, jobid, t, new Object[0]);
        }
    }

    private static enum UserDataAccessMode {
        unrestricted,
        encrypted,
        blocked;

    }
}

