/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.json.jp;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.uima.ducc.common.utils.IOHelper;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.event.common.DuccWorkPopDriver;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccProcessMap;
import org.apache.uima.ducc.transport.event.common.IDuccProcessWorkItems;
import org.apache.uima.ducc.transport.event.common.IDuccWorkJob;
import org.apache.uima.ducc.transport.event.common.TimeWindow;
import org.apache.uima.ducc.transport.json.jp.FileInfo;
import org.apache.uima.ducc.transport.json.jp.JobProcessData;

public class JobProcessCollection {
    public static final String job_processes_data_json_gz = "job-processes-data.json.gz";
    public static final String encoding = "UTF-8";
    private String directory = null;
    private String fileName = null;
    private Gson gson = new Gson();

    public JobProcessCollection(IDuccWorkJob job) {
        String fileDirectory = job.getUserLogDir();
        this.initialize(fileDirectory);
    }

    public JobProcessCollection(String fileDirectory) {
        this.initialize(fileDirectory);
    }

    private static long getId(IDuccWorkJob job, IDuccProcess process) {
        long retVal = 0L;
        try {
            retVal = Long.parseLong(process.getDuccId().toString().trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private static String getLogDirectory(IDuccWorkJob job, IDuccProcess process) {
        return job.getUserLogDir();
    }

    private static ArrayList<FileInfo> getLogFileList(IDuccWorkJob job, IDuccProcess process) {
        ArrayList<FileInfo> retVal = new ArrayList<FileInfo>();
        try {
            FileInfo fileInfo = new FileInfo();
            fileInfo.name = "jd.out.log";
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private static String getHostName(IDuccWorkJob job, IDuccProcess process) {
        String retVal = null;
        try {
            retVal = process.getNodeIdentity().getCanonicalName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private static long getHostPid(IDuccWorkJob job, IDuccProcess process) {
        long retVal = 0L;
        try {
            retVal = Long.parseLong(process.getPID());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private static String getSchedulerState(IDuccWorkJob job, IDuccProcess process) {
        String retVal = null;
        try {
            retVal = process.getResourceState().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private static String getSchedulerReason(IDuccWorkJob job, IDuccProcess process) {
        String retVal = null;
        try {
            retVal = process.getProcessDeallocationType().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private static String getAgentState(IDuccWorkJob job, IDuccProcess process) {
        String retVal = null;
        try {
            retVal = process.getProcessState().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private static String getAgentReason(IDuccWorkJob job, IDuccProcess process) {
        String retVal = null;
        try {
            retVal = process.getReasonForStoppingProcess();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private static long getTimeInitStart(IDuccWorkJob job, IDuccProcess process) {
        long retVal = 0L;
        try {
            retVal = ((TimeWindow)process.getTimeWindowInit()).getStartLong();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private static long getTimeInitEnd(IDuccWorkJob job, IDuccProcess process) {
        long retVal = 0L;
        try {
            retVal = ((TimeWindow)process.getTimeWindowInit()).getEndLong();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private static long getTimeRunStart(IDuccWorkJob job, IDuccProcess process) {
        long retVal = 0L;
        try {
            retVal = ((TimeWindow)process.getTimeWindowRun()).getStartLong();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private static long getTimeRunEnd(IDuccWorkJob job, IDuccProcess process) {
        long retVal = 0L;
        try {
            retVal = ((TimeWindow)process.getTimeWindowRun()).getEndLong();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private static long getTimeGC(IDuccWorkJob job, IDuccProcess process) {
        long retVal = 0L;
        try {
            retVal = process.getGarbageCollectionStats().getCollectionTime();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private static long getPgIn(IDuccWorkJob job, IDuccProcess process) {
        long retVal = 0L;
        try {
            retVal = process.getMajorFaults();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private static long getSwap(IDuccWorkJob job, IDuccProcess process) {
        long retVal = 0L;
        try {
            retVal = process.getSwapUsage();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private static long getSwapMax(IDuccWorkJob job, IDuccProcess process) {
        long retVal = 0L;
        try {
            retVal = process.getSwapUsageMax();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private static long getRss(IDuccWorkJob job, IDuccProcess process) {
        long retVal = 0L;
        try {
            retVal = process.getResidentMemory();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private static long getRssMax(IDuccWorkJob job, IDuccProcess process) {
        long retVal = 0L;
        try {
            retVal = process.getResidentMemoryMax();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private static long getWiTimeAvg(IDuccWorkJob job, IDuccProcess process) {
        long retVal = 0L;
        try {
            IDuccProcessWorkItems pwi = process.getProcessWorkItems();
            retVal = pwi.getSecsAvg();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private static long getWiTimeMax(IDuccWorkJob job, IDuccProcess process) {
        long retVal = 0L;
        try {
            IDuccProcessWorkItems pwi = process.getProcessWorkItems();
            retVal = pwi.getSecsMax();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private static long getWiTimeMin(IDuccWorkJob job, IDuccProcess process) {
        long retVal = 0L;
        try {
            IDuccProcessWorkItems pwi = process.getProcessWorkItems();
            retVal = pwi.getSecsMin();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private static long getWiDone(IDuccWorkJob job, IDuccProcess process) {
        long retVal = 0L;
        try {
            IDuccProcessWorkItems pwi = process.getProcessWorkItems();
            retVal = pwi.getCountDone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private static long getWiError(IDuccWorkJob job, IDuccProcess process) {
        long retVal = 0L;
        try {
            IDuccProcessWorkItems pwi = process.getProcessWorkItems();
            retVal = pwi.getCountError();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private static long getWiRetry(IDuccWorkJob job, IDuccProcess process) {
        long retVal = 0L;
        try {
            IDuccProcessWorkItems pwi = process.getProcessWorkItems();
            retVal = pwi.getCountRetry();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private static long getWiPreempt(IDuccWorkJob job, IDuccProcess process) {
        long retVal = 0L;
        try {
            IDuccProcessWorkItems pwi = process.getProcessWorkItems();
            retVal = pwi.getCountPreempt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private static String getJConsole(IDuccWorkJob job, IDuccProcess process) {
        String retVal = null;
        try {
            retVal = process.getProcessJmxUrl();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private void transform(ConcurrentSkipListMap<Long, JobProcessData> map, IDuccWorkJob job, IDuccProcessMap processMap) {
        if (job != null && processMap != null) {
            for (DuccId duccId : processMap.keySet()) {
                IDuccProcess process = (IDuccProcess)processMap.get(duccId);
                JobProcessData jpd = new JobProcessData();
                jpd.id = JobProcessCollection.getId(job, process);
                jpd.logDirectory = JobProcessCollection.getLogDirectory(job, process);
                jpd.logFileList = JobProcessCollection.getLogFileList(job, process);
                jpd.hostName = JobProcessCollection.getHostName(job, process);
                jpd.hostPid = JobProcessCollection.getHostPid(job, process);
                jpd.schedulerState = JobProcessCollection.getSchedulerState(job, process);
                jpd.schedulerReason = JobProcessCollection.getSchedulerReason(job, process);
                jpd.agentState = JobProcessCollection.getAgentState(job, process);
                jpd.agentReason = JobProcessCollection.getAgentReason(job, process);
                jpd.timeInitStart = JobProcessCollection.getTimeInitStart(job, process);
                jpd.timeInitEnd = JobProcessCollection.getTimeInitEnd(job, process);
                jpd.timeRunStart = JobProcessCollection.getTimeRunStart(job, process);
                jpd.timeRunEnd = JobProcessCollection.getTimeRunEnd(job, process);
                jpd.timeGC = JobProcessCollection.getTimeGC(job, process);
                jpd.pageIn = JobProcessCollection.getPgIn(job, process);
                jpd.swap = JobProcessCollection.getSwap(job, process);
                jpd.swapMax = JobProcessCollection.getSwapMax(job, process);
                jpd.rss = JobProcessCollection.getRss(job, process);
                jpd.rssMax = JobProcessCollection.getRssMax(job, process);
                jpd.wiTimeAvg = JobProcessCollection.getWiTimeAvg(job, process);
                jpd.wiTimeMax = JobProcessCollection.getWiTimeMax(job, process);
                jpd.wiTimeMin = JobProcessCollection.getWiTimeMin(job, process);
                jpd.wiDone = JobProcessCollection.getWiDone(job, process);
                jpd.wiError = JobProcessCollection.getWiError(job, process);
                jpd.wiRetry = JobProcessCollection.getWiRetry(job, process);
                jpd.wiPreempt = JobProcessCollection.getWiPreempt(job, process);
                jpd.jConsole = JobProcessCollection.getJConsole(job, process);
                Long key = new Long(jpd.id);
                JobProcessData value = jpd;
                map.put(key, value);
            }
        }
    }

    public ConcurrentSkipListMap<Long, JobProcessData> transform(IDuccWorkJob job) {
        ConcurrentSkipListMap<Long, JobProcessData> map = new ConcurrentSkipListMap<Long, JobProcessData>();
        if (job != null) {
            IDuccProcessMap jpMap = job.getProcessMap();
            this.transform(map, job, jpMap);
            DuccWorkPopDriver driver = job.getDriver();
            if (driver != null) {
                IDuccProcessMap jdMap = driver.getProcessMap();
                this.transform(map, job, jdMap);
            }
        }
        return map;
    }

    public void initialize(String fileDirectory) {
        if (fileDirectory == null) {
            throw new NullPointerException();
        }
        this.directory = fileDirectory;
        this.fileName = IOHelper.marryDir2File((String)this.directory, (String)job_processes_data_json_gz);
    }

    public String getDirectory() {
        return this.directory;
    }

    public String getQualifiedFileName() {
        return this.fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportData(ConcurrentSkipListMap<Long, JobProcessData> map) throws IOException {
        if (map == null) {
            throw new NullPointerException();
        }
        BufferedWriter writer = null;
        OutputStreamWriter osr = null;
        GZIPOutputStream gos = null;
        FileOutputStream fos = null;
        File file = null;
        try {
            String json = this.gson.toJson(map);
            file = new File(this.fileName);
            fos = new FileOutputStream(file);
            gos = new GZIPOutputStream(fos);
            osr = new OutputStreamWriter((OutputStream)gos, encoding);
            writer = new BufferedWriter(osr);
            writer.write(json);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getSize() throws IOException {
        int size = 0;
        BufferedReader reader = null;
        InputStreamReader isr = null;
        GZIPInputStream gis = null;
        FileInputStream fis = null;
        File file = null;
        int rc = 0;
        try {
            file = new File(this.fileName);
            fis = new FileInputStream(file);
            gis = new GZIPInputStream(fis);
            isr = new InputStreamReader((InputStream)gis, encoding);
            reader = new BufferedReader(isr);
            while (rc >= 0) {
                rc = reader.read();
                ++size;
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return size - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConcurrentSkipListMap<Long, JobProcessData> importData() throws IOException {
        ConcurrentSkipListMap map = new ConcurrentSkipListMap();
        BufferedReader reader = null;
        InputStreamReader isr = null;
        GZIPInputStream gis = null;
        FileInputStream fis = null;
        File file = null;
        char[] cbuf = new char[this.getSize()];
        try {
            file = new File(this.getQualifiedFileName());
            fis = new FileInputStream(file);
            gis = new GZIPInputStream(fis);
            isr = new InputStreamReader((InputStream)gis, encoding);
            reader = new BufferedReader(isr);
            reader.read(cbuf);
            String json = new String(cbuf);
            Type typeOfMap = new TypeToken<ConcurrentSkipListMap<Long, JobProcessData>>(){}.getType();
            map = (ConcurrentSkipListMap)this.gson.fromJson(json, typeOfMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return map;
    }
}

