/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.verifier;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.camel.ComponentVerifier;
import org.apache.camel.impl.verifier.DefaultResultVerificationError;
import org.apache.camel.util.ObjectHelper;

public final class ResultErrorBuilder {
    private ComponentVerifier.VerificationError.Code code;
    private String description;
    private Set<String> parameters;
    private Map<ComponentVerifier.VerificationError.Attribute, Object> attributes;

    public ResultErrorBuilder code(ComponentVerifier.VerificationError.Code code) {
        this.code = code;
        return this;
    }

    public ResultErrorBuilder code(String code) {
        this.code(ComponentVerifier.VerificationError.asCode(code));
        return this;
    }

    public ResultErrorBuilder description(String description) {
        this.description = description;
        return this;
    }

    public ResultErrorBuilder parameterKey(String parameter) {
        if (parameter != null) {
            if (this.parameters == null) {
                this.parameters = new HashSet<String>();
            }
            this.parameters.add(parameter);
        }
        return this;
    }

    public ResultErrorBuilder parameterKeys(Collection<String> parameterList) {
        if (parameterList != null) {
            parameterList.forEach(this::parameterKey);
        }
        return this;
    }

    public ResultErrorBuilder detail(String key, Object value) {
        this.detail(ComponentVerifier.VerificationError.asAttribute(key), value);
        return this;
    }

    public ResultErrorBuilder detail(ComponentVerifier.VerificationError.Attribute key, Object value) {
        if (value != null) {
            if (this.attributes == null) {
                this.attributes = new HashMap<ComponentVerifier.VerificationError.Attribute, Object>();
            }
            this.attributes.put(key, value);
        }
        return this;
    }

    public <T> ResultErrorBuilder detail(String key, Supplier<Optional<T>> supplier) {
        this.detail(ComponentVerifier.VerificationError.asAttribute(key), supplier);
        return this;
    }

    public <T> ResultErrorBuilder detail(ComponentVerifier.VerificationError.Attribute key, Supplier<Optional<T>> supplier) {
        supplier.get().ifPresent(value -> this.detail(key, value));
        return this;
    }

    public ResultErrorBuilder details(Map<ComponentVerifier.VerificationError.Attribute, Object> details) {
        for (Map.Entry<ComponentVerifier.VerificationError.Attribute, Object> entry : details.entrySet()) {
            this.detail(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public ComponentVerifier.VerificationError build() {
        return new DefaultResultVerificationError(this.code, this.description, this.parameters != null ? Collections.unmodifiableSet(this.parameters) : Collections.emptySet(), this.attributes != null ? Collections.unmodifiableMap(this.attributes) : Collections.emptyMap());
    }

    public static ResultErrorBuilder fromError(ComponentVerifier.VerificationError error) {
        return new ResultErrorBuilder().code(error.getCode()).description(error.getDescription()).parameterKeys(error.getParameterKeys()).details(error.getDetails());
    }

    public static ResultErrorBuilder withCode(ComponentVerifier.VerificationError.Code code) {
        return new ResultErrorBuilder().code(code);
    }

    public static ResultErrorBuilder withCode(String code) {
        return new ResultErrorBuilder().code(code);
    }

    public static ResultErrorBuilder withHttpCode(int code) {
        return ResultErrorBuilder.withCode(ResultErrorBuilder.convertHttpCodeToErrorCode(code)).detail((ComponentVerifier.VerificationError.Attribute)ComponentVerifier.VerificationError.HttpAttribute.HTTP_CODE, (Object)code);
    }

    public static ResultErrorBuilder withHttpCodeAndText(int code, String text) {
        return ResultErrorBuilder.withCodeAndDescription(ResultErrorBuilder.convertHttpCodeToErrorCode(code), text).detail((ComponentVerifier.VerificationError.Attribute)ComponentVerifier.VerificationError.HttpAttribute.HTTP_CODE, (Object)code).detail((ComponentVerifier.VerificationError.Attribute)ComponentVerifier.VerificationError.HttpAttribute.HTTP_TEXT, (Object)text);
    }

    private static ComponentVerifier.VerificationError.StandardCode convertHttpCodeToErrorCode(int code) {
        return code >= 400 && code < 500 ? ComponentVerifier.VerificationError.StandardCode.AUTHENTICATION : ComponentVerifier.VerificationError.StandardCode.GENERIC;
    }

    public static ResultErrorBuilder withCodeAndDescription(ComponentVerifier.VerificationError.Code code, String description) {
        return new ResultErrorBuilder().code(code).description(description);
    }

    public static ResultErrorBuilder withUnsupportedScope(String scope) {
        return new ResultErrorBuilder().code(ComponentVerifier.VerificationError.StandardCode.UNSUPPORTED_SCOPE).description("Unsupported scope: " + scope);
    }

    public static ResultErrorBuilder withUnsupportedComponent(String component) {
        return new ResultErrorBuilder().code(ComponentVerifier.VerificationError.StandardCode.UNSUPPORTED_COMPONENT).description("Unsupported component: " + component);
    }

    public static ResultErrorBuilder withException(Exception exception) {
        return new ResultErrorBuilder().code(ComponentVerifier.VerificationError.StandardCode.EXCEPTION).description(exception.getMessage()).detail((ComponentVerifier.VerificationError.Attribute)ComponentVerifier.VerificationError.ExceptionAttribute.EXCEPTION_INSTANCE, (Object)exception).detail((ComponentVerifier.VerificationError.Attribute)ComponentVerifier.VerificationError.ExceptionAttribute.EXCEPTION_CLASS, (Object)exception.getClass().getName());
    }

    public static ResultErrorBuilder withMissingOption(String optionName) {
        return new ResultErrorBuilder().code(ComponentVerifier.VerificationError.StandardCode.MISSING_PARAMETER).description(optionName + " should be set").parameterKey(optionName);
    }

    public static ResultErrorBuilder withUnknownOption(String optionName) {
        return new ResultErrorBuilder().code(ComponentVerifier.VerificationError.StandardCode.UNKNOWN_PARAMETER).description("Unknown option " + optionName).parameterKey(optionName);
    }

    public static ResultErrorBuilder withIllegalOption(String optionName) {
        return new ResultErrorBuilder().code(ComponentVerifier.VerificationError.StandardCode.ILLEGAL_PARAMETER).description("Illegal option " + optionName).parameterKey(optionName);
    }

    public static ResultErrorBuilder withIllegalOption(String optionName, String optionValue) {
        return ObjectHelper.isNotEmpty(optionValue) ? new ResultErrorBuilder().code(ComponentVerifier.VerificationError.StandardCode.ILLEGAL_PARAMETER_VALUE).description(optionName + " has wrong value (" + optionValue + ")").parameterKey(optionName) : ResultErrorBuilder.withIllegalOption(optionName);
    }
}

