/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.camel.CamelContext;
import org.apache.camel.impl.validator.ValidatorKey;
import org.apache.camel.model.validator.ValidatorDefinition;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.Validator;
import org.apache.camel.spi.ValidatorRegistry;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.LRUCache;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;

public class DefaultValidatorRegistry
extends LRUCache<ValidatorKey, Validator>
implements ValidatorRegistry<ValidatorKey> {
    private static final long serialVersionUID = 1L;
    private ConcurrentMap<ValidatorKey, Validator> staticMap = new ConcurrentHashMap<ValidatorKey, Validator>();
    private final CamelContext context;

    public DefaultValidatorRegistry(CamelContext context) throws Exception {
        this(context, new ArrayList<ValidatorDefinition>());
    }

    public DefaultValidatorRegistry(CamelContext context, List<ValidatorDefinition> definitions) throws Exception {
        super(CamelContextHelper.getMaximumValidatorCacheSize(context), CamelContextHelper.getMaximumValidatorCacheSize(context), false);
        this.context = context;
        for (ValidatorDefinition def : definitions) {
            Validator validator = def.createValidator(context);
            context.addService(validator);
            this.put(new ValidatorKey(new DataType(def.getType())), validator);
        }
    }

    @Override
    public Validator resolveValidator(ValidatorKey key) {
        Validator answer = this.get(key);
        if (answer == null && ObjectHelper.isNotEmpty(key.getType().getName())) {
            answer = this.get(new ValidatorKey(new DataType(key.getType().getModel())));
        }
        return answer;
    }

    @Override
    public void start() throws Exception {
        this.resetStatistics();
    }

    @Override
    public Validator get(Object o) {
        Validator answer = (Validator)this.staticMap.get(o);
        if (answer == null) {
            answer = (Validator)super.get(o);
        } else {
            this.hits.incrementAndGet();
        }
        return answer;
    }

    @Override
    public Validator put(ValidatorKey key, Validator validator) {
        Validator answer = (Validator)this.staticMap.remove(key);
        if (answer != null) {
            this.staticMap.put(key, validator);
            return answer;
        }
        answer = (Validator)super.remove(key);
        if (answer != null) {
            super.put(key, validator);
            return answer;
        }
        answer = this.context.isSetupRoutes() || this.context.isStartingRoutes() ? this.staticMap.put(key, validator) : super.put(key, validator);
        return answer;
    }

    @Override
    public void putAll(Map<? extends ValidatorKey, ? extends Validator> map) {
        for (Map.Entry<? extends ValidatorKey, ? extends Validator> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean containsKey(Object o) {
        return this.staticMap.containsKey(o) || super.containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.staticMap.containsValue(o) || super.containsValue(o);
    }

    @Override
    public int size() {
        return this.staticMap.size() + super.size();
    }

    @Override
    public int staticSize() {
        return this.staticMap.size();
    }

    @Override
    public int dynamicSize() {
        return super.size();
    }

    @Override
    public boolean isEmpty() {
        return this.staticMap.isEmpty() && super.isEmpty();
    }

    @Override
    public Validator remove(Object o) {
        Validator answer = (Validator)this.staticMap.remove(o);
        if (answer == null) {
            answer = (Validator)super.remove(o);
        }
        return answer;
    }

    @Override
    public void clear() {
        this.staticMap.clear();
        super.clear();
    }

    @Override
    public Set<ValidatorKey> keySet() {
        LinkedHashSet<ValidatorKey> answer = new LinkedHashSet<ValidatorKey>();
        answer.addAll(this.staticMap.keySet());
        answer.addAll(super.keySet());
        return answer;
    }

    @Override
    public Collection<Validator> values() {
        ArrayList<Validator> answer = new ArrayList<Validator>();
        answer.addAll(this.staticMap.values());
        answer.addAll(super.values());
        return answer;
    }

    @Override
    public Set<Map.Entry<ValidatorKey, Validator>> entrySet() {
        LinkedHashSet<Map.Entry<ValidatorKey, Validator>> answer = new LinkedHashSet<Map.Entry<ValidatorKey, Validator>>();
        answer.addAll(this.staticMap.entrySet());
        answer.addAll(super.entrySet());
        return answer;
    }

    @Override
    public int getMaximumCacheSize() {
        return super.getMaxCacheSize();
    }

    @Override
    public void purge() {
        super.clear();
    }

    @Override
    public boolean isStatic(DataType type) {
        return this.staticMap.containsKey(new ValidatorKey(type));
    }

    @Override
    public boolean isDynamic(DataType type) {
        return super.containsKey(new ValidatorKey(type));
    }

    @Override
    public void stop() throws Exception {
        ServiceHelper.stopServices(this.staticMap.values());
        ServiceHelper.stopServices(this.values());
        this.purge();
    }

    @Override
    public String toString() {
        return "ValidatorRegistry for " + this.context.getName() + ", capacity: " + this.getMaxCacheSize();
    }
}

