/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.rule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaBlock;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.condition.AbstractRutaCondition;
import org.apache.uima.ruta.rule.AbstractRuleElement;
import org.apache.uima.ruta.rule.ComposedRuleElementMatch;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.RuleApply;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleElementCaretaker;
import org.apache.uima.ruta.rule.RuleElementContainer;
import org.apache.uima.ruta.rule.RuleElementMatch;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.rule.RutaRuleElement;
import org.apache.uima.ruta.rule.quantifier.RuleElementQuantifier;
import org.apache.uima.ruta.visitor.InferenceCrowd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComposedRuleElement
extends AbstractRuleElement
implements RuleElementContainer {
    protected List<RuleElement> elements;
    protected RuleElementContainer caretaker;

    public ComposedRuleElement(List<RuleElement> elements, RuleElementQuantifier quantifier, List<AbstractRutaCondition> conditions, List<AbstractRutaAction> actions, RuleElementContainer container, RutaBlock parent) {
        super(quantifier, conditions, actions, container, parent);
        this.elements = elements;
        this.caretaker = new RuleElementCaretaker(this);
    }

    @Override
    public void apply(RuleMatch match, RutaStream symbolStream, InferenceCrowd crowd) {
        this.applyRuleElements(match, symbolStream, crowd);
        super.apply(match, symbolStream, crowd);
    }

    @Override
    public void startMatch(RuleMatch ruleMatch, RuleApply ruleApply, ComposedRuleElementMatch containerMatch, RuleElement entryPoint, RutaStream stream, InferenceCrowd crowd) {
        RuleElement anchorElement = this.getAnchoringRuleElement(stream);
        ComposedRuleElementMatch composedMatch = this.createComposedMatch(ruleMatch, containerMatch);
        anchorElement.startMatch(ruleMatch, ruleApply, composedMatch, entryPoint, stream, crowd);
    }

    protected ComposedRuleElementMatch createComposedMatch(RuleMatch ruleMatch, ComposedRuleElementMatch containerMatch) {
        ComposedRuleElementMatch composedMatch = new ComposedRuleElementMatch(this, containerMatch);
        this.includeMatch(ruleMatch, containerMatch, composedMatch);
        return composedMatch;
    }

    @Override
    public void continueMatch(boolean after, AnnotationFS annotation, RuleMatch ruleMatch, RuleApply ruleApply, ComposedRuleElementMatch containerMatch, RutaRuleElement sideStepOrigin, RuleElement entryPoint, RutaStream stream, InferenceCrowd crowd) {
        RuleElement nextElement = this.getNextElement(after, this);
        if (nextElement != null) {
            ComposedRuleElementMatch composedMatch = this.createComposedMatch(ruleMatch, containerMatch);
            nextElement.continueMatch(after, annotation, ruleMatch, ruleApply, composedMatch, sideStepOrigin, entryPoint, stream, crowd);
        } else {
            this.fallback(after, false, annotation, ruleMatch, ruleApply, containerMatch, sideStepOrigin, entryPoint, stream, crowd);
        }
    }

    @Override
    public void continueOwnMatch(boolean after, AnnotationFS annotation, RuleMatch ruleMatch, RuleApply ruleApply, ComposedRuleElementMatch containerMatch, RutaRuleElement sideStepOrigin, RuleElement entryPoint, RutaStream stream, InferenceCrowd crowd) {
        if (!stream.isSimpleGreedyForComposed()) {
            this.continueMatch(after, annotation, ruleMatch, ruleApply, containerMatch, sideStepOrigin, entryPoint, stream, crowd);
        } else {
            boolean stopMatching = false;
            boolean failed = false;
            AnnotationFS nextAnnotation = annotation;
            while (!stopMatching) {
                RuleElement nextElement = this.getNextElement(after, this);
                if (nextElement != null) {
                    ComposedRuleElementMatch composedMatch = this.createComposedMatch(ruleMatch, containerMatch);
                    nextElement.continueMatch(after, nextAnnotation, ruleMatch, ruleApply, composedMatch, sideStepOrigin, this, stream, crowd);
                    ComposedRuleElementMatch parentContainerMatch = containerMatch.getContainerMatch();
                    List<RuleElementMatch> match = this.getMatch(ruleMatch, parentContainerMatch);
                    int lenghtBefore = match.size();
                    List<RuleElementMatch> evaluateMatches = this.quantifier.evaluateMatches(match, this.parent, crowd);
                    ruleMatch.setMatched(ruleMatch.matched() && evaluateMatches != null);
                    if (evaluateMatches.size() != lenghtBefore) {
                        failed = true;
                        stopMatching = true;
                    }
                    if (!this.quantifier.continueMatch(after, nextAnnotation, this, ruleMatch, containerMatch, stream, crowd)) {
                        stopMatching = true;
                    }
                    List<AnnotationFS> textsMatched = evaluateMatches.get(evaluateMatches.size() - 1).getTextsMatched();
                    nextAnnotation = textsMatched.get(textsMatched.size() - 1);
                    continue;
                }
                stopMatching = true;
            }
            this.fallback(after, failed, nextAnnotation, ruleMatch, ruleApply, containerMatch, sideStepOrigin, entryPoint, stream, crowd);
        }
    }

    public void fallbackContinue(boolean after, boolean failed, AnnotationFS annotation, RuleMatch ruleMatch, RuleApply ruleApply, ComposedRuleElementMatch containerMatch, RutaRuleElement sideStepOrigin, RuleElement entryPoint, RutaStream stream, InferenceCrowd crowd) {
        RuleElementContainer container = this.getContainer();
        this.doMatch(containerMatch, stream, crowd);
        if (this.equals(entryPoint) && ruleApply == null) {
            return;
        }
        if (container == null) {
            this.fallback(after, failed, annotation, ruleMatch, ruleApply, containerMatch, sideStepOrigin, entryPoint, stream, crowd);
        } else {
            ComposedRuleElementMatch parentContainerMatch = containerMatch.getContainerMatch();
            RuleElement nextElement = container.getNextElement(after, this);
            List<RuleElementMatch> match = this.getMatch(ruleMatch, parentContainerMatch);
            List<RuleElementMatch> evaluateMatches = this.quantifier.evaluateMatches(match, this.parent, crowd);
            ruleMatch.setMatched(ruleMatch.matched() && evaluateMatches != null);
            if (failed) {
                if (nextElement != null) {
                    AnnotationFS backtrackedAnnotation = this.getBacktrackedAnnotation(evaluateMatches);
                    if (backtrackedAnnotation != null) {
                        nextElement.continueMatch(after, backtrackedAnnotation, ruleMatch, ruleApply, parentContainerMatch, sideStepOrigin, null, stream, crowd);
                    } else {
                        this.fallback(after, failed, annotation, ruleMatch, ruleApply, parentContainerMatch, sideStepOrigin, entryPoint, stream, crowd);
                    }
                } else {
                    this.fallback(after, failed, annotation, ruleMatch, ruleApply, parentContainerMatch, sideStepOrigin, entryPoint, stream, crowd);
                }
            } else if (this.quantifier.continueMatch(after, annotation, this, ruleMatch, parentContainerMatch, stream, crowd)) {
                this.continueOwnMatch(after, annotation, ruleMatch, ruleApply, parentContainerMatch, sideStepOrigin, null, stream, crowd);
            } else if (nextElement != null) {
                nextElement.continueMatch(after, annotation, ruleMatch, ruleApply, parentContainerMatch, sideStepOrigin, null, stream, crowd);
            } else {
                this.fallback(after, failed, annotation, ruleMatch, ruleApply, parentContainerMatch, sideStepOrigin, entryPoint, stream, crowd);
            }
        }
    }

    private AnnotationFS getBacktrackedAnnotation(List<RuleElementMatch> evaluateMatches) {
        if (evaluateMatches == null) {
            return null;
        }
        List<AnnotationFS> textsMatched = evaluateMatches.get(evaluateMatches.size() - 1).getTextsMatched();
        if (textsMatched.isEmpty()) {
            return null;
        }
        AnnotationFS backtrackedAnnotation = textsMatched.get(textsMatched.size() - 1);
        return backtrackedAnnotation;
    }

    private void fallback(boolean after, boolean failed, AnnotationFS annotation, RuleMatch ruleMatch, RuleApply ruleApply, ComposedRuleElementMatch containerMatch, RutaRuleElement sideStepOrigin, RuleElement entryPoint, RutaStream stream, InferenceCrowd crowd) {
        RuleElementContainer parentContainer = this.getContainer();
        if (parentContainer instanceof ComposedRuleElement) {
            ComposedRuleElement parentElement = (ComposedRuleElement)parentContainer;
            parentElement.fallbackContinue(after, failed, annotation, ruleMatch, ruleApply, containerMatch, sideStepOrigin, entryPoint, stream, crowd);
        } else if (sideStepOrigin != null) {
            sideStepOrigin.continueSideStep(after, ruleMatch, ruleApply, containerMatch, entryPoint, stream, crowd);
        } else {
            this.doneMatching(ruleMatch, ruleApply, stream, crowd);
        }
    }

    private void includeMatch(RuleMatch ruleMatch, ComposedRuleElementMatch containerMatch, ComposedRuleElementMatch composedMatch) {
        if (containerMatch == null) {
            ruleMatch.setRootMatch(composedMatch);
        } else {
            containerMatch.addInnerMatch(this, composedMatch, false);
        }
    }

    private void doMatch(ComposedRuleElementMatch match, RutaStream stream, InferenceCrowd crowd) {
        List<AnnotationFS> textsMatched = match.getTextsMatched();
        if (textsMatched == null || textsMatched.isEmpty()) {
            return;
        }
        int begin = textsMatched.get(0).getBegin();
        int end = textsMatched.get(textsMatched.size() - 1).getEnd();
        AnnotationFS annotation = stream.getCas().createAnnotation(stream.getCas().getAnnotationType(), begin, end);
        ArrayList<EvaluatedCondition> evaluatedConditions = new ArrayList<EvaluatedCondition>(this.conditions.size());
        for (AbstractRutaCondition condition : this.conditions) {
            crowd.beginVisit(condition, null);
            EvaluatedCondition eval = condition.eval(annotation, this, stream, crowd);
            crowd.endVisit(condition, null);
            evaluatedConditions.add(eval);
        }
        match.setConditionInfo(evaluatedConditions);
        match.evaluateInnerMatches(true);
    }

    @Override
    public Collection<AnnotationFS> getAnchors(RutaStream stream) {
        RuleElement anchorElement = this.getAnchoringRuleElement(stream);
        Collection<AnnotationFS> anchors = anchorElement.getAnchors(stream);
        return anchors;
    }

    @Override
    public int estimateAnchors(RutaStream stream) {
        int result = 1;
        for (RuleElement each : this.elements) {
            result += each.estimateAnchors(stream);
        }
        return result;
    }

    @Override
    public RuleElement getAnchoringRuleElement(RutaStream stream) {
        return this.caretaker.getAnchoringRuleElement(stream);
    }

    @Override
    public List<RuleElement> getRuleElements() {
        return this.elements;
    }

    public void setRuleElements(List<RuleElement> elements) {
        this.elements = elements;
    }

    @Override
    public RuleElement getFirstElement() {
        return this.caretaker.getFirstElement();
    }

    @Override
    public RuleElement getLastElement() {
        return this.caretaker.getLastElement();
    }

    @Override
    public void applyRuleElements(RuleMatch ruleMatch, RutaStream stream, InferenceCrowd crowd) {
        this.caretaker.applyRuleElements(ruleMatch, stream, crowd);
    }

    public String toString() {
        String simpleName = this.getQuantifier().getClass().getSimpleName();
        return "(" + (this.elements == null ? "null" : this.elements.toString()) + ")" + (simpleName.equals("NormalQuantifier") ? "" : simpleName) + (this.conditions.isEmpty() ? "" : "(" + this.conditions.toString() + ")" + "\\n") + (this.actions.isEmpty() ? "" : "{" + this.actions.toString() + "}");
    }

    @Override
    public RuleElement getNextElement(boolean after, RuleElement ruleElement) {
        return this.caretaker.getNextElement(after, ruleElement);
    }
}

