/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.resource.RutaWordList;
import org.apache.uima.ruta.resource.TextNode;
import org.apache.uima.ruta.resource.XMLEventHandler;
import org.apache.uima.ruta.type.RutaBasic;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeWordList
implements RutaWordList {
    private TextNode root;
    private String name;

    public TreeWordList() {
        this.root = null;
    }

    public TreeWordList(String pathname) throws IOException {
        FileInputStream fstream;
        File f;
        if (pathname.endsWith(".twl")) {
            f = new File(pathname);
            fstream = new FileInputStream(f);
            this.readXML(fstream, "UTF-8");
        }
        if (pathname.endsWith(".txt")) {
            f = new File(pathname);
            fstream = new FileInputStream(f);
            this.buildNewTree(fstream);
        }
        this.name = new File(pathname).getName();
    }

    public TreeWordList(InputStream stream, String name) throws IOException {
        if (name.endsWith(".twl")) {
            this.readXML(stream, "UTF-8");
        }
        if (name.endsWith(".txt")) {
            this.buildNewTree(stream);
        }
        this.name = new File(name).getName();
    }

    public TreeWordList(List<String> data) {
        this.buildNewTree(data);
        this.name = "local";
    }

    public void buildNewTree(List<String> data) {
        this.root = new TextNode();
        for (String s : data) {
            this.addWord(s);
        }
    }

    public void buildNewTree(InputStream stream) throws IOException {
        Scanner scan = new Scanner(stream, "UTF-8");
        this.root = new TextNode();
        while (scan.hasNextLine()) {
            String s = scan.nextLine().trim();
            if (s.endsWith("=")) {
                s = s.substring(0, s.length() - 1);
                s = s.trim();
            }
            this.addWord(s);
        }
        scan.close();
    }

    public TextNode getRoot() {
        return this.root;
    }

    public void addWord(String s) {
        TextNode pointer = this.root;
        char[] arr$ = s.toCharArray();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Character each = Character.valueOf(arr$[i$]);
            TextNode childNode = pointer.getChildNode(each.charValue());
            if (childNode == null) {
                childNode = new TextNode(each.charValue(), false);
                pointer.addChild(childNode);
            }
            pointer = childNode;
        }
        pointer.setWordEnd(s.length() > 0);
    }

    @Override
    public boolean contains(String s, boolean ignoreCase, int size, char[] ignoreChars, int maxIgnoreChars, boolean ignoreWS) {
        TextNode pointer = this.root;
        return this.recursiveContains(pointer, s, 0, ignoreCase && s.length() > size, false, ignoreChars, maxIgnoreChars, ignoreWS);
    }

    @Override
    public boolean containsFragment(String s, boolean ignoreCase, int size, char[] ignoreChars, int maxIgnoreChars, boolean ignoreWS) {
        TextNode pointer = this.root;
        return this.recursiveContains(pointer, s, 0, ignoreCase && s.length() > size, true, ignoreChars, maxIgnoreChars, ignoreWS);
    }

    private boolean recursiveContains(TextNode pointer, String text, int index, boolean ignoreCase, boolean fragment, char[] ignoreChars, int maxIgnoreChars, boolean ignoreWS) {
        if (pointer == null) {
            return false;
        }
        if (index == text.length()) {
            return fragment || pointer.isWordEnd();
        }
        char charAt = text.charAt(index);
        boolean charAtIgnored = false;
        if (ignoreChars != null) {
            for (char each : ignoreChars) {
                if (each != charAt) continue;
                charAtIgnored = true;
                break;
            }
            charAtIgnored &= index != 0;
        }
        int next = ++index;
        if (ignoreCase) {
            TextNode childNodeL = pointer.getChildNode(Character.toLowerCase(charAt));
            TextNode childNodeU = pointer.getChildNode(Character.toUpperCase(charAt));
            if (childNodeL == null && ignoreWS) {
                childNodeL = this.skipWS(pointer, charAt);
            }
            if (childNodeU == null && ignoreWS) {
                childNodeU = this.skipWS(pointer, charAt);
            }
            if (charAtIgnored && childNodeL == null && childNodeU == null) {
                return this.recursiveContains(pointer, text, next, ignoreCase, fragment, ignoreChars, maxIgnoreChars, ignoreWS);
            }
            return this.recursiveContains(childNodeL, text, next, ignoreCase, fragment, ignoreChars, maxIgnoreChars, ignoreWS) | this.recursiveContains(childNodeU, text, next, ignoreCase, fragment, ignoreChars, maxIgnoreChars, ignoreWS);
        }
        TextNode childNode = pointer.getChildNode(charAt);
        if (childNode == null && ignoreWS) {
            childNode = this.skipWS(pointer, charAt);
        }
        if (charAtIgnored && childNode == null) {
            return this.recursiveContains(pointer, text, next, ignoreCase, fragment, ignoreChars, maxIgnoreChars, ignoreWS);
        }
        return this.recursiveContains(childNode, text, next, ignoreCase, fragment, ignoreChars, maxIgnoreChars, ignoreWS);
    }

    private TextNode skipWS(TextNode pointer, char charAt) {
        TextNode childNode = pointer.getChildNode(' ');
        if (childNode != null) {
            TextNode node = childNode.getChildNode(charAt);
            if (node == null) {
                return this.skipWS(childNode, charAt);
            }
            return node;
        }
        return null;
    }

    public List<AnnotationFS> find(RutaStream stream, boolean ignoreCase, int size, char[] ignoreChars, int maxIgnoredChars, boolean ignoreWS) {
        ArrayList<AnnotationFS> results = new ArrayList<AnnotationFS>();
        stream.moveToFirst();
        FSIterator<AnnotationFS> streamPointer = stream.copy();
        while (stream.isValid()) {
            RutaBasic anchorBasic = (RutaBasic)stream.get();
            streamPointer.moveTo((FeatureStructure)anchorBasic);
            ArrayList<RutaBasic> basicsToAdd = new ArrayList<RutaBasic>();
            basicsToAdd.add(anchorBasic);
            String text = anchorBasic.getCoveredText();
            StringBuilder candidate = new StringBuilder(text);
            Annotation interResult = null;
            while (streamPointer.isValid()) {
                if (this.containsFragment(candidate.toString(), ignoreCase, size, ignoreChars, maxIgnoredChars, ignoreWS)) {
                    streamPointer.moveToNext();
                    if (streamPointer.isValid()) {
                        RutaBasic next = (RutaBasic)streamPointer.get();
                        if (this.contains(candidate.toString(), ignoreCase, size, ignoreChars, maxIgnoredChars, ignoreWS)) {
                            interResult = new Annotation(stream.getJCas(), ((RutaBasic)((Object)basicsToAdd.get(0))).getBegin(), ((RutaBasic)((Object)basicsToAdd.get(basicsToAdd.size() - 1))).getEnd());
                        }
                        candidate.append(next.getCoveredText());
                        basicsToAdd.add(next);
                        continue;
                    }
                    this.tryToCreateAnnotation(stream, ignoreCase, size, results, basicsToAdd, candidate.toString(), interResult, ignoreChars, maxIgnoredChars, ignoreWS);
                    continue;
                }
                basicsToAdd.remove(basicsToAdd.size() - 1);
                this.tryToCreateAnnotation(stream, ignoreCase, size, results, basicsToAdd, candidate.toString(), interResult, ignoreChars, maxIgnoredChars, ignoreWS);
                break;
            }
            stream.moveToNext();
        }
        return results;
    }

    public List<AnnotationFS> find(RutaStream stream, boolean ignoreCase, int size, boolean ignoreWS) {
        return this.find(stream, ignoreCase, size, null, 0, ignoreWS);
    }

    private void tryToCreateAnnotation(RutaStream stream, boolean ignoreCase, int size, ArrayList<AnnotationFS> results, List<RutaBasic> basicsToAdd, String lastCandidate, Annotation interResult, char[] ignoreChars, int maxIgnoredChars, boolean ignoreWS) {
        if (basicsToAdd.size() >= 1 && this.contains(lastCandidate, ignoreCase, size, ignoreChars, maxIgnoredChars, ignoreWS)) {
            results.add((AnnotationFS)new Annotation(stream.getJCas(), basicsToAdd.get(0).getBegin(), basicsToAdd.get(basicsToAdd.size() - 1).getEnd()));
        } else if (interResult != null) {
            results.add((AnnotationFS)interResult);
        }
    }

    public void readXML(InputStream stream, String encoding) throws IOException {
        try {
            InputStreamReader streamReader = new InputStreamReader(stream, encoding);
            this.root = new TextNode();
            XMLEventHandler handler = new XMLEventHandler(this.root);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setContentHandler(handler);
            reader.setErrorHandler(handler);
            reader.parse(new InputSource(streamReader));
        }
        catch (SAXParseException spe) {
            StringBuffer sb = new StringBuffer(spe.toString());
            sb.append("\n  Line number: " + spe.getLineNumber());
            sb.append("\n Column number: " + spe.getColumnNumber());
            sb.append("\n Public ID: " + spe.getPublicId());
            sb.append("\n System ID: " + spe.getSystemId() + "\n");
            System.out.println(sb.toString());
        }
        catch (SAXException se) {
            System.out.println("loadDOM threw " + se);
            se.printStackTrace(System.out);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void createXMLFile(String path, String encoding) {
        try {
            FileOutputStream output = new FileOutputStream(path);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)output, encoding);
            writer.write("<?xml version=\"1.0\" ?>");
            writer.write("<root>");
            for (TextNode child : this.root.getChildren().values()) {
                this.writeNode(writer, child);
            }
            writer.write("</root>");
            writer.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeNode(Writer writer, TextNode node) {
        try {
            String output = "<node char=\"" + node.getValue() + "\" isWordEnd=\"" + Boolean.toString(node.isWordEnd()) + "\">";
            writer.write(output);
            for (TextNode child : node.getChildren().values()) {
                this.writeNode(writer, child);
            }
            writer.write("</node>");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return this.name;
    }

    public List<AnnotationFS> find(RutaStream stream, Map<String, Type> typeMap, boolean ignoreCase, int ignoreLength, boolean edit, double distance, String ignoreToken) {
        return null;
    }

    public List<String> contains(String string, boolean ignoreCase, int ignoreLength, boolean edit, double distance, String ignoreToken) {
        return null;
    }

    public List<String> containsFragment(String string, boolean ignoreCase, int ignoreLength, boolean edit, double distance, String ignoreToken) {
        return null;
    }

    public void startDocument() {
    }

    public void endDocument() {
    }
}

