/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.engine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlConverterPSpan
implements Comparable<HtmlConverterPSpan> {
    private int begin;
    private int end;
    private String txt;

    public HtmlConverterPSpan(int begin, int end, String txt) {
        this.begin = begin;
        this.end = end;
        this.txt = txt;
    }

    public String getTxt() {
        return this.txt;
    }

    public int getLength() {
        return this.end - this.begin;
    }

    public int getBegin() {
        return this.begin;
    }

    public int getEnd() {
        return this.end;
    }

    @Override
    public int compareTo(HtmlConverterPSpan o) {
        if (this.begin == o.begin) {
            if (this.end == o.end) {
                return 0;
            }
            return this.end < o.end ? -1 : 1;
        }
        return this.begin < o.end ? -1 : 1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.begin;
        result = 31 * result + this.end;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HtmlConverterPSpan other = (HtmlConverterPSpan)obj;
        if (this.begin != other.begin) {
            return false;
        }
        return this.end == other.end;
    }

    public String toString() {
        String shortTxt = this.txt.length() > 10 ? this.txt.substring(0, 10) + "..." : this.txt;
        return String.format("[%d-%d : %s]", this.begin, this.end, shortTxt);
    }
}

