/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.condition;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.condition.AbstractRutaCondition;
import org.apache.uima.ruta.condition.ComposedRutaCondition;
import org.apache.uima.ruta.expression.number.NumberExpression;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.visitor.InferenceCrowd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MOfNCondition
extends ComposedRutaCondition {
    private final NumberExpression min;
    private final NumberExpression max;

    public MOfNCondition(List<AbstractRutaCondition> conditions, NumberExpression min, NumberExpression max) {
        super(conditions);
        this.min = min;
        this.max = max;
    }

    @Override
    public EvaluatedCondition eval(AnnotationFS annotation, RuleElement element, RutaStream stream, InferenceCrowd crowd) {
        int result = 0;
        ArrayList<EvaluatedCondition> evals = new ArrayList<EvaluatedCondition>();
        for (AbstractRutaCondition each : this.conditions) {
            crowd.beginVisit(each, null);
            EvaluatedCondition eval = each.eval(annotation, element, stream, crowd);
            crowd.endVisit(each, null);
            evals.add(eval);
            if (!eval.isValue()) continue;
            ++result;
        }
        boolean value = result >= this.min.getIntegerValue(element.getParent()) && result <= this.max.getIntegerValue(element.getParent());
        return new EvaluatedCondition(this, value, evals);
    }

    public NumberExpression getMin() {
        return this.min;
    }

    public NumberExpression getMax() {
        return this.max;
    }
}

