/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.ListUtils;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.expression.bool.BooleanExpression;
import org.apache.uima.ruta.expression.list.ListExpression;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.visitor.InferenceCrowd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeAction
extends AbstractRutaAction {
    private List<ListExpression> lists;
    private BooleanExpression unionExpr;
    private String target;

    public MergeAction(BooleanExpression union, String target, List<ListExpression> list) {
        this.unionExpr = union;
        this.target = target;
        this.lists = list;
    }

    @Override
    public void execute(RuleMatch match, RuleElement element, RutaStream stream, InferenceCrowd crowd) {
        boolean union = this.unionExpr.getBooleanValue(element.getParent());
        ArrayList list = new ArrayList();
        if (union) {
            for (ListExpression each : this.lists) {
                list.addAll(each.getList(element.getParent()));
            }
        } else {
            List lastList = null;
            for (int i = 1; i < this.lists.size(); ++i) {
                List l2 = this.lists.get(i).getList(element.getParent());
                if (lastList != null) {
                    lastList = ListUtils.intersection(lastList, l2);
                    continue;
                }
                List l1 = this.lists.get(i - 1).getList(element.getParent());
                lastList = ListUtils.intersection(l1, l2);
            }
            list = lastList;
        }
        if (list != null) {
            element.getParent().getEnvironment().setVariableValue(this.target, list);
        }
    }

    public BooleanExpression getUnion() {
        return this.unionExpr;
    }

    public List<ListExpression> getLists() {
        return this.lists;
    }

    public String getTarget() {
        return this.target;
    }
}

