/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.security;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.configuration2.Configuration;
import org.apache.fulcrum.security.GroupManager;
import org.apache.fulcrum.security.PermissionManager;
import org.apache.fulcrum.security.RoleManager;
import org.apache.fulcrum.security.acl.AccessControlList;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.Permission;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.model.turbine.TurbineModelManager;
import org.apache.fulcrum.security.model.turbine.entity.TurbineRole;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.EntityExistsException;
import org.apache.fulcrum.security.util.GroupSet;
import org.apache.fulcrum.security.util.PasswordMismatchException;
import org.apache.fulcrum.security.util.PermissionSet;
import org.apache.fulcrum.security.util.RoleSet;
import org.apache.fulcrum.security.util.UnknownEntityException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.torque.avalon.Torque;
import org.apache.torque.avalon.TorqueComponent;
import org.apache.turbine.om.security.User;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.ServiceManager;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.security.SecurityService;
import org.apache.turbine.services.security.UserManager;

public class DefaultSecurityService
extends TurbineBaseService
implements SecurityService {
    private AtomicInteger readerCount = new AtomicInteger(0);
    private UserManager userManager = null;
    private GroupManager groupManager;
    private RoleManager roleManager;
    private PermissionManager permissionManager;
    private TurbineModelManager modelManager;
    private TorqueComponent backend;
    private static volatile Group globalGroup = null;
    private static final Logger log = LogManager.getLogger(DefaultSecurityService.class);

    @Override
    public void init() throws InitializationException {
        ServiceManager manager = TurbineServices.getInstance();
        this.groupManager = (GroupManager)manager.getService(GroupManager.ROLE);
        this.roleManager = (RoleManager)manager.getService(RoleManager.ROLE);
        this.permissionManager = (PermissionManager)manager.getService(PermissionManager.ROLE);
        this.modelManager = (TurbineModelManager)manager.getService(TurbineModelManager.ROLE);
        this.backend = (TorqueComponent)manager.getService(Torque.ROLE);
        Configuration conf = this.getConfiguration();
        String userManagerClassName = conf.getString("user.manager", SecurityService.USER_MANAGER_DEFAULT);
        try {
            this.userManager = (UserManager)Class.forName(userManagerClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.userManager.init(conf);
        }
        catch (Exception e) {
            throw new InitializationException("Failed to instantiate UserManager", e);
        }
        this.setInit(true);
    }

    @Override
    public <U extends User> U getUserInstance() throws UnknownEntityException {
        Object user;
        try {
            user = this.getUserManager().getUserInstance();
        }
        catch (DataBackendException e) {
            throw new UnknownEntityException("Failed instantiate an User implementation object", (Throwable)e);
        }
        return user;
    }

    @Override
    public <U extends User> U getUserInstance(String userName) throws UnknownEntityException {
        Object user;
        try {
            user = this.getUserManager().getUserInstance(userName);
        }
        catch (DataBackendException e) {
            throw new UnknownEntityException("Failed instantiate an User implementation object", (Throwable)e);
        }
        return user;
    }

    @Override
    public <G extends Group> G getGroupInstance() throws UnknownEntityException {
        Group group;
        try {
            group = this.groupManager.getGroupInstance();
        }
        catch (Exception e) {
            throw new UnknownEntityException("Failed to instantiate a Group implementation object", (Throwable)e);
        }
        return (G)group;
    }

    @Override
    public <G extends Group> G getGroupInstance(String groupName) throws UnknownEntityException {
        Group group;
        try {
            group = this.groupManager.getGroupInstance(groupName);
        }
        catch (Exception e) {
            throw new UnknownEntityException("Failed to instantiate a Group implementation object", (Throwable)e);
        }
        return (G)group;
    }

    @Override
    public <P extends Permission> P getPermissionInstance() throws UnknownEntityException {
        Permission permission;
        try {
            permission = this.permissionManager.getPermissionInstance();
        }
        catch (Exception e) {
            throw new UnknownEntityException("Failed to instantiate a Permission implementation object", (Throwable)e);
        }
        return (P)permission;
    }

    @Override
    public <P extends Permission> P getPermissionInstance(String permName) throws UnknownEntityException {
        Permission permission;
        try {
            permission = this.permissionManager.getPermissionInstance(permName);
        }
        catch (Exception e) {
            throw new UnknownEntityException("Failed to instantiate a Permission implementation object", (Throwable)e);
        }
        return (P)permission;
    }

    @Override
    public <R extends Role> R getRoleInstance() throws UnknownEntityException {
        Role role;
        try {
            role = this.roleManager.getRoleInstance();
        }
        catch (Exception e) {
            throw new UnknownEntityException("Failed to instantiate a Role implementation object", (Throwable)e);
        }
        return (R)role;
    }

    @Override
    public <R extends Role> R getRoleInstance(String roleName) throws UnknownEntityException {
        Role role;
        try {
            role = this.roleManager.getRoleInstance(roleName);
        }
        catch (Exception e) {
            throw new UnknownEntityException("Failed to instantiate a Role implementation object", (Throwable)e);
        }
        return (R)role;
    }

    @Override
    public UserManager getUserManager() {
        return this.userManager;
    }

    @Override
    public boolean accountExists(User user) throws DataBackendException {
        return this.getUserManager().accountExists(user);
    }

    @Override
    public boolean accountExists(String userName) throws DataBackendException {
        return this.getUserManager().accountExists(userName);
    }

    @Override
    public <U extends User> U getAuthenticatedUser(String username, String password) throws DataBackendException, UnknownEntityException, PasswordMismatchException {
        return this.getUserManager().retrieve(username, password);
    }

    @Override
    public <U extends User> U getUser(String username) throws DataBackendException, UnknownEntityException {
        return this.getUserManager().retrieve(username);
    }

    @Override
    public <U extends User> U getAnonymousUser() throws UnknownEntityException {
        return this.getUserManager().getAnonymousUser();
    }

    @Override
    public boolean isAnonymousUser(User user) {
        return this.getUserManager().isAnonymousUser(user);
    }

    @Override
    public void saveUser(User user) throws UnknownEntityException, DataBackendException {
        this.getUserManager().store(user);
    }

    @Override
    public void saveOnSessionUnbind(User user) throws UnknownEntityException, DataBackendException {
        this.getUserManager().saveOnSessionUnbind(user);
    }

    @Override
    public void addUser(User user, String password) throws UnknownEntityException, DataBackendException, EntityExistsException {
        this.getUserManager().createAccount(user, password);
    }

    @Override
    public void removeUser(User user) throws DataBackendException, UnknownEntityException {
        if (user == null) {
            throw new UnknownEntityException("user is null");
        }
        this.modelManager.revokeAll((org.apache.fulcrum.security.entity.User)user.getUserDelegate());
        this.getUserManager().removeAccount(user);
    }

    @Override
    public void changePassword(User user, String oldPassword, String newPassword) throws PasswordMismatchException, UnknownEntityException, DataBackendException {
        this.getUserManager().changePassword(user, oldPassword, newPassword);
    }

    @Override
    public void forcePassword(User user, String password) throws UnknownEntityException, DataBackendException {
        this.getUserManager().forcePassword(user, password);
    }

    protected void lockShared() {
        this.readerCount.incrementAndGet();
    }

    protected void unlockShared() {
        this.readerCount.decrementAndGet();
        this.notify();
    }

    protected void lockExclusive() {
        while (this.readerCount.get() > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected void unlockExclusive() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public <G extends Group> G getGlobalGroup() {
        if (globalGroup == null) {
            Class<DefaultSecurityService> clazz = DefaultSecurityService.class;
            // MONITORENTER : org.apache.turbine.services.security.DefaultSecurityService.class
            if (globalGroup == null) {
                try {
                    globalGroup = this.modelManager.getGlobalGroup();
                }
                catch (DataBackendException e) {
                    log.error("Failed to retrieve global group object: ", (Throwable)e);
                }
            }
            // MONITOREXIT : clazz
        }
        Group g = globalGroup;
        return (G)g;
    }

    @Override
    public <G extends Group> G getGroupByName(String name) throws DataBackendException, UnknownEntityException {
        return (G)this.groupManager.getGroupByName(name);
    }

    @Override
    public <G extends Group> G getGroupById(int id) throws DataBackendException, UnknownEntityException {
        return (G)this.groupManager.getGroupById((Object)id);
    }

    @Override
    public <R extends Role> R getRoleByName(String name) throws DataBackendException, UnknownEntityException {
        Role role = this.roleManager.getRoleByName(name);
        if (role instanceof TurbineRole) {
            ((TurbineRole)role).setPermissions(this.getPermissions(role));
        }
        return (R)role;
    }

    @Override
    public <R extends Role> R getRoleById(int id) throws DataBackendException, UnknownEntityException {
        Role role = this.roleManager.getRoleById((Object)id);
        if (role instanceof TurbineRole) {
            ((TurbineRole)role).setPermissions(this.getPermissions(role));
        }
        return (R)role;
    }

    @Override
    public <P extends Permission> P getPermissionByName(String name) throws DataBackendException, UnknownEntityException {
        return (P)this.permissionManager.getPermissionByName(name);
    }

    @Override
    public <P extends Permission> P getPermissionById(int id) throws DataBackendException, UnknownEntityException {
        return (P)this.permissionManager.getPermissionById((Object)id);
    }

    @Override
    public GroupSet getAllGroups() throws DataBackendException {
        return this.groupManager.getAllGroups();
    }

    @Override
    public RoleSet getAllRoles() throws DataBackendException {
        return this.roleManager.getAllRoles();
    }

    @Override
    public PermissionSet getAllPermissions() throws DataBackendException {
        return this.permissionManager.getAllPermissions();
    }

    @Override
    public <A extends AccessControlList> A getACL(User user) throws DataBackendException, UnknownEntityException {
        return this.getUserManager().getACL(user);
    }

    @Override
    public void grant(User user, Group group, Role role) throws DataBackendException, UnknownEntityException {
        if (user == null) {
            throw new UnknownEntityException("user is null");
        }
        this.modelManager.grant((org.apache.fulcrum.security.entity.User)user.getUserDelegate(), group, role);
    }

    @Override
    public void revoke(User user, Group group, Role role) throws DataBackendException, UnknownEntityException {
        if (user == null) {
            throw new UnknownEntityException("user is null");
        }
        this.modelManager.revoke((org.apache.fulcrum.security.entity.User)user.getUserDelegate(), group, role);
    }

    @Override
    public void replaceRole(User user, Role role, Role newRole) throws DataBackendException, UnknownEntityException {
        this.modelManager.replace((org.apache.fulcrum.security.entity.User)user, role, newRole);
    }

    @Override
    public void revokeAll(User user) throws DataBackendException, UnknownEntityException {
        if (user == null) {
            throw new UnknownEntityException("user is null");
        }
        this.modelManager.revokeAll((org.apache.fulcrum.security.entity.User)user.getUserDelegate());
    }

    @Override
    public void grant(Role role, Permission permission) throws DataBackendException, UnknownEntityException {
        this.modelManager.grant(role, permission);
    }

    @Override
    public void revoke(Role role, Permission permission) throws DataBackendException, UnknownEntityException {
        this.modelManager.revoke(role, permission);
    }

    @Override
    public void revokeAll(Role role) throws DataBackendException, UnknownEntityException {
        this.modelManager.revokeAll(role);
    }

    @Override
    public void revokeAll(Role role, boolean cascadeDelete) throws DataBackendException, UnknownEntityException {
        this.modelManager.revokeAll(role, cascadeDelete);
    }

    @Override
    public PermissionSet getPermissions(Role role) throws DataBackendException, UnknownEntityException {
        return ((TurbineRole)role).getPermissions();
    }

    @Override
    public <G extends Group> G addGroup(G group) throws DataBackendException, EntityExistsException {
        return (G)this.groupManager.addGroup(group);
    }

    @Override
    public <R extends Role> R addRole(R role) throws DataBackendException, EntityExistsException {
        return (R)this.roleManager.addRole(role);
    }

    @Override
    public <P extends Permission> P addPermission(P permission) throws DataBackendException, EntityExistsException {
        return (P)this.permissionManager.addPermission(permission);
    }

    @Override
    public void removeGroup(Group group) throws DataBackendException, UnknownEntityException {
        this.groupManager.removeGroup(group);
    }

    @Override
    public void removeRole(Role role) throws DataBackendException, UnknownEntityException {
        this.roleManager.removeRole(role);
    }

    @Override
    public void removePermission(Permission permission) throws DataBackendException, UnknownEntityException {
        this.permissionManager.removePermission(permission);
    }

    @Override
    public void renameGroup(Group group, String name) throws DataBackendException, UnknownEntityException {
        this.groupManager.renameGroup(group, name);
    }

    @Override
    public void renameRole(Role role, String name) throws DataBackendException, UnknownEntityException {
        this.roleManager.renameRole(role, name);
    }

    @Override
    public void renamePermission(Permission permission, String name) throws DataBackendException, UnknownEntityException {
        this.permissionManager.renamePermission(permission, name);
    }
}

