/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.utils.props;

import java.io.InputStream;
import java.util.Properties;

public abstract class PropertyLoader {
    private static final boolean THROW_ON_LOAD_FAILURE = true;
    private static final String SUFFIX = ".ccf";
    private static final String SUFFIX_PROPERTIES = ".properties";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String name, ClassLoader loader) {
        String fileName;
        boolean isCCFSuffix = true;
        if (name == null) {
            throw new IllegalArgumentException("null input: name");
        }
        ClassLoader classLoader = loader == null ? ClassLoader.getSystemClassLoader() : loader;
        String string = fileName = name.startsWith("/") ? name.substring(1) : name;
        if (fileName.endsWith(SUFFIX)) {
            fileName = fileName.substring(0, fileName.length() - SUFFIX.length());
        }
        if (fileName.endsWith(SUFFIX_PROPERTIES)) {
            fileName = fileName.substring(0, fileName.length() - SUFFIX_PROPERTIES.length());
            isCCFSuffix = false;
        }
        Properties result = null;
        InputStream in = null;
        try {
            fileName = fileName.replace('.', '/');
            if (!fileName.endsWith(SUFFIX) && isCCFSuffix) {
                fileName = fileName.concat(SUFFIX);
            } else if (!fileName.endsWith(SUFFIX_PROPERTIES) && !isCCFSuffix) {
                fileName = fileName.concat(SUFFIX_PROPERTIES);
            }
            in = classLoader.getResourceAsStream(fileName);
            if (in != null) {
                result = new Properties();
                result.load(in);
            }
        }
        catch (Exception e) {
            result = null;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Throwable throwable) {}
            }
        }
        if (result == null) {
            throw new IllegalArgumentException("could not load [" + fileName + "] as a classloader resource");
        }
        return result;
    }

    public static Properties loadProperties(String name) {
        return PropertyLoader.loadProperties(name, Thread.currentThread().getContextClassLoader());
    }

    private PropertyLoader() {
    }
}

