/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services;

import java.util.Hashtable;
import java.util.Stack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.turbine.services.BaseInitable;
import org.apache.turbine.services.Initable;
import org.apache.turbine.services.InitableBroker;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.InstantiationException;

public abstract class BaseInitableBroker
implements InitableBroker {
    protected Hashtable<String, Initable> initables = new Hashtable();
    protected Stack<String> stack = new Stack();
    private final Logger log = LogManager.getLogger(this.getClass());

    protected BaseInitableBroker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initClass(String className, Object data) throws InitializationException {
        Stack<String> stack = this.stack;
        synchronized (stack) {
            int pos = this.stack.search(className);
            if (pos != -1) {
                StringBuilder msg = new StringBuilder().append(className).append(" couldn't be initialized because of circular dependency chain:\n");
                for (int i = pos; i > 0; --i) {
                    msg.append((String)this.stack.elementAt(this.stack.size() - i - 1) + "->");
                }
                msg.append(className).append('\n');
                throw new InitializationException(msg.toString());
            }
            try {
                this.stack.push(className);
                Initable instance = this.getInitableInstance(className);
                if (!instance.getInit()) {
                    instance.init(data);
                }
            }
            finally {
                this.stack.pop();
            }
        }
    }

    @Override
    public void shutdownClass(String className) {
        try {
            Initable initable = this.getInitableInstance(className);
            if (initable.getInit()) {
                initable.shutdown();
                ((BaseInitable)initable).setInit(false);
            }
        }
        catch (InstantiationException e) {
            this.log.error("Shutdown of a nonexistent class {} was requested", (Object)className, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Initable getInitable(String className) throws InstantiationException {
        try {
            Initable initable = this.getInitableInstance(className);
            if (!initable.getInit()) {
                Class<?> clazz = initable.getClass();
                synchronized (clazz) {
                    if (!initable.getInit()) {
                        initable.init();
                    }
                    if (!initable.getInit()) {
                        throw new InitializationException("init() failed to initialize class " + className);
                    }
                }
            }
            return initable;
        }
        catch (InitializationException e) {
            throw new InstantiationException("Class " + className + " failed to initialize", e);
        }
    }

    protected Initable getInitableInstance(String className) throws InstantiationException {
        Initable initable = this.initables.get(className);
        if (initable == null) {
            try {
                initable = (Initable)Class.forName(className).newInstance();
            }
            catch (ThreadDeath t) {
                throw t;
            }
            catch (OutOfMemoryError t) {
                throw t;
            }
            catch (Throwable t) {
                String msg = null;
                msg = t instanceof NoClassDefFoundError ? "A class referenced by " + className + " is unavailable. Check your jars and classes." : (t instanceof ClassNotFoundException ? "Class " + className + " is unavailable. Check your jars and classes." : (t instanceof ClassCastException ? "Class " + className + " doesn't implement Initable." : "Failed to instantiate " + className));
                throw new InstantiationException(msg, t);
            }
            initable.setInitableBroker(this);
            this.initables.put(className, initable);
        }
        return initable;
    }
}

