/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.combined.CombinedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.FileBasedBuilderParameters;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.builder.fluent.PropertiesBuilderParameters;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.FileLocationStrategy;
import org.apache.commons.configuration2.io.HomeDirectoryLocationStrategy;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.turbine.modules.PageLoader;
import org.apache.turbine.pipeline.Pipeline;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.pipeline.TurbinePipeline;
import org.apache.turbine.services.Initable;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.ServiceManager;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.rundata.RunDataService;
import org.apache.turbine.services.template.TemplateService;
import org.apache.turbine.util.LocaleUtils;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.ServerData;
import org.apache.turbine.util.TurbineException;

@WebServlet(name="Turbine", urlPatterns={"/app"}, loadOnStartup=1, initParams={@WebInitParam(name="applicationRoot", value="webContext"), @WebInitParam(name="properties", value="/WEB-INF/conf/TurbineResources.properties")})
@MultipartConfig
public class Turbine
extends HttpServlet {
    private static final long serialVersionUID = -6317118078613623990L;
    @Deprecated
    public static final String REDIRECTED_PATHINFO_NAME = "redirected";
    @Deprecated
    public static final String BASEDIR_KEY = "basedir";
    private static boolean firstInit = true;
    private static Pipeline pipeline = null;
    private static Throwable initFailure = null;
    private static boolean firstDoGet = true;
    private static volatile ServerData serverData = null;
    private static String applicationRoot;
    private static ServletConfig servletConfig;
    private static ServletContext servletContext;
    private static String webappRoot;
    private static Configuration configuration;
    private static final Logger log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws ServletException {
        Class<Turbine> clazz = Turbine.class;
        synchronized (Turbine.class) {
            super.init();
            if (!firstInit) {
                log.info("Double initialization of Turbine was attempted!");
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            firstInit = false;
            ServletConfig config = this.getServletConfig();
            try {
                ServletContext context = config.getServletContext();
                this.configure(config, context);
                TemplateService templateService = (TemplateService)this.getServiceManager().getService("TemplateService");
                if (templateService == null) {
                    throw new TurbineException("No Template Service configured!");
                }
                if (this.getRunDataService() == null) {
                    throw new TurbineException("No RunData Service configured!");
                }
            }
            catch (Throwable e) {
                initFailure = e;
                log.fatal("Turbine: init() failed", e);
                throw new ServletException("Turbine: init() failed", e);
            }
            log.info("Turbine: init() Ready to Rumble!");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void configure(ServletConfig config, ServletContext context) throws Exception {
        applicationRoot = this.findInitParameter(context, config, "applicationRoot", "webContext");
        webappRoot = context.getRealPath("/");
        if (applicationRoot == null || applicationRoot.equals("webContext")) {
            applicationRoot = webappRoot;
        }
        Turbine.setApplicationRoot(applicationRoot);
        Path confPath = this.configureApplication(config, context);
        this.configureLogging(confPath);
        Turbine.setTurbineServletConfig(config);
        Turbine.setTurbineServletContext(context);
        this.getServiceManager().setApplicationRoot(applicationRoot);
        configuration.setProperty("applicationRoot", (Object)applicationRoot);
        configuration.setProperty("webappRoot", (Object)webappRoot);
        this.getServiceManager().setConfiguration(configuration);
        this.getServiceManager().init();
        String descriptorPath = configuration.getString("pipeline.default.descriptor", "/WEB-INF/conf/turbine-classic-pipeline.xml");
        log.debug("Using descriptor path: {}", (Object)descriptorPath);
        if (!descriptorPath.startsWith("/")) {
            descriptorPath = "/" + descriptorPath;
        }
        try (InputStream reader = context.getResourceAsStream(descriptorPath);){
            JAXBContext jaxb = JAXBContext.newInstance((Class[])new Class[]{TurbinePipeline.class});
            Unmarshaller unmarshaller = jaxb.createUnmarshaller();
            pipeline = (Pipeline)unmarshaller.unmarshal(reader);
        }
        log.debug("Initializing pipeline");
        pipeline.initialize();
    }

    protected Path configureApplication(ServletConfig config, ServletContext context) throws IOException, ConfigurationException {
        ConfigurationStyle confStyle = ConfigurationStyle.UNSET;
        String confFile = this.findInitParameter(context, config, "configuration", null);
        if (StringUtils.isNotEmpty((CharSequence)confFile)) {
            confStyle = ConfigurationStyle.XML;
        } else {
            confFile = this.findInitParameter(context, config, "properties", null);
            if (StringUtils.isNotEmpty((CharSequence)confFile)) {
                confStyle = ConfigurationStyle.PROPERTIES;
            }
        }
        if (confStyle == ConfigurationStyle.UNSET) {
            confFile = this.findInitParameter(context, config, "properties", "/WEB-INF/conf/TurbineResources.properties");
            confStyle = ConfigurationStyle.PROPERTIES;
        }
        log.debug("Loading configuration ({}) from {}", (Object)confStyle, (Object)confFile);
        Parameters params = new Parameters();
        File confPath = Turbine.getApplicationRootAsFile();
        if (confFile.startsWith("/")) {
            confFile = confFile.substring(1);
        }
        Path confFileRelativePath = Paths.get(confFile, new String[0]);
        Path targetPath = Paths.get(confPath.toURI());
        Path targetPathDirectory = (targetPath = targetPath.resolve(confFileRelativePath)).getParent();
        if (targetPathDirectory != null) {
            confPath = targetPathDirectory.normalize().toFile();
            Path targetFilePath = targetPath.getFileName();
            if (targetFilePath != null) {
                confFile = targetFilePath.toString();
            }
        }
        switch (confStyle) {
            case XML: {
                CombinedConfigurationBuilder combinedBuilder = new CombinedConfigurationBuilder().configure(new BuilderParameters[]{(BuilderParameters)((FileBasedBuilderParameters)((FileBasedBuilderParameters)params.fileBased().setFileName(confFile)).setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','))).setLocationStrategy((FileLocationStrategy)new HomeDirectoryLocationStrategy(confPath.getCanonicalPath(), false))});
                configuration = (Configuration)combinedBuilder.getConfiguration();
                break;
            }
            case PROPERTIES: {
                FileBasedConfigurationBuilder propertiesBuilder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)((PropertiesBuilderParameters)((PropertiesBuilderParameters)params.properties().setFileName(confFile)).setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','))).setLocationStrategy((FileLocationStrategy)new HomeDirectoryLocationStrategy(confPath.getCanonicalPath(), false))});
                configuration = (Configuration)propertiesBuilder.getConfiguration();
                break;
            }
            case JSON: 
            case YAML: {
                throw new NotImplementedException("JSON or XAML configuration style not yet implemented!");
            }
        }
        log.info("Loaded configuration ({}) from {} style: {}", (Object)confStyle, (Object)confFile, (Object)configuration.toString());
        return targetPath;
    }

    protected String findInitParameter(ServletContext context, ServletConfig config, String name, String defaultValue) {
        String path = null;
        String parameterName = name;
        boolean usingNamespace = parameterName.startsWith("org.apache.turbine");
        while (StringUtils.isEmpty((CharSequence)(path = config.getInitParameter(parameterName))) && StringUtils.isEmpty((CharSequence)(path = context.getInitParameter(parameterName)))) {
            if (usingNamespace) {
                path = defaultValue;
                break;
            }
            parameterName = "org.apache.turbine." + parameterName;
            usingNamespace = true;
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(PipelineData data) {
        Class<Turbine> clazz = Turbine.class;
        synchronized (Turbine.class) {
            if (firstDoGet) {
                Turbine.saveServletInfo(data);
                TurbineServices services = (TurbineServices)this.getServiceManager();
                Iterator<String> i = services.getServiceNames();
                while (i.hasNext()) {
                    String serviceName = i.next();
                    Object service = services.getService(serviceName);
                    if (!(service instanceof Initable)) continue;
                    try {
                        ((Initable)service).init(data);
                    }
                    catch (InitializationException e) {
                        log.warn("Could not initialize Initable {} with PipelineData", (Object)serviceName, (Object)e);
                    }
                }
                firstDoGet = false;
                log.info("Turbine: first Request successful");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static Configuration getConfiguration() {
        return configuration;
    }

    public static String getServerName() {
        return Turbine.getDefaultServerData().getServerName();
    }

    public static String getServerScheme() {
        return Turbine.getDefaultServerData().getServerScheme();
    }

    public static String getServerPort() {
        return Integer.toString(Turbine.getDefaultServerData().getServerPort());
    }

    public static String getScriptName() {
        return Turbine.getDefaultServerData().getScriptName();
    }

    public static String getContextPath() {
        return Turbine.getDefaultServerData().getContextPath();
    }

    public static ServerData getDefaultServerData() {
        if (serverData == null) {
            String serverName = configuration.getString("serverdata.default.serverName");
            if (serverName == null) {
                log.error("ServerData Information requested from Turbine before first request!");
            } else {
                log.info("ServerData Information retrieved from configuration.");
            }
            serverData = new ServerData(serverName, configuration.getInt("serverdata.default.serverPort", 80), configuration.getString("serverdata.default.serverScheme", "http"), configuration.getString("serverdata.default.scriptName"), configuration.getString("serverdata.default.contextPath"));
        }
        return serverData;
    }

    public static void setTurbineServletConfig(ServletConfig config) {
        servletConfig = config;
    }

    public static ServletConfig getTurbineServletConfig() {
        return servletConfig;
    }

    public static void setTurbineServletContext(ServletContext context) {
        servletContext = context;
    }

    public static ServletContext getTurbineServletContext() {
        return servletContext;
    }

    public void destroy() {
        this.getServiceManager().shutdownServices();
        firstInit = true;
        firstDoGet = true;
        log.info("Turbine: Done shutting down!");
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        if (initFailure != null) {
            this.handleHorribleException(res, initFailure);
            return;
        }
        try (RunData pipelineData = this.getRunDataService().getRunData(req, res, this.getServletConfig());){
            try {
                HashMap<Class<RunData>, RunData> runDataMap = new HashMap<Class<RunData>, RunData>();
                runDataMap.put(RunData.class, pipelineData);
                pipelineData.put(RunData.class, runDataMap);
                if (firstDoGet) {
                    this.init(pipelineData);
                }
                pipeline.invoke(pipelineData);
            }
            catch (Throwable t) {
                this.handleException(pipelineData, res, t);
            }
        }
        catch (Throwable t) {
            this.handleHorribleException(res, t);
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doGet(req, res);
    }

    public String getServletInfo() {
        return "Turbine Servlet";
    }

    protected void handleException(PipelineData pipelineData, HttpServletResponse res, Throwable t) {
        RunData data = (RunData)pipelineData;
        log.error("Turbine.handleException: ", t);
        try {
            data.setStackTrace(ExceptionUtils.getStackTrace((Throwable)t), t);
            data.setScreen(configuration.getString("screen.error", "VelocityErrorScreen"));
            if (data.getTemplateInfo() != null) {
                data.getTemplateInfo().setScreenTemplate(configuration.getString("template.error", "error.vm"));
            }
            data.setAction("");
            PageLoader.getInstance().exec(pipelineData, configuration.getString("page.default", "DefaultPage"));
            data.getResponse().setContentType(data.getContentType());
            data.getResponse().setStatus(data.getStatusCode());
        }
        catch (Throwable reallyScrewedNow) {
            this.handleHorribleException(res, reallyScrewedNow);
        }
    }

    protected void handleHorribleException(HttpServletResponse res, Throwable t) {
        try {
            res.setContentType("text/plain");
            res.setStatus(200);
            PrintWriter writer = res.getWriter();
            writer.println("Horrible Exception: ");
            t.printStackTrace(writer);
        }
        catch (Exception exception) {
            // empty catch block
        }
        log.error(t.getMessage(), t);
    }

    public static synchronized void saveServletInfo(PipelineData data) {
        ServerData requestServerData = data.get(Turbine.class, ServerData.class);
        serverData = (ServerData)requestServerData.clone();
    }

    protected void configureLogging(Path logConf) throws IOException {
        Path log4jFile;
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        if (context.getConfiguration().getConfigurationSource().getLocation() == null && (log4jFile = this.resolveLog4j2(logConf.getParent())) != null) {
            LogManager.getContext(null, (boolean)false, (URI)log4jFile.toUri());
        }
        log.info("resolved log4j2 location: {}", (Object)context.getConfiguration().getConfigurationSource().getLocation());
    }

    protected Path resolveLog4j2(Path logConfPath) {
        String log4jFile = configuration.getString("log4j2.file", "/WEB-INF/conf/log4j2.xml");
        if (log4jFile.startsWith("/")) {
            log4jFile = log4jFile.substring(1);
        }
        Path log4jTarget = null;
        if (StringUtils.isNotEmpty((CharSequence)log4jFile) && !log4jFile.equalsIgnoreCase("none") && logConfPath != null) {
            Path log4jFilePath = Paths.get(log4jFile, new String[0]);
            Path logFilePath = logConfPath.resolve(log4jFilePath);
            if (logFilePath != null && logFilePath.toFile().exists()) {
                log4jTarget = logFilePath.normalize();
            } else if (log4jFilePath != null && log4jFilePath.getParent() != null && logConfPath.endsWith(log4jFilePath.getParent()) && (logFilePath = logConfPath.resolve(log4jFilePath.getFileName())) != null && logFilePath.toFile().exists()) {
                log4jTarget = logFilePath.normalize();
            }
        }
        return log4jTarget;
    }

    public static void setApplicationRoot(String val) {
        applicationRoot = val;
    }

    public static String getApplicationRoot() {
        return applicationRoot;
    }

    public static File getApplicationRootAsFile() {
        return new File(applicationRoot);
    }

    public static String getRealPath(String path) {
        if (path.startsWith("/")) {
            return new File(Turbine.getApplicationRootAsFile(), path.substring(1)).getAbsolutePath();
        }
        return new File(Turbine.getApplicationRootAsFile(), path).getAbsolutePath();
    }

    private ServiceManager getServiceManager() {
        return TurbineServices.getInstance();
    }

    @Deprecated
    public static String getDefaultInputEncoding() {
        return LocaleUtils.getDefaultInputEncoding();
    }

    private RunDataService getRunDataService() {
        return (RunDataService)this.getServiceManager().getService("RunDataService");
    }

    static {
        configuration = null;
        log = LogManager.getLogger(Turbine.class);
    }

    private static enum ConfigurationStyle {
        XML,
        PROPERTIES,
        JSON,
        YAML,
        UNSET;

    }
}

