/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.writer;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.SortedSet;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.qualitycheck.Check;
import net.sf.uadetector.internal.data.BrowserOperatingSystemMappingComparator;
import net.sf.uadetector.internal.data.Data;
import net.sf.uadetector.internal.data.IdentifiableComparator;
import net.sf.uadetector.internal.data.OrderedPatternComparator;
import net.sf.uadetector.internal.data.domain.Browser;
import net.sf.uadetector.internal.data.domain.BrowserOperatingSystemMapping;
import net.sf.uadetector.internal.data.domain.BrowserPattern;
import net.sf.uadetector.internal.data.domain.BrowserType;
import net.sf.uadetector.internal.data.domain.Device;
import net.sf.uadetector.internal.data.domain.DevicePattern;
import net.sf.uadetector.internal.data.domain.OperatingSystem;
import net.sf.uadetector.internal.data.domain.OperatingSystemPattern;
import net.sf.uadetector.internal.data.domain.Robot;
import net.sf.uadetector.internal.util.RegularExpressionConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@ThreadSafe
public final class XmlDataWriter {
    private static final String INDENT_AMOUNT = "4";
    private static final String INDENT_OPTION = "yes";
    private static final String SCHEMA_URL = "http://user-agent-string.info/rpc/uasxmldata.dtd";

    private static Element createBrowser(Browser browser, Document doc) {
        Element b = doc.createElement("browser");
        Element id = doc.createElement("id");
        id.appendChild(doc.createTextNode(String.valueOf(browser.getId())));
        b.appendChild(id);
        Element family = doc.createElement("type");
        family.appendChild(doc.createTextNode(String.valueOf(browser.getType().getId())));
        b.appendChild(family);
        Element name = doc.createElement("name");
        name.appendChild(doc.createTextNode(browser.getFamilyName()));
        b.appendChild(name);
        Element url = doc.createElement("url");
        url.appendChild(doc.createCDATASection(browser.getUrl()));
        b.appendChild(url);
        Element company = doc.createElement("company");
        company.appendChild(doc.createCDATASection(browser.getProducer()));
        b.appendChild(company);
        Element companyUrl = doc.createElement("url_company");
        companyUrl.appendChild(doc.createCDATASection(browser.getProducerUrl()));
        b.appendChild(companyUrl);
        Element icon = doc.createElement("icon");
        icon.appendChild(doc.createTextNode(browser.getIcon()));
        b.appendChild(icon);
        Element botInfoUrl = doc.createElement("browser_info_url");
        botInfoUrl.appendChild(doc.createTextNode(browser.getInfoUrl()));
        b.appendChild(botInfoUrl);
        return b;
    }

    private static Element createBrowserOperatingSystemMappings(Data data, Document doc) {
        ArrayList<BrowserOperatingSystemMapping> mappings = new ArrayList<BrowserOperatingSystemMapping>(data.getBrowserToOperatingSystemMappings());
        Collections.sort(mappings, BrowserOperatingSystemMappingComparator.INSTANCE);
        Element browserTypesElement = doc.createElement("browsers_os");
        for (BrowserOperatingSystemMapping mapping : mappings) {
            Element t = doc.createElement("browser_os");
            Element browserId = doc.createElement("browser_id");
            browserId.appendChild(doc.createTextNode(String.valueOf(mapping.getBrowserId())));
            t.appendChild(browserId);
            Element osId = doc.createElement("os_id");
            osId.appendChild(doc.createTextNode(String.valueOf(mapping.getOperatingSystemId())));
            t.appendChild(osId);
            browserTypesElement.appendChild(t);
        }
        return browserTypesElement;
    }

    private static Element createBrowserPatterns(Data data, Document doc) {
        ArrayList patterns = new ArrayList(data.getBrowserPatterns().size());
        for (Map.Entry<Integer, SortedSet<BrowserPattern>> entry : data.getBrowserPatterns().entrySet()) {
            patterns.addAll(entry.getValue());
        }
        Collections.sort(patterns, new OrderedPatternComparator());
        Element browserTypesElement = doc.createElement("browsers_reg");
        for (BrowserPattern pattern : patterns) {
            Element t = doc.createElement("browser_reg");
            Element order = doc.createElement("order");
            order.appendChild(doc.createTextNode(String.valueOf(pattern.getPosition())));
            t.appendChild(order);
            Element id = doc.createElement("browser_id");
            id.appendChild(doc.createTextNode(String.valueOf(pattern.getId())));
            t.appendChild(id);
            Element family = doc.createElement("regstring");
            family.appendChild(doc.createTextNode(RegularExpressionConverter.convertPatternToPerlRegex(pattern.getPattern())));
            t.appendChild(family);
            browserTypesElement.appendChild(t);
        }
        return browserTypesElement;
    }

    private static Element createBrowsers(Data data, Document doc) {
        Element browsersElement = doc.createElement("browsers");
        ArrayList<Browser> browsers = new ArrayList<Browser>(data.getBrowsers());
        Collections.sort(browsers, IdentifiableComparator.INSTANCE);
        for (Browser browser : browsers) {
            browsersElement.appendChild(XmlDataWriter.createBrowser(browser, doc));
        }
        return browsersElement;
    }

    private static Element createBrowserTypes(Data data, Document doc) {
        Element browserTypesElement = doc.createElement("browser_types");
        ArrayList<BrowserType> browserTypes = new ArrayList<BrowserType>(data.getBrowserTypes().values());
        Collections.sort(browserTypes, IdentifiableComparator.INSTANCE);
        for (BrowserType browserType : browserTypes) {
            Element t = doc.createElement("browser_type");
            Element id = doc.createElement("id");
            id.appendChild(doc.createTextNode(String.valueOf(browserType.getId())));
            t.appendChild(id);
            Element family = doc.createElement("type");
            family.appendChild(doc.createTextNode(String.valueOf(browserType.getName())));
            t.appendChild(family);
            browserTypesElement.appendChild(t);
        }
        return browserTypesElement;
    }

    private static Element createDescription(@Nonnull Data data, @Nonnull Document doc) {
        Element description = doc.createElement("description");
        Element label = doc.createElement("label");
        description.appendChild(label).appendChild(doc.createTextNode("Data (format xml) for UASparser - http://user-agent-string.info/download/UASparser"));
        Element version = doc.createElement("version");
        description.appendChild(version).appendChild(doc.createTextNode(data.getVersion()));
        Element md5Checksum = doc.createElement("checksum");
        md5Checksum.setAttribute("type", "MD5");
        description.appendChild(md5Checksum).appendChild(doc.createTextNode("http://user-agent-string.info/rpc/get_data.php?format=xml&md5=y"));
        Element shaChecksum = doc.createElement("checksum");
        shaChecksum.setAttribute("type", "SHA1");
        description.appendChild(shaChecksum).appendChild(doc.createTextNode("http://user-agent-string.info/rpc/get_data.php?format=xml&sha1=y"));
        return description;
    }

    private static Element createDevice(Device device, Document doc) {
        Element b = doc.createElement("device");
        Element id = doc.createElement("id");
        id.appendChild(doc.createTextNode(String.valueOf(device.getId())));
        b.appendChild(id);
        Element name = doc.createElement("name");
        name.appendChild(doc.createTextNode(device.getName()));
        b.appendChild(name);
        Element icon = doc.createElement("icon");
        icon.appendChild(doc.createTextNode(device.getIcon()));
        b.appendChild(icon);
        Element botInfoUrl = doc.createElement("device_info_url");
        botInfoUrl.appendChild(doc.createTextNode(device.getInfoUrl()));
        b.appendChild(botInfoUrl);
        return b;
    }

    private static Element createDevicePatterns(Data data, Document doc) {
        ArrayList patterns = new ArrayList(data.getDevicePatterns().size());
        for (Map.Entry<Integer, SortedSet<DevicePattern>> entry : data.getDevicePatterns().entrySet()) {
            patterns.addAll(entry.getValue());
        }
        Collections.sort(patterns, new OrderedPatternComparator());
        Element deviceTypesElement = doc.createElement("devices_reg");
        for (DevicePattern pattern : patterns) {
            Element t = doc.createElement("device_reg");
            Element order = doc.createElement("order");
            order.appendChild(doc.createTextNode(String.valueOf(pattern.getPosition())));
            t.appendChild(order);
            Element id = doc.createElement("device_id");
            id.appendChild(doc.createTextNode(String.valueOf(pattern.getId())));
            t.appendChild(id);
            Element family = doc.createElement("regstring");
            family.appendChild(doc.createTextNode(RegularExpressionConverter.convertPatternToPerlRegex(pattern.getPattern())));
            t.appendChild(family);
            deviceTypesElement.appendChild(t);
        }
        return deviceTypesElement;
    }

    private static Element createDevices(Data data, Document doc) {
        Element devicesElement = doc.createElement("devices");
        ArrayList<Device> devices = new ArrayList<Device>(data.getDevices());
        Collections.sort(devices, IdentifiableComparator.INSTANCE);
        for (Device device : devices) {
            devicesElement.appendChild(XmlDataWriter.createDevice(device, doc));
        }
        return devicesElement;
    }

    private static Element createOperatingSystem(OperatingSystem operatingSystem, Document doc) {
        Element os = doc.createElement("os");
        Element id = doc.createElement("id");
        id.appendChild(doc.createTextNode(String.valueOf(operatingSystem.getId())));
        os.appendChild(id);
        Element family = doc.createElement("family");
        family.appendChild(doc.createTextNode(operatingSystem.getFamily()));
        os.appendChild(family);
        Element name = doc.createElement("name");
        name.appendChild(doc.createTextNode(operatingSystem.getName()));
        os.appendChild(name);
        Element url = doc.createElement("url");
        url.appendChild(doc.createCDATASection(operatingSystem.getUrl()));
        os.appendChild(url);
        Element company = doc.createElement("company");
        company.appendChild(doc.createCDATASection(operatingSystem.getProducer()));
        os.appendChild(company);
        Element companyUrl = doc.createElement("url_company");
        companyUrl.appendChild(doc.createCDATASection(operatingSystem.getProducerUrl()));
        os.appendChild(companyUrl);
        Element icon = doc.createElement("icon");
        icon.appendChild(doc.createTextNode(operatingSystem.getIcon()));
        os.appendChild(icon);
        Element botInfoUrl = doc.createElement("os_info_url");
        botInfoUrl.appendChild(doc.createTextNode(operatingSystem.getInfoUrl()));
        os.appendChild(botInfoUrl);
        return os;
    }

    private static Element createOperatingSystemPatterns(Data data, Document doc) {
        ArrayList patterns = new ArrayList(data.getOperatingSystemPatterns().size());
        for (Map.Entry<Integer, SortedSet<OperatingSystemPattern>> entry : data.getOperatingSystemPatterns().entrySet()) {
            patterns.addAll(entry.getValue());
        }
        Collections.sort(patterns, new OrderedPatternComparator());
        Element browserTypesElement = doc.createElement("operating_systems_reg");
        for (OperatingSystemPattern pattern : patterns) {
            Element t = doc.createElement("operating_system_reg");
            Element order = doc.createElement("order");
            order.appendChild(doc.createTextNode(String.valueOf(pattern.getPosition())));
            t.appendChild(order);
            Element id = doc.createElement("os_id");
            id.appendChild(doc.createTextNode(String.valueOf(pattern.getId())));
            t.appendChild(id);
            Element family = doc.createElement("regstring");
            family.appendChild(doc.createTextNode(RegularExpressionConverter.convertPatternToPerlRegex(pattern.getPattern())));
            t.appendChild(family);
            browserTypesElement.appendChild(t);
        }
        return browserTypesElement;
    }

    private static Element createOperatingSystems(Data data, Document doc) {
        Element operatingSystemsElement = doc.createElement("operating_systems");
        ArrayList<OperatingSystem> operatingSystems = new ArrayList<OperatingSystem>(data.getOperatingSystems());
        Collections.sort(operatingSystems, IdentifiableComparator.INSTANCE);
        for (OperatingSystem operatingSystem : operatingSystems) {
            operatingSystemsElement.appendChild(XmlDataWriter.createOperatingSystem(operatingSystem, doc));
        }
        return operatingSystemsElement;
    }

    private static Element createRobots(Data data, Document doc) {
        Element robotsElement = doc.createElement("robots");
        for (Robot robot : data.getRobots()) {
            robotsElement.appendChild(XmlDataWriter.createRobots(robot, doc));
        }
        return robotsElement;
    }

    private static Element createRobots(Robot robot, Document doc) {
        Element r = doc.createElement("robot");
        Element id = doc.createElement("id");
        id.appendChild(doc.createTextNode(String.valueOf(robot.getId())));
        r.appendChild(id);
        Element useragent = doc.createElement("useragent");
        useragent.appendChild(doc.createCDATASection(robot.getUserAgentString()));
        r.appendChild(useragent);
        Element family = doc.createElement("family");
        family.appendChild(doc.createTextNode(robot.getFamilyName()));
        r.appendChild(family);
        Element name = doc.createElement("name");
        name.appendChild(doc.createTextNode(robot.getName()));
        r.appendChild(name);
        Element company = doc.createElement("company");
        company.appendChild(doc.createCDATASection(robot.getProducer()));
        r.appendChild(company);
        Element companyUrl = doc.createElement("url_company");
        companyUrl.appendChild(doc.createCDATASection(robot.getProducerUrl()));
        r.appendChild(companyUrl);
        Element icon = doc.createElement("icon");
        icon.appendChild(doc.createTextNode(robot.getIcon()));
        r.appendChild(icon);
        Element botInfoUrl = doc.createElement("bot_info_url");
        botInfoUrl.appendChild(doc.createTextNode(robot.getInfoUrl()));
        r.appendChild(botInfoUrl);
        return r;
    }

    @Nonnull
    static DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        return docFactory.newDocumentBuilder();
    }

    static void transform(@Nonnull Source xmlInput, @Nonnull Result xmlOutput) throws TransformerException {
        Check.notNull((Object)xmlInput, (String)"xmlInput");
        Check.notNull((Object)xmlOutput, (String)"xmlOutput");
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", INDENT_OPTION);
        transformer.setOutputProperty("doctype-system", SCHEMA_URL);
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", INDENT_AMOUNT);
        transformer.transform(xmlInput, xmlOutput);
    }

    public static void write(@Nonnull Data data, @Nonnull OutputStream outputStream) throws ParserConfigurationException, TransformerException {
        Check.notNull((Object)data, (String)"data");
        Check.notNull((Object)outputStream, (String)"outputStream");
        Document doc = XmlDataWriter.newDocumentBuilder().newDocument();
        Element uasdataElement = doc.createElement("uasdata");
        doc.appendChild(uasdataElement);
        uasdataElement.appendChild(XmlDataWriter.createDescription(data, doc));
        Element dataElement = doc.createElement("data");
        uasdataElement.appendChild(dataElement);
        dataElement.appendChild(XmlDataWriter.createRobots(data, doc));
        dataElement.appendChild(XmlDataWriter.createOperatingSystems(data, doc));
        dataElement.appendChild(XmlDataWriter.createBrowsers(data, doc));
        dataElement.appendChild(XmlDataWriter.createBrowserTypes(data, doc));
        dataElement.appendChild(XmlDataWriter.createBrowserPatterns(data, doc));
        dataElement.appendChild(XmlDataWriter.createBrowserOperatingSystemMappings(data, doc));
        dataElement.appendChild(XmlDataWriter.createOperatingSystemPatterns(data, doc));
        dataElement.appendChild(XmlDataWriter.createDevices(data, doc));
        dataElement.appendChild(XmlDataWriter.createDevicePatterns(data, doc));
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(outputStream);
        XmlDataWriter.transform(source, result);
    }

    private XmlDataWriter() {
    }

    static interface Tag {
        public static final String BOT_INFO_URL = "bot_info_url";
        public static final String BROWSER = "browser";
        public static final String BROWSER_ID = "browser_id";
        public static final String BROWSER_INFO_URL = "browser_info_url";
        public static final String BROWSER_OS = "browser_os";
        public static final String BROWSER_REG = "browser_reg";
        public static final String BROWSER_TYPE = "browser_type";
        public static final String BROWSER_TYPES = "browser_types";
        public static final String BROWSERS = "browsers";
        public static final String BROWSERS_OS = "browsers_os";
        public static final String BROWSERS_REG = "browsers_reg";
        public static final String COMPANY = "company";
        public static final String DATA = "data";
        public static final String DESCRIPTION = "description";
        public static final String DEVICE = "device";
        public static final String DEVICE_ID = "device_id";
        public static final String DEVICE_INFO_URL = "device_info_url";
        public static final String DEVICE_REG = "device_reg";
        public static final String DEVICES = "devices";
        public static final String DEVICES_REG = "devices_reg";
        public static final String FAMILY = "family";
        public static final String ICON = "icon";
        public static final String ID = "id";
        public static final String LABEL = "label";
        public static final String NAME = "name";
        public static final String OPERATING_SYSTEM_REG = "operating_system_reg";
        public static final String OPERATING_SYSTEMS = "operating_systems";
        public static final String OPERATING_SYSTEMS_REG = "operating_systems_reg";
        public static final String ORDER = "order";
        public static final String OS = "os";
        public static final String OS_ID = "os_id";
        public static final String OS_INFO_URL = "os_info_url";
        public static final String REGSTRING = "regstring";
        public static final String ROBOT = "robot";
        public static final String ROBOTS = "robots";
        public static final String TYPE = "type";
        public static final String UASDATA = "uasdata";
        public static final String URL = "url";
        public static final String URL_COMPANY = "url_company";
        public static final String USERAGENT = "useragent";
    }
}

