/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules.actions.sessionvalidator;

import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.Turbine;
import org.apache.turbine.annotation.TurbineConfiguration;
import org.apache.turbine.annotation.TurbineService;
import org.apache.turbine.modules.actions.sessionvalidator.SessionValidator;
import org.apache.turbine.om.security.User;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.services.security.SecurityService;
import org.apache.turbine.util.RunData;

public class TemplateSecureSessionValidator
extends SessionValidator {
    private static Log log = LogFactory.getLog(TemplateSecureSessionValidator.class);
    @TurbineService
    private SecurityService security;
    @TurbineConfiguration
    private Configuration conf;

    @Override
    public void doPerform(PipelineData pipelineData) throws Exception {
        RunData data = this.getRunData(pipelineData);
        data.populate();
        if (data.getUser() == null) {
            log.debug((Object)"Fixing up empty User Object!");
            Object anonymousUser = this.security.getAnonymousUser();
            data.setUser(anonymousUser);
            data.save();
        }
        if (!data.getUser().hasLoggedIn()) {
            log.debug((Object)"User is not logged in!");
            if (StringUtils.isEmpty((String)data.getMessage())) {
                data.setMessage(this.conf.getString("login.message"));
            }
            String loginTemplate = this.conf.getString("template.login");
            log.debug((Object)("Sending User to the Login Screen (" + loginTemplate + ")"));
            data.getTemplateInfo().setScreenTemplate(loginTemplate);
            data.setAction(null);
        }
        log.debug((Object)"Login Check finished!");
        if (!data.hasScreen() && StringUtils.isEmpty((String)data.getTemplateInfo().getScreenTemplate())) {
            String template = this.conf.getString("template.homepage");
            if (StringUtils.isNotEmpty((String)template)) {
                data.getTemplateInfo().setScreenTemplate(template);
            } else {
                data.setScreen(this.conf.getString("screen.homepage"));
            }
        }
        if (data.getParameters().containsKey((Object)"_session_access_counter") && !this.security.isAnonymousUser((User)data.getUser()) && data.getParameters().getInt("_session_access_counter") < (Integer)data.getUser().getTemp("_session_access_counter") - 1) {
            if (data.getTemplateInfo().getScreenTemplate() != null) {
                data.getUser().setTemp("prev_template", data.getTemplateInfo().getScreenTemplate().replace('/', ','));
                data.getTemplateInfo().setScreenTemplate(this.conf.getString("template.invalidstate"));
            } else {
                data.getUser().setTemp("prev_screen", data.getScreen().replace('/', ','));
                data.setScreen(this.conf.getString("screen.invalidstate"));
            }
            data.getUser().setTemp("prev_parameters", data.getParameters());
            data.setAction("");
        }
        if (data.getTemplateInfo().getScreenTemplate() != null) {
            data.setScreen(null);
        }
        pipelineData.get(Turbine.class).put(User.class, data.getUser());
    }
}

