/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.cache.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.fulcrum.cache.CachedObject;
import org.apache.fulcrum.cache.GlobalCacheService;
import org.apache.fulcrum.cache.ObjectExpiredException;
import org.apache.fulcrum.cache.RefreshableCachedObject;

public class DefaultGlobalCacheService
extends AbstractLogEnabled
implements GlobalCacheService,
Runnable,
Configurable,
Initializable,
Disposable,
ThreadSafe {
    public static final int DEFAULT_INITIAL_CACHE_SIZE = 20;
    public static final String INITIAL_CACHE_SIZE = "cacheInitialSize";
    public static final String CACHE_CHECK_FREQUENCY = "cacheCheckFrequency";
    public static final long DEFAULT_CACHE_CHECK_FREQUENCY = 5000L;
    protected Hashtable cache = null;
    private long cacheCheckFrequency;
    private int cacheInitialSize;
    private Thread housekeeping;
    private boolean continueThread;

    public long getCacheCheckFrequency() {
        return this.cacheCheckFrequency;
    }

    public CachedObject getObject(String id) throws ObjectExpiredException {
        RefreshableCachedObject rco;
        CachedObject obj = null;
        obj = (CachedObject)this.cache.get(id);
        if (obj == null) {
            throw new ObjectExpiredException();
        }
        if (obj.isStale()) {
            if (obj instanceof RefreshableCachedObject) {
                rco = (RefreshableCachedObject)obj;
                if (rco.isUntouched()) {
                    throw new ObjectExpiredException();
                }
                rco.refresh();
                if (rco.isStale()) {
                    throw new ObjectExpiredException();
                }
            } else {
                throw new ObjectExpiredException();
            }
        }
        if (obj instanceof RefreshableCachedObject) {
            rco = (RefreshableCachedObject)obj;
            rco.touch();
        }
        return obj;
    }

    public void addObject(String id, CachedObject o) {
        if (this.cache.containsKey(id)) {
            this.cache.remove(id);
        }
        this.cache.put(id, o);
    }

    public void removeObject(String id) {
        this.cache.remove(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getKeys() {
        ArrayList<String> keys = new ArrayList<String>(this.cache.size());
        DefaultGlobalCacheService defaultGlobalCacheService = this;
        synchronized (defaultGlobalCacheService) {
            Iterator itr = this.cache.keySet().iterator();
            while (itr.hasNext()) {
                String key = (String)itr.next();
                try {
                    this.getObject(key);
                }
                catch (ObjectExpiredException oee) {
                    continue;
                }
                keys.add(new String(key));
            }
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getCachedObjects() {
        ArrayList<CachedObject> objects = new ArrayList<CachedObject>(this.cache.size());
        DefaultGlobalCacheService defaultGlobalCacheService = this;
        synchronized (defaultGlobalCacheService) {
            Iterator itr = this.cache.keySet().iterator();
            while (itr.hasNext()) {
                String key = (String)itr.next();
                CachedObject obj = null;
                try {
                    obj = this.getObject(key);
                }
                catch (ObjectExpiredException oee) {
                    continue;
                }
                objects.add(obj);
            }
        }
        return objects;
    }

    public void run() {
        while (this.continueThread) {
            block3: {
                try {
                    Thread.sleep(this.cacheCheckFrequency);
                }
                catch (InterruptedException exc) {
                    if (this.continueThread) break block3;
                    return;
                }
            }
            this.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        ArrayList<String> refreshThese = new ArrayList<String>(20);
        DefaultGlobalCacheService defaultGlobalCacheService = this;
        synchronized (defaultGlobalCacheService) {
            Enumeration e = this.cache.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                CachedObject co = (CachedObject)this.cache.get(key);
                if (co instanceof RefreshableCachedObject) {
                    RefreshableCachedObject rco = (RefreshableCachedObject)co;
                    if (rco.isUntouched()) {
                        this.cache.remove(key);
                        continue;
                    }
                    if (!rco.isStale()) continue;
                    refreshThese.add(key);
                    continue;
                }
                if (!co.isStale()) continue;
                this.cache.remove(key);
            }
        }
        Iterator i = refreshThese.iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            CachedObject co = (CachedObject)this.cache.get(key);
            RefreshableCachedObject rco = (RefreshableCachedObject)co;
            rco.refresh();
        }
    }

    public int getNumberOfObjects() {
        return this.cache.size();
    }

    public int getCacheSize() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(this.cache);
        out.flush();
        int objectsize = baos.toByteArray().length - 4;
        return objectsize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushCache() {
        DefaultGlobalCacheService defaultGlobalCacheService = this;
        synchronized (defaultGlobalCacheService) {
            Enumeration e = this.cache.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                this.cache.remove(key);
            }
        }
    }

    public void configure(Configuration conf) throws ConfigurationException {
        this.cacheCheckFrequency = conf.getAttributeAsLong(CACHE_CHECK_FREQUENCY, 5000L);
        this.cacheInitialSize = conf.getAttributeAsInteger(INITIAL_CACHE_SIZE, 20);
    }

    public void initialize() throws Exception {
        try {
            this.cache = new Hashtable(this.cacheInitialSize);
            this.continueThread = true;
            this.housekeeping = new Thread(this);
            this.housekeeping.setDaemon(true);
            this.housekeeping.start();
        }
        catch (Exception e) {
            throw new Exception("DefaultGlobalCacheService failed to initialize", e);
        }
    }

    public void dispose() {
        this.continueThread = false;
        this.housekeeping.interrupt();
    }

    protected String getName() {
        return "GlobalCacheService";
    }
}

