/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.xmlmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.fulcrum.intake.xmlmodel.AppData;
import org.apache.fulcrum.intake.xmlmodel.XmlField;
import org.xml.sax.Attributes;

public class XmlGroup
implements Serializable {
    private static final long serialVersionUID = 4771953823149519746L;
    private List fields = new ArrayList();
    private List mapToObjects = new ArrayList(2);
    private String defaultMapToObject;
    private AppData parent;
    private String groupName;
    private String key;
    private String poolCapacity;

    public void loadFromXML(Attributes attrib) {
        this.groupName = attrib.getValue("name");
        this.key = attrib.getValue("key");
        this.poolCapacity = attrib.getValue("pool-capacity");
        String objName = attrib.getValue("mapToObject");
        if (StringUtils.isNotEmpty((String)objName)) {
            this.defaultMapToObject = objName;
        }
    }

    public String getName() {
        return this.groupName;
    }

    public void setName(String newGroupName) {
        this.groupName = newGroupName;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String newKey) {
        this.key = newKey;
    }

    public String getPoolCapacity() {
        if (this.poolCapacity == null) {
            return "128";
        }
        return this.poolCapacity;
    }

    public XmlField addField(Attributes attrib) {
        XmlField field = new XmlField();
        field.loadFromXML(attrib);
        this.addField(field);
        return field;
    }

    public void addField(XmlField field) {
        field.setGroup(this);
        if (field.getMapToObject() != null) {
            boolean isNewObject = true;
            for (int i = 0; i < this.mapToObjects.size(); ++i) {
                if (!this.mapToObjects.get(i).equals(field.getMapToObject())) continue;
                isNewObject = false;
                break;
            }
            if (isNewObject) {
                this.mapToObjects.add(field.getMapToObject());
            }
        } else if (field.getMapToProperty() != null && !"".equals(field.getMapToProperty()) && this.defaultMapToObject != null) {
            field.setMapToObject(this.defaultMapToObject);
        }
        this.fields.add(field);
    }

    public List getFields() {
        return this.fields;
    }

    public int getNumFields() {
        return this.fields.size();
    }

    public XmlField getField(String name) {
        Iterator iter = this.fields.iterator();
        while (iter.hasNext()) {
            XmlField field = (XmlField)iter.next();
            String curName = field.getRawName();
            if (!curName.equals(name)) continue;
            return field;
        }
        return null;
    }

    public boolean containsField(XmlField field) {
        return this.fields.contains(field);
    }

    public boolean containsField(String name) {
        return this.getField(name) != null;
    }

    public List getMapToObjects() {
        return this.mapToObjects;
    }

    public void setAppData(AppData parent) {
        this.parent = parent;
        if (this.defaultMapToObject != null) {
            this.defaultMapToObject = parent.getBasePackage() + this.defaultMapToObject;
            this.mapToObjects.add(this.defaultMapToObject);
        }
    }

    public AppData getAppData() {
        return this.parent;
    }

    public String getVariable() {
        String firstChar = this.getName().substring(0, 1).toLowerCase();
        return firstChar + this.getName().substring(1);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("<group name=\"").append(this.getName());
        result.append(" key=\"" + this.key + "\"");
        result.append(">\n");
        if (this.fields != null) {
            Iterator iter = this.fields.iterator();
            while (iter.hasNext()) {
                result.append(iter.next());
            }
        }
        result.append("</group>\n");
        return result.toString();
    }
}

