/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.map;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.lang.StringUtils;
import org.apache.torque.TorqueException;
import org.apache.torque.map.TableMap;
import org.apache.torque.oid.IDBroker;
import org.apache.torque.oid.IdGenerator;

public class DatabaseMap
implements Serializable {
    public static final char STD_SEPARATOR_CHAR = '_';
    public static final char SCHEMA_SEPARATOR_CHAR = '.';
    public static final String INIT_CLASS_NAME_FORMAT = "org.apache.torque.linkage.{0}MapInit";
    protected static final String[] ERROR_MESSAGES_INIT = new String[]{"Invalid Torque OM setup for Database \"{0}\".\nDatabase Map initialization class, \"{1}\", could not be found in your classpath.", "Invalid Torque OM setup for Database \"{0}\".\nA class that the Database Map initialization class, \"{1}\", depends on could not be found.", "Invalid Torque OM setup for Database \"{0}\".\nSomething unexpected happened doing Class.forName(\"{1}\").  See the nested exception for details.", "Invalid Torque OM setup for Database \"{0}\".\nAn error occured invoking the init() method in class, \"{1}\""};
    private static final long serialVersionUID = 955251837095032274L;
    private static final int ID_GENERATORS_INITIAL_SIZE = 6;
    private String name;
    private Map tables;
    private TableMap idTable = null;
    private IDBroker idBroker = null;
    private HashMap idGenerators;
    private boolean isInitialized = false;

    public DatabaseMap() {
        this.tables = Collections.synchronizedMap(new ListOrderedMap());
        this.idGenerators = new HashMap(6);
    }

    public DatabaseMap(String name, int numberOfTables) {
        this.name = name;
        this.tables = Collections.synchronizedMap(new ListOrderedMap());
        this.idGenerators = new HashMap(6);
    }

    public DatabaseMap(String name) {
        this.name = name;
        this.tables = Collections.synchronizedMap(new ListOrderedMap());
        this.idGenerators = new HashMap(6);
    }

    public boolean containsTable(TableMap table) {
        return this.containsTable(table.getName());
    }

    public boolean containsTable(String name) {
        if (name.indexOf(46) > 0) {
            name = name.substring(0, name.indexOf(46));
        }
        return this.tables.containsKey(name);
    }

    public TableMap getIdTable() {
        return this.idTable;
    }

    public IDBroker getIDBroker() {
        return this.idBroker;
    }

    public String getName() {
        return this.name;
    }

    public TableMap getTable(String name) {
        return (TableMap)this.tables.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableMap[] getTables() {
        TableMap[] dbTables = new TableMap[this.tables.size()];
        Map map = this.tables;
        synchronized (map) {
            Iterator it = this.tables.values().iterator();
            int i = 0;
            while (it.hasNext()) {
                dbTables[i++] = (TableMap)it.next();
            }
        }
        return dbTables;
    }

    public void addTable(String tableName) {
        TableMap tmap = new TableMap(tableName, this);
        this.tables.put(tableName, tmap);
    }

    public void addTable(String tableName, int numberOfColumns) {
        TableMap tmap = new TableMap(tableName, numberOfColumns, this);
        this.tables.put(tableName, tmap);
    }

    public void addTable(TableMap map) {
        this.tables.put(map.getName(), map);
    }

    public void setIdTable(TableMap idTable) {
        this.idTable = idTable;
        this.addTable(idTable);
    }

    public void setIdTable(String tableName) {
        TableMap tmap = new TableMap(tableName, this);
        this.setIdTable(tmap);
    }

    public void addIdGenerator(String type, IdGenerator idGen) {
        this.idGenerators.put(type, idGen);
    }

    public IdGenerator getIdGenerator(String type) {
        return (IdGenerator)this.idGenerators.get(type);
    }

    public synchronized boolean startIdBroker() {
        if (this.idBroker == null) {
            this.setIdTable("ID_TABLE");
            TableMap tMap = this.getIdTable();
            tMap.addPrimaryKey("ID_TABLE_ID", new Integer(0));
            tMap.addColumn("TABLE_NAME", "");
            tMap.addColumn("NEXT_ID", new Integer(0));
            tMap.addColumn("QUANTITY", new Integer(0));
            this.idBroker = new IDBroker(this.idTable);
            this.addIdGenerator("idbroker", this.idBroker);
            return true;
        }
        return false;
    }

    public synchronized void initialize() throws TorqueException {
        if (this.isInitialized) {
            return;
        }
        String initClassName = MessageFormat.format(INIT_CLASS_NAME_FORMAT, this.javanameMethod(this.getName()));
        Class<?> initClass = null;
        try {
            initClass = Class.forName(initClassName);
        }
        catch (ClassNotFoundException e) {
            throw new TorqueException(MessageFormat.format(ERROR_MESSAGES_INIT[0], this.getName(), initClassName), e);
        }
        catch (LinkageError e) {
            throw new TorqueException(MessageFormat.format(ERROR_MESSAGES_INIT[1], this.getName(), initClassName), e);
        }
        catch (Throwable e) {
            throw new TorqueException(MessageFormat.format(ERROR_MESSAGES_INIT[2], this.getName(), initClassName), e);
        }
        try {
            Method initMethod = initClass.getMethod("init", null);
            initMethod.invoke(null, (Object[])null);
        }
        catch (Exception e) {
            throw new TorqueException(MessageFormat.format(ERROR_MESSAGES_INIT[3], this.getName(), initClassName), e);
        }
        this.isInitialized = true;
    }

    protected String javanameMethod(String schemaName) {
        String namePart;
        StringBuffer result = new StringBuffer();
        StringTokenizer tok = new StringTokenizer(schemaName, String.valueOf('_'));
        while (tok.hasMoreTokens()) {
            namePart = (String)tok.nextElement();
            result.append(StringUtils.capitalize((String)namePart));
        }
        schemaName = result.toString();
        result = new StringBuffer();
        tok = new StringTokenizer(schemaName, String.valueOf('.'));
        while (tok.hasMoreTokens()) {
            namePart = (String)tok.nextElement();
            result.append(StringUtils.capitalize((String)namePart));
        }
        return result.toString();
    }
}

