/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.intake.model;

import org.apache.turbine.services.intake.IntakeException;
import org.apache.turbine.services.intake.model.Field;
import org.apache.turbine.services.intake.model.Group;
import org.apache.turbine.services.intake.validator.ShortValidator;
import org.apache.turbine.services.intake.xmlmodel.XmlField;

public class ShortField
extends Field {
    public ShortField(XmlField field, Group group) throws IntakeException {
        super(field, group);
    }

    public void setDefaultValue(String prop) {
        this.defaultValue = null;
        if (prop == null) {
            return;
        }
        this.defaultValue = new Short(prop);
    }

    public void setEmptyValue(String prop) {
        this.emptyValue = null;
        if (prop == null) {
            return;
        }
        this.emptyValue = new Short(prop);
    }

    protected Object getSafeEmptyValue() {
        if (this.isMultiValued) {
            return new short[0];
        }
        return null == this.getEmptyValue() ? new Short(0) : this.getEmptyValue();
    }

    protected String getDefaultValidator() {
        return ShortValidator.class.getName();
    }

    protected void doSetValue() {
        if (this.isMultiValued) {
            Integer[] inputs = this.parser.getIntObjects(this.getKey());
            short[] values = new short[inputs.length];
            for (int i = 0; i < inputs.length; ++i) {
                values[i] = inputs[i] == null ? ((Short)this.getEmptyValue()).shortValue() : inputs[i].shortValue();
            }
            this.setTestValue(values);
        } else {
            Integer value = this.parser.getIntObject(this.getKey());
            if (value == null) {
                this.setTestValue((Short)this.getEmptyValue());
            } else {
                this.setTestValue(new Short(value.shortValue()));
            }
        }
    }
}

