/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.adapter.DB;
import org.apache.torque.map.ColumnMap;
import org.apache.torque.map.DatabaseMap;
import org.apache.torque.util.Criteria;
import org.apache.torque.util.JoinBuilder;
import org.apache.torque.util.Query;
import org.apache.torque.util.SqlEnum;
import org.apache.torque.util.UniqueList;

public final class SQLBuilder {
    protected static final Log log = LogFactory.getLog((Class)(class$org$apache$torque$util$SQLBuilder == null ? (class$org$apache$torque$util$SQLBuilder = SQLBuilder.class$("org.apache.torque.util.SQLBuilder")) : class$org$apache$torque$util$SQLBuilder));
    public static final String[] COLUMN_CHARS = new String[]{".", "*"};
    public static final String[] DELIMITERS = new String[]{" ", ",", "(", ")", "<", ">"};
    static /* synthetic */ Class class$org$apache$torque$util$SQLBuilder;

    private SQLBuilder() {
    }

    public static String getFullTableName(String table, String dbName) throws TorqueException {
        String targetDBName;
        String targetSchema;
        int dotIndex;
        if (table != null && (dotIndex = table.indexOf(".")) == -1 && StringUtils.isNotEmpty((String)(targetSchema = Torque.getSchema(targetDBName = dbName == null ? Torque.getDefaultDB() : dbName)))) {
            return targetSchema + "." + table;
        }
        return table;
    }

    public static String getUnqualifiedTableName(String table) {
        if (table != null) {
            int dotIndex = table.lastIndexOf(".");
            if (++dotIndex > 0) {
                return table.substring(dotIndex);
            }
        }
        return table;
    }

    private static String removeSQLFunction(String name) throws TorqueException {
        if (StringUtils.isEmpty((String)name)) {
            return name;
        }
        int dotIndex = name.indexOf(46);
        if (dotIndex == -1) {
            dotIndex = name.indexOf("*");
        }
        if (dotIndex == -1) {
            throw new TorqueException("removeSQLFunction() : Column name " + name + " does not contain a . or a *");
        }
        String pre = name.substring(0, dotIndex);
        String post = name.substring(dotIndex + 1, name.length());
        int startIndex = StringUtils.lastIndexOfAny((String)pre, (String[])DELIMITERS);
        int endIndex = StringUtils.indexOfAny((String)post, (String[])DELIMITERS);
        if (startIndex < 0 && endIndex < 0) {
            return name;
        }
        if (endIndex < 0) {
            endIndex = post.length();
        }
        return name.substring(startIndex + 1, dotIndex + 1 + endIndex);
    }

    public static String getTableName(String name, String dbName) throws TorqueException {
        int rightDotIndex;
        String testName = SQLBuilder.removeSQLFunction(name);
        if (StringUtils.isEmpty((String)testName)) {
            SQLBuilder.throwMalformedColumnNameException("getTableName", name);
        }
        if ((rightDotIndex = testName.lastIndexOf(46)) < 0) {
            if ("*".equals(testName)) {
                return null;
            }
            SQLBuilder.throwMalformedColumnNameException("getTableName", name);
        }
        return SQLBuilder.getFullTableName(testName.substring(0, rightDotIndex), dbName);
    }

    public static Set getTableSet(Criteria crit, TableCallback tableCallback) {
        HashSet<String> tables = new HashSet<String>();
        Iterator it = crit.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            Criteria.Criterion c = crit.getCriterion(key);
            List tableNames = c.getAllTables();
            Iterator it2 = tableNames.iterator();
            while (it2.hasNext()) {
                String name = (String)it2.next();
                String aliasName = crit.getTableForAlias(name);
                if (StringUtils.isNotEmpty((String)aliasName)) {
                    String newName;
                    name = newName = new StringBuffer(name.length() + aliasName.length() + 4).append(aliasName).append(" AS ").append(name).toString();
                }
                tables.add(name);
            }
            if (tableCallback == null) continue;
            tableCallback.process(tables, key, crit);
        }
        return tables;
    }

    public static Query buildQueryClause(Criteria crit, List params, QueryCallback qc) throws TorqueException {
        Query query = new Query();
        String dbName = crit.getDbName();
        DB db = Torque.getDB(dbName);
        DatabaseMap dbMap = Torque.getDatabaseMap(dbName);
        JoinBuilder.processJoins(db, dbMap, crit, query);
        SQLBuilder.processModifiers(crit, query);
        SQLBuilder.processSelectColumns(crit, query, dbName);
        SQLBuilder.processAsColumns(crit, query);
        SQLBuilder.processCriterions(db, dbMap, dbName, crit, query, params, qc);
        SQLBuilder.processGroupBy(crit, query);
        SQLBuilder.processHaving(crit, query);
        SQLBuilder.processOrderBy(db, dbMap, crit, query);
        SQLBuilder.processLimits(crit, query);
        if (log.isDebugEnabled()) {
            log.debug((Object)query.toString());
        }
        return query;
    }

    private static void processSelectColumns(Criteria criteria, Query query, String dbName) throws TorqueException {
        UniqueList selectClause = query.getSelectClause();
        UniqueList select = criteria.getSelectColumns();
        for (int i = 0; i < select.size(); ++i) {
            String identifier = (String)select.get(i);
            selectClause.add(identifier);
            SQLBuilder.addTableToFromClause(SQLBuilder.getTableName(identifier, dbName), criteria, query);
        }
    }

    private static void processAsColumns(Criteria criteria, Query query) {
        UniqueList querySelectClause = query.getSelectClause();
        Map criteriaAsColumns = criteria.getAsColumns();
        Iterator it = criteriaAsColumns.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            querySelectClause.add(entry.getValue() + SqlEnum.AS + key);
        }
    }

    private static void processModifiers(Criteria criteria, Query query) {
        UniqueList selectModifiers = query.getSelectModifiers();
        UniqueList modifiers = criteria.getSelectModifiers();
        for (int i = 0; i < modifiers.size(); ++i) {
            selectModifiers.add(modifiers.get(i));
        }
    }

    private static void processCriterions(DB db, DatabaseMap dbMap, String dbName, Criteria crit, Query query, List params, QueryCallback qc) throws TorqueException {
        UniqueList whereClause = query.getWhereClause();
        Iterator it = crit.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            Criteria.Criterion criterion = crit.getCriterion(key);
            Criteria.Criterion[] someCriteria = criterion.getAttachedCriterion();
            String table = null;
            for (int i = 0; i < someCriteria.length; ++i) {
                String tableName = someCriteria[i].getTable();
                SQLBuilder.addTableToFromClause(SQLBuilder.getFullTableName(tableName, dbName), crit, query);
                table = crit.getTableForAlias(tableName);
                if (table == null) {
                    table = tableName;
                }
                boolean ignoreCase = (crit.isIgnoreCase() || someCriteria[i].isIgnoreCase()) && dbMap.getTable(table).getColumn(someCriteria[i].getColumn()).getType() instanceof String;
                someCriteria[i].setIgnoreCase(ignoreCase);
            }
            criterion.setDB(db);
            whereClause.add(qc.process(criterion, params));
        }
    }

    private static void processOrderBy(DB db, DatabaseMap dbMap, Criteria crit, Query query) throws TorqueException {
        UniqueList orderByClause = query.getOrderByClause();
        UniqueList selectClause = query.getSelectClause();
        UniqueList orderBy = crit.getOrderByColumns();
        if (orderBy != null && orderBy.size() > 0) {
            for (int i = 0; i < orderBy.size(); ++i) {
                int spacePos;
                String orderByColumn = (String)orderBy.get(i);
                String strippedColumnName = SQLBuilder.removeSQLFunction(orderByColumn);
                int dotPos = strippedColumnName.lastIndexOf(46);
                if (dotPos == -1) {
                    orderByClause.add(orderByColumn);
                    continue;
                }
                String tableName = strippedColumnName.substring(0, dotPos);
                String table = crit.getTableForAlias(tableName);
                if (table == null) {
                    table = tableName;
                }
                String columnName = (spacePos = strippedColumnName.indexOf(32)) == -1 ? strippedColumnName.substring(dotPos + 1) : strippedColumnName.substring(dotPos + 1, spacePos);
                ColumnMap column = dbMap.getTable(table).getColumn(columnName);
                if (column.getType() instanceof String && orderByColumn.indexOf(40) == -1) {
                    spacePos = orderByColumn.indexOf(32);
                    if (spacePos == -1) {
                        orderByClause.add(db.ignoreCaseInOrderBy(orderByColumn));
                    } else {
                        orderByClause.add(db.ignoreCaseInOrderBy(orderByColumn.substring(0, spacePos)) + orderByColumn.substring(spacePos));
                    }
                    selectClause.add(db.ignoreCaseInOrderBy(tableName + '.' + columnName));
                    continue;
                }
                orderByClause.add(orderByColumn);
            }
        }
    }

    private static void processGroupBy(Criteria crit, Query query) throws TorqueException {
        UniqueList groupByClause = query.getGroupByClause();
        UniqueList groupBy = crit.getGroupByColumns();
        if (groupBy != null) {
            for (int i = 0; i < groupBy.size(); ++i) {
                String columnName = (String)groupBy.get(i);
                String column = (String)crit.getAsColumns().get(columnName);
                if (column == null) {
                    column = columnName;
                }
                if (column.indexOf(46) != -1) {
                    groupByClause.add(column);
                    continue;
                }
                SQLBuilder.throwMalformedColumnNameException("group by", column);
            }
        }
    }

    private static void processHaving(Criteria crit, Query query) throws TorqueException {
        Criteria.Criterion having = crit.getHaving();
        if (having != null) {
            query.setHaving(having.toString());
        }
    }

    private static void processLimits(Criteria crit, Query query) throws TorqueException {
        int limit = crit.getLimit();
        int offset = crit.getOffset();
        if (offset > 0 || limit >= 0) {
            DB db = Torque.getDB(crit.getDbName());
            db.generateLimits(query, offset, limit);
        }
    }

    public static void throwMalformedColumnNameException(String criteriaPhrase, String columnName) throws TorqueException {
        StringBuffer sb = new StringBuffer().append("Malformed column name in Criteria ").append(criteriaPhrase).append(": '").append(StringUtils.isEmpty((String)columnName) ? "<empty>" : columnName).append("' is not of the form 'table.column'");
        throw new TorqueException(sb.toString());
    }

    public static String getTableNameForFromClause(String tableName, Criteria criteria) {
        String shortTableName = SQLBuilder.getUnqualifiedTableName(tableName);
        String aliasName = criteria.getTableForAlias(shortTableName);
        if (StringUtils.isEmpty((String)aliasName)) {
            aliasName = criteria.getTableForAlias(tableName);
        }
        if (StringUtils.isNotEmpty((String)aliasName)) {
            return new StringBuffer(tableName.length() + aliasName.length() + 1).append(aliasName).append(" ").append(tableName).toString();
        }
        return tableName;
    }

    public static boolean fromClauseContainsTableName(UniqueList fromClause, String tableName) {
        if (tableName == null) {
            return true;
        }
        Iterator it = fromClause.iterator();
        while (it.hasNext()) {
            Query.FromElement fromElement = (Query.FromElement)it.next();
            if (!tableName.equals(fromElement.getTableName())) continue;
            return true;
        }
        return false;
    }

    private static String addTableToFromClause(String tableName, Criteria criteria, Query query) {
        String tableNameForFromClause = SQLBuilder.getTableNameForFromClause(tableName, criteria);
        UniqueList queryFromClause = query.getFromClause();
        if (!SQLBuilder.fromClauseContainsTableName(queryFromClause, tableNameForFromClause)) {
            Query.FromElement fromElement = new Query.FromElement(tableNameForFromClause, null, null);
            queryFromClause.add(fromElement);
        }
        return tableNameForFromClause;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface QueryCallback {
        public String process(Criteria.Criterion var1, List var2);
    }

    public static interface TableCallback {
        public void process(Set var1, String var2, Criteria var3);
    }
}

