/*
 * Decompiled with CFR 0.152.
 */
package test.ojb.broker;

import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import ojb.broker.Identity;
import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.PersistenceBrokerFactory;
import ojb.broker.cache.ObjectCacheFactory;
import ojb.broker.query.Criteria;
import ojb.broker.query.Query;
import ojb.broker.query.QueryFactory;
import ojb.broker.util.ObjectModificationDefaultImpl;
import org.xml.sax.SAXException;
import test.ojb.broker.A;
import test.ojb.broker.AB;
import test.ojb.broker.Article;
import test.ojb.broker.ArticlePrimaryKey;
import test.ojb.broker.ArticleWithStockDetail;
import test.ojb.broker.B;
import test.ojb.broker.InterfaceArticle;
import test.ojb.broker.ProductGroup;
import test.ojb.broker.StockDetail;

public class PersistenceBrokerTest
extends TestCase {
    PersistenceBroker broker;
    int testId = 12345;
    private static Class CLASS = class$test$ojb$broker$PersistenceBrokerTest == null ? (class$test$ojb$broker$PersistenceBrokerTest = PersistenceBrokerTest.class$("test.ojb.broker.PersistenceBrokerTest")) : class$test$ojb$broker$PersistenceBrokerTest;
    static /* synthetic */ Class class$test$ojb$broker$PersistenceBrokerTest;
    static /* synthetic */ Class class$test$ojb$broker$AB;
    static /* synthetic */ Class class$test$ojb$broker$A;
    static /* synthetic */ Class class$test$ojb$broker$B;
    static /* synthetic */ Class class$test$ojb$broker$ArticleWithStockDetail;
    static /* synthetic */ Class class$test$ojb$broker$Article;
    static /* synthetic */ Class class$test$ojb$broker$ArticlePrimaryKey;

    public PersistenceBrokerTest(String name) {
        super(name);
    }

    protected Article createArticle(int id) {
        Article a = new Article();
        a.setArticleId(id);
        a.setArticleName("New Funny Article " + id);
        a.setIsSelloutArticle(true);
        a.setMinimumStock(100);
        a.setOrderedUnits(17);
        a.setPrice(0.45);
        a.setProductGroupId(1);
        a.setStock(234);
        a.setSupplierId(4);
        a.setUnit("bottle");
        return a;
    }

    protected void deleteArticle(int id) throws PersistenceBrokerException {
        Article a = new Article();
        a.setArticleId(id);
        this.broker.delete(a);
    }

    protected void deleteArticle(Article articleToDelete) throws PersistenceBrokerException {
        this.broker.delete(articleToDelete);
    }

    public static void main(String[] args) {
        String[] arr = new String[]{CLASS.getName()};
        TestRunner.main((String[])arr);
    }

    protected Article readArticleByExample(int id) throws PersistenceBrokerException {
        Article example = new Article();
        example.setArticleId(id);
        return (Article)this.broker.getObjectByQuery(QueryFactory.newQuery(example));
    }

    protected Article readArticleByIdentity(int id) throws PersistenceBrokerException {
        Article a = new Article();
        a.setArticleId(id);
        Identity oid = new Identity(a);
        return (Article)this.broker.getObjectByIdentity(oid);
    }

    public void setUp() {
        try {
            this.broker = PersistenceBrokerFactory.createPersistenceBroker("repository.xml");
        }
        catch (IOException e) {
        }
        catch (ParserConfigurationException e) {
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    protected void storeArticle(Article anArticle) throws PersistenceBrokerException {
        this.broker.store(anArticle);
    }

    public void tearDown() {
        try {
            Article a = this.createArticle(this.testId);
            this.deleteArticle(a);
            ObjectCacheFactory.getObjectCache().clear();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void testDelete() {
        try {
            Article a = this.createArticle(this.testId);
            this.storeArticle(a);
            Article b = this.readArticleByIdentity(this.testId);
            Assert.assertEquals((String)"after inserting an object it should be equal to its re-read pendant", (Object)a.getArticleName(), (Object)b.getArticleName());
            this.deleteArticle(b);
            b = this.readArticleByIdentity(this.testId);
            Assert.assertNull((String)"should be null after deletion", (Object)b);
            b = this.readArticleByExample(this.testId);
            Assert.assertNull((String)"should be null after deletion", (Object)b);
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    public void testMappingToOneTable() {
        try {
            A a1 = new A();
            B b1 = new B();
            this.broker.store(a1);
            this.broker.store(b1);
            Criteria crit = new Criteria();
            crit.addEqualTo("id", new Integer(a1.id));
            Query q = QueryFactory.newQuery(class$test$ojb$broker$AB == null ? (class$test$ojb$broker$AB = PersistenceBrokerTest.class$("test.ojb.broker.AB")) : class$test$ojb$broker$AB, crit);
            AB a2 = (AB)this.broker.getObjectByQuery(q);
            Assert.assertEquals((Object)(class$test$ojb$broker$A == null ? (class$test$ojb$broker$A = PersistenceBrokerTest.class$("test.ojb.broker.A")) : class$test$ojb$broker$A).getName(), (Object)a2.getConcreteClass());
            Assert.assertEquals((Object)(class$test$ojb$broker$A == null ? (class$test$ojb$broker$A = PersistenceBrokerTest.class$("test.ojb.broker.A")) : class$test$ojb$broker$A), a2.getClass());
            crit = new Criteria();
            crit.addEqualTo("id", new Integer(b1.id));
            q = QueryFactory.newQuery(class$test$ojb$broker$AB == null ? (class$test$ojb$broker$AB = PersistenceBrokerTest.class$("test.ojb.broker.AB")) : class$test$ojb$broker$AB, crit);
            AB b2 = (AB)this.broker.getObjectByQuery(q);
            Assert.assertEquals((Object)(class$test$ojb$broker$B == null ? (class$test$ojb$broker$B = PersistenceBrokerTest.class$("test.ojb.broker.B")) : class$test$ojb$broker$B).getName(), (Object)b2.getConcreteClass());
            Assert.assertEquals((Object)(class$test$ojb$broker$B == null ? (class$test$ojb$broker$B = PersistenceBrokerTest.class$("test.ojb.broker.B")) : class$test$ojb$broker$B), b2.getClass());
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    public void testRowReader() {
        try {
            Article a = this.createArticle(this.testId);
            this.storeArticle(a);
            Criteria crit = new Criteria();
            crit.addEqualTo("articleId", new Integer(this.testId));
            Query q = QueryFactory.newQuery(class$test$ojb$broker$ArticleWithStockDetail == null ? (class$test$ojb$broker$ArticleWithStockDetail = PersistenceBrokerTest.class$("test.ojb.broker.ArticleWithStockDetail")) : class$test$ojb$broker$ArticleWithStockDetail, crit);
            ArticleWithStockDetail b = (ArticleWithStockDetail)this.broker.getObjectByQuery(q);
            StockDetail detail = b.getDetail();
            Assert.assertNotNull((String)"detail should be loaded by RowReader !", (Object)detail);
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    public void testEscaping() {
        try {
            Article a = this.createArticle(this.testId);
            this.deleteArticle(a);
            Article b = this.readArticleByIdentity(this.testId);
            Assert.assertNull((String)"should be null after deletion", (Object)b);
            a.setArticleName("Single quote 'article ");
            this.storeArticle(a);
            ObjectCacheFactory.getObjectCache().clear();
            b = this.readArticleByIdentity(this.testId);
            Assert.assertEquals((String)"after inserting an object it should be equal to its re-read pendant", (Object)a.getArticleName(), (Object)b.getArticleName());
            String name = a.getArticleName();
            Criteria criteria = new Criteria();
            criteria.addEqualTo("articleName", name);
            Query query = QueryFactory.newQuery(class$test$ojb$broker$Article == null ? (class$test$ojb$broker$Article = PersistenceBrokerTest.class$("test.ojb.broker.Article")) : class$test$ojb$broker$Article, criteria);
            Collection col = this.broker.getCollectionByQuery(query);
            Iterator iter = col.iterator();
            Assert.assertTrue((String)"should have one element", (boolean)iter.hasNext());
            Assert.assertEquals((String)"should be equal", (Object)name, (Object)((InterfaceArticle)iter.next()).getArticleName());
            a.setArticleName("2 Single quotes 'article' ");
            this.storeArticle(a);
            ObjectCacheFactory.getObjectCache().clear();
            b = this.readArticleByIdentity(this.testId);
            Assert.assertEquals((String)"after inserting an object it should be equal to its re-read pendant", (Object)a.getArticleName(), (Object)b.getArticleName());
            name = a.getArticleName();
            criteria = new Criteria();
            criteria.addEqualTo("articleName", name);
            query = QueryFactory.newQuery(class$test$ojb$broker$Article == null ? (class$test$ojb$broker$Article = PersistenceBrokerTest.class$("test.ojb.broker.Article")) : class$test$ojb$broker$Article, criteria);
            col = this.broker.getCollectionByQuery(query);
            iter = col.iterator();
            Assert.assertTrue((String)"should have one element", (boolean)iter.hasNext());
            Assert.assertEquals((String)"should be equal", (Object)name, (Object)((InterfaceArticle)iter.next()).getArticleName());
            a.setArticleName("double quote \"article ");
            this.storeArticle(a);
            ObjectCacheFactory.getObjectCache().clear();
            b = this.readArticleByIdentity(this.testId);
            Assert.assertEquals((String)"after inserting an object it should be equal to its re-read pendant", (Object)a.getArticleName(), (Object)b.getArticleName());
            name = a.getArticleName();
            criteria = new Criteria();
            criteria.addEqualTo("articleName", name);
            query = QueryFactory.newQuery(class$test$ojb$broker$Article == null ? (class$test$ojb$broker$Article = PersistenceBrokerTest.class$("test.ojb.broker.Article")) : class$test$ojb$broker$Article, criteria);
            col = this.broker.getCollectionByQuery(query);
            iter = col.iterator();
            Assert.assertTrue((String)"should have one element", (boolean)iter.hasNext());
            Assert.assertEquals((String)"should be equal", (Object)name, (Object)((InterfaceArticle)iter.next()).getArticleName());
            a.setArticleName("2 double quotes \"article\" ");
            this.storeArticle(a);
            ObjectCacheFactory.getObjectCache().clear();
            b = this.readArticleByIdentity(this.testId);
            Assert.assertEquals((String)"after inserting an object it should be equal to its re-read pendant", (Object)a.getArticleName(), (Object)b.getArticleName());
            name = a.getArticleName();
            criteria = new Criteria();
            criteria.addEqualTo("articleName", name);
            query = QueryFactory.newQuery(class$test$ojb$broker$Article == null ? (class$test$ojb$broker$Article = PersistenceBrokerTest.class$("test.ojb.broker.Article")) : class$test$ojb$broker$Article, criteria);
            col = this.broker.getCollectionByQuery(query);
            iter = col.iterator();
            Assert.assertTrue((String)"should have one element", (boolean)iter.hasNext());
            Assert.assertEquals((String)"should be equal", (Object)name, (Object)((InterfaceArticle)iter.next()).getArticleName());
            a.setArticleName("a comma thing ,article, ");
            this.storeArticle(a);
            ObjectCacheFactory.getObjectCache().clear();
            b = this.readArticleByIdentity(this.testId);
            Assert.assertEquals((String)"after inserting an object it should be equal to its re-read pendant", (Object)a.getArticleName(), (Object)b.getArticleName());
            name = a.getArticleName();
            criteria = new Criteria();
            criteria.addEqualTo("articleName", name);
            query = QueryFactory.newQuery(class$test$ojb$broker$Article == null ? (class$test$ojb$broker$Article = PersistenceBrokerTest.class$("test.ojb.broker.Article")) : class$test$ojb$broker$Article, criteria);
            col = this.broker.getCollectionByQuery(query);
            iter = col.iterator();
            Assert.assertTrue((String)"should have one element", (boolean)iter.hasNext());
            Assert.assertEquals((String)"should be equal", (Object)name, (Object)((InterfaceArticle)iter.next()).getArticleName());
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    public void testGetByExampleAndGetByIdentity() {
        try {
            Article a = this.createArticle(this.testId);
            this.storeArticle(a);
            Article b = this.readArticleByIdentity(this.testId);
            Assert.assertEquals((String)"after inserting an object it should be equal to its re-read pendant", (Object)a.getArticleName(), (Object)b.getArticleName());
            Article c = this.readArticleByExample(this.testId);
            Assert.assertEquals((String)"after inserting an object it should be equal to its re-read pendant", (Object)a.getArticleName(), (Object)c.getArticleName());
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    public void testGetCollectionByQuery() {
        try {
            String name = "CollectionTestArticle";
            Criteria criteria = new Criteria();
            criteria.addEqualTo("articleName", name);
            Query query = QueryFactory.newQuery(class$test$ojb$broker$Article == null ? (class$test$ojb$broker$Article = PersistenceBrokerTest.class$("test.ojb.broker.Article")) : class$test$ojb$broker$Article, criteria);
            Collection col = this.broker.getCollectionByQuery(query);
            Iterator iter = col.iterator();
            while (iter.hasNext()) {
                this.broker.delete(iter.next());
            }
            col = this.broker.getCollectionByQuery(query);
            Assert.assertEquals((String)"size of collection should be zero", (int)0, (int)col.size());
            int id1 = 4001;
            int id2 = 4002;
            int id3 = 4003;
            Article a1 = this.createArticle(id1);
            a1.setArticleName(name);
            this.broker.store(a1);
            Article a2 = this.createArticle(id2);
            a2.setArticleName(name);
            this.broker.store(a2);
            Article a3 = this.createArticle(id3);
            a3.setArticleName(name);
            this.broker.store(a3);
            col = this.broker.getCollectionByQuery(query);
            Assert.assertEquals((String)"size of collection should be three", (int)3, (int)col.size());
            iter = col.iterator();
            while (iter.hasNext()) {
                Assert.assertEquals((String)"should be same value", (Object)name, (Object)((InterfaceArticle)iter.next()).getArticleName());
            }
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    public void testSorting() {
        try {
            String name = "SortingTestArticle";
            Criteria criteria = new Criteria();
            criteria.addEqualTo("articleName", name);
            criteria.orderBy("articleId", false);
            Query query = QueryFactory.newQuery(class$test$ojb$broker$Article == null ? (class$test$ojb$broker$Article = PersistenceBrokerTest.class$("test.ojb.broker.Article")) : class$test$ojb$broker$Article, criteria);
            Collection col = this.broker.getCollectionByQuery(query);
            Iterator iter = col.iterator();
            while (iter.hasNext()) {
                this.broker.delete(iter.next());
            }
            col = this.broker.getCollectionByQuery(query);
            Assert.assertEquals((String)"size of collection should be zero", (int)0, (int)col.size());
            int id1 = 4001;
            int id2 = 4002;
            int id3 = 4003;
            Article a1 = this.createArticle(id1);
            a1.setArticleName(name);
            this.broker.store(a1);
            Article a2 = this.createArticle(id2);
            a2.setArticleName(name);
            this.broker.store(a2);
            Article a3 = this.createArticle(id3);
            a3.setArticleName(name);
            this.broker.store(a3);
            col = this.broker.getCollectionByQuery(query);
            Assert.assertEquals((String)"size of collection should be three", (int)3, (int)col.size());
            iter = col.iterator();
            Assert.assertEquals((String)"should be same value", (int)id3, (int)((InterfaceArticle)iter.next()).getArticleId());
            Assert.assertEquals((String)"should be same value", (int)id2, (int)((InterfaceArticle)iter.next()).getArticleId());
            Assert.assertEquals((String)"should be same value", (int)id1, (int)((InterfaceArticle)iter.next()).getArticleId());
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    public void testAutoIncrement() {
        try {
            ProductGroup pg1 = new ProductGroup();
            ProductGroup pg2 = new ProductGroup();
            pg1.setName("AutoIncGroup1");
            pg2.setName("AutoIncGroup2");
            this.broker.store(pg1);
            this.broker.store(pg2);
            Assert.assertEquals((String)"should have assigned to Integers with diff 1", (int)1, (int)(pg2.getId() - pg1.getId()));
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    public void testGetIteratorByQuery() {
        try {
            String name = "CollectionTestArticle";
            Criteria criteria = new Criteria();
            criteria.addEqualTo("articleName", name);
            Query query = QueryFactory.newQuery(class$test$ojb$broker$Article == null ? (class$test$ojb$broker$Article = PersistenceBrokerTest.class$("test.ojb.broker.Article")) : class$test$ojb$broker$Article, criteria);
            Iterator iter = this.broker.getIteratorByQuery(query);
            while (iter.hasNext()) {
                this.broker.delete(iter.next());
            }
            iter = this.broker.getIteratorByQuery(query);
            Assert.assertTrue((String)"size of collection should be zero", (!iter.hasNext() ? 1 : 0) != 0);
            int id1 = 4001;
            int id2 = 4002;
            int id3 = 4003;
            Article a1 = this.createArticle(id1);
            a1.setArticleName(name);
            this.broker.store(a1);
            Article a2 = this.createArticle(id2);
            a2.setArticleName(name);
            this.broker.store(a2);
            Article a3 = this.createArticle(id3);
            a3.setArticleName(name);
            this.broker.store(a3);
            iter = this.broker.getIteratorByQuery(query);
            int count = 0;
            while (iter.hasNext()) {
                ++count;
                Assert.assertEquals((String)"should be same value", (Object)name, (Object)((InterfaceArticle)iter.next()).getArticleName());
            }
            Assert.assertEquals((String)"Iterator should produce 3 items", (int)3, (int)count);
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    public void testGetMultipleIteratorsByQuery() {
        try {
            String name = "CollectionTestArticle";
            Criteria criteria = new Criteria();
            criteria.addEqualTo("articleName", name);
            Query query = QueryFactory.newQuery(class$test$ojb$broker$Article == null ? (class$test$ojb$broker$Article = PersistenceBrokerTest.class$("test.ojb.broker.Article")) : class$test$ojb$broker$Article, criteria);
            Iterator iter = this.broker.getIteratorByQuery(query);
            while (iter.hasNext()) {
                this.broker.delete(iter.next());
            }
            iter = this.broker.getIteratorByQuery(query);
            Assert.assertTrue((String)"size of collection should be zero", (!iter.hasNext() ? 1 : 0) != 0);
            int id1 = 4001;
            int id2 = 4002;
            int id3 = 4003;
            Article a1 = this.createArticle(id1);
            a1.setArticleName(name);
            this.broker.store(a1);
            Article a2 = this.createArticle(id2);
            a2.setArticleName(name);
            this.broker.store(a2);
            Article a3 = this.createArticle(id3);
            a3.setArticleName(name);
            this.broker.store(a3);
            Iterator i1 = this.broker.getIteratorByQuery(query);
            Iterator i2 = this.broker.getIteratorByQuery(query);
            Iterator i3 = this.broker.getIteratorByQuery(query);
            int i = 0;
            while (i < 3) {
                Assert.assertTrue((String)"should have more elements", (boolean)i3.hasNext());
                Assert.assertTrue((String)"should have more elements", (boolean)i1.hasNext());
                Assert.assertTrue((String)"should have more elements", (boolean)i2.hasNext());
                Assert.assertEquals((String)"should be same value", (Object)name, (Object)((InterfaceArticle)i2.next()).getArticleName());
                Assert.assertEquals((String)"should be same value", (Object)name, (Object)((InterfaceArticle)i1.next()).getArticleName());
                Assert.assertEquals((String)"should be same value", (Object)name, (Object)((InterfaceArticle)i3.next()).getArticleName());
                ++i;
            }
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    public void testGetObjectByQuery() {
        try {
            Article a = this.createArticle(this.testId);
            this.storeArticle(a);
            Query query = QueryFactory.newQuery(a);
            Article b = (Article)this.broker.getObjectByQuery(query);
            Assert.assertEquals((String)"after inserting an object it should be equal to its re-read pendant", (Object)a.getArticleName(), (Object)b.getArticleName());
            Article c = this.readArticleByExample(this.testId);
            Assert.assertEquals((String)"after inserting an object it should be equal to its re-read pendant", (Object)a.getArticleName(), (Object)c.getArticleName());
            Criteria crit = new Criteria();
            crit.addEqualTo("articleId", new Integer(a.getArticleId()));
            Query q = QueryFactory.newQuery(class$test$ojb$broker$Article == null ? (class$test$ojb$broker$Article = PersistenceBrokerTest.class$("test.ojb.broker.Article")) : class$test$ojb$broker$Article, crit);
            InterfaceArticle d = (InterfaceArticle)this.broker.getObjectByQuery(q);
            Assert.assertEquals((String)"after inserting an object it should be equal to its re-read pendant", (Object)a.getArticleName(), (Object)d.getArticleName());
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    public void testGetPKEnumerationByConstraints() {
        try {
            String name = "CollectionTestArticle";
            Criteria criteria = new Criteria();
            criteria.addEqualTo("articleName", name);
            Query query = QueryFactory.newQuery(class$test$ojb$broker$Article == null ? (class$test$ojb$broker$Article = PersistenceBrokerTest.class$("test.ojb.broker.Article")) : class$test$ojb$broker$Article, criteria);
            Enumeration enumeration = this.broker.getPKEnumerationByQuery(class$test$ojb$broker$ArticlePrimaryKey == null ? (class$test$ojb$broker$ArticlePrimaryKey = PersistenceBrokerTest.class$("test.ojb.broker.ArticlePrimaryKey")) : class$test$ojb$broker$ArticlePrimaryKey, query);
            while (enumeration.hasMoreElements()) {
                ArticlePrimaryKey pk = (ArticlePrimaryKey)enumeration.nextElement();
                this.deleteArticle(pk.id);
            }
            enumeration = this.broker.getPKEnumerationByQuery(class$test$ojb$broker$ArticlePrimaryKey == null ? (class$test$ojb$broker$ArticlePrimaryKey = PersistenceBrokerTest.class$("test.ojb.broker.ArticlePrimaryKey")) : class$test$ojb$broker$ArticlePrimaryKey, query);
            Assert.assertTrue((String)"size of collection should be zero", (!enumeration.hasMoreElements() ? 1 : 0) != 0);
            int id1 = 4001;
            int id2 = 4002;
            int id3 = 4003;
            Article a1 = this.createArticle(id1);
            a1.setArticleName(name);
            this.broker.store(a1);
            Article a2 = this.createArticle(id2);
            a2.setArticleName(name);
            this.broker.store(a2);
            Article a3 = this.createArticle(id3);
            a3.setArticleName(name);
            this.broker.store(a3);
            enumeration = this.broker.getPKEnumerationByQuery(class$test$ojb$broker$ArticlePrimaryKey == null ? (class$test$ojb$broker$ArticlePrimaryKey = PersistenceBrokerTest.class$("test.ojb.broker.ArticlePrimaryKey")) : class$test$ojb$broker$ArticlePrimaryKey, query);
            int count = 0;
            while (enumeration.hasMoreElements()) {
                ++count;
                Article tmp = this.readArticleByIdentity(((ArticlePrimaryKey)enumeration.nextElement()).id);
                Assert.assertEquals((String)"should be same value", (Object)name, (Object)tmp.getArticleName());
            }
            Assert.assertEquals((String)"Iterator should produce 3 items", (int)3, (int)count);
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    public void testInsert() {
        try {
            Article a = this.createArticle(this.testId);
            this.deleteArticle(a);
            Article b = this.readArticleByIdentity(this.testId);
            Assert.assertNull((String)"should be null after deletion", (Object)b);
            this.storeArticle(a);
            b = this.readArticleByIdentity(this.testId);
            Assert.assertEquals((String)"after inserting an object it should be equal to its re-read pendant", (Object)a.getArticleName(), (Object)b.getArticleName());
            b = null;
            ObjectCacheFactory.getObjectCache().clear();
            b = this.readArticleByIdentity(this.testId);
            Assert.assertEquals((String)"after inserting and flushing the cache an object should still be equal to its re-read pendant", (Object)a.getArticleName(), (Object)b.getArticleName());
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    public void testUpdate() {
        try {
            this.deleteArticle(this.testId);
            Article a = this.createArticle(this.testId);
            this.storeArticle(a);
            Article b = this.readArticleByIdentity(this.testId);
            Assert.assertEquals((String)"after inserting an object it should be equal to its re-read pendant", (Object)a.getArticleName(), (Object)b.getArticleName());
            String newname = "TESTUPDATE";
            b.setArticleName(newname);
            this.storeArticle(b);
            b = null;
            b = this.readArticleByIdentity(this.testId);
            Assert.assertEquals((String)"should be equal after update", (Object)newname, (Object)b.getArticleName());
            b = null;
            ObjectCacheFactory.getObjectCache().clear();
            b = this.readArticleByIdentity(this.testId);
            Assert.assertEquals((String)"should be equal after update and db lookup", (Object)newname, (Object)b.getArticleName());
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    public void testUpdateWithModification() {
        try {
            ObjectModificationDefaultImpl modification = new ObjectModificationDefaultImpl();
            Assert.assertTrue((String)"should not be marked for update yet", (!modification.needsUpdate() ? 1 : 0) != 0);
            Assert.assertTrue((String)"should not be marked for insert", (!modification.needsInsert() ? 1 : 0) != 0);
            Article a = this.createArticle(this.testId);
            this.storeArticle(a);
            Article b = this.readArticleByIdentity(this.testId);
            Assert.assertEquals((String)"after inserting an object it should be equal to its re-read pendant", (Object)a.getArticleName(), (Object)b.getArticleName());
            String newname = "TESTUPDATE";
            b.setArticleName(newname);
            modification.markModified();
            Assert.assertTrue((String)"should be marked for update", (boolean)modification.needsUpdate());
            Assert.assertTrue((String)"should not be marked for insert", (!modification.needsInsert() ? 1 : 0) != 0);
            this.broker.store(b, modification);
            b = null;
            b = this.readArticleByIdentity(this.testId);
            Assert.assertEquals((String)"should be equal after update", (Object)newname, (Object)b.getArticleName());
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

