/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.core.api.shared.lang;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class CollectionUtils {
    public static void forEach(Object value, Consumer<Object> callback) {
        if (value != null && value.getClass().isArray()) {
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                callback.accept(Array.get(value, i));
            }
        } else if (value instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)value;
            for (int i = 0; i < arrayList.size(); ++i) {
                callback.accept(arrayList.get(i));
            }
        } else if (value instanceof Iterable) {
            Iterator iterator = ((Iterable)value).iterator();
            while (iterator.hasNext()) {
                callback.accept(iterator.next());
            }
        } else if (value instanceof Map) {
            Map map = (Map)value;
            for (Map.Entry entry : map.entrySet()) {
                callback.accept(entry);
            }
        } else if (value instanceof Stream) {
            ((Stream)value).forEach(callback);
        } else {
            callback.accept(value);
        }
    }
}

