/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.AttributeMap;
import org.opensaml.core.xml.util.IndexedXMLObjectChildrenList;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.opensaml.saml.common.AbstractSignableSAMLObject;
import org.opensaml.saml.saml2.metadata.AdditionalMetadataLocation;
import org.opensaml.saml.saml2.metadata.AffiliationDescriptor;
import org.opensaml.saml.saml2.metadata.AttributeAuthorityDescriptor;
import org.opensaml.saml.saml2.metadata.AuthnAuthorityDescriptor;
import org.opensaml.saml.saml2.metadata.ContactPerson;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.Organization;
import org.opensaml.saml.saml2.metadata.PDPDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.xmlsec.signature.Signature;

public class EntityDescriptorImpl
extends AbstractSignableSAMLObject
implements EntityDescriptor {
    @Nullable
    private String entityID;
    @Nullable
    private String id;
    @Nullable
    private Instant validUntil;
    @Nullable
    private Duration cacheDuration;
    @Nullable
    private Extensions extensions;
    @Nonnull
    private final IndexedXMLObjectChildrenList<RoleDescriptor> roleDescriptors = new IndexedXMLObjectChildrenList((XMLObject)this);
    @Nullable
    private AffiliationDescriptor affiliationDescriptor;
    @Nullable
    private Organization organization;
    @Nonnull
    private final XMLObjectChildrenList<ContactPerson> contactPersons = new XMLObjectChildrenList((XMLObject)this);
    @Nonnull
    private final XMLObjectChildrenList<AdditionalMetadataLocation> additionalMetadata = new XMLObjectChildrenList((XMLObject)this);
    @Nonnull
    private final AttributeMap unknownAttributes = new AttributeMap((XMLObject)this);

    protected EntityDescriptorImpl(@Nullable String namespaceURI, @Nonnull String elementLocalName, @Nullable String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    @Nullable
    public String getEntityID() {
        return this.entityID;
    }

    public void setEntityID(@Nullable String newId) {
        if (newId != null && newId.length() > 1024) {
            throw new IllegalArgumentException("Entity ID can not exceed 1024 characters in length");
        }
        this.entityID = this.prepareForAssignment(this.entityID, newId);
    }

    @Nullable
    public String getID() {
        return this.id;
    }

    public void setID(@Nullable String newID) {
        String oldID = this.id;
        this.id = this.prepareForAssignment(this.id, newID);
        this.registerOwnID(oldID, this.id);
    }

    public boolean isValid() {
        if (null == this.validUntil) {
            return true;
        }
        return Instant.now().isBefore(this.validUntil);
    }

    @Nullable
    public Instant getValidUntil() {
        return this.validUntil;
    }

    public void setValidUntil(@Nullable Instant newValidUntil) {
        this.validUntil = (Instant)this.prepareForAssignment(this.validUntil, newValidUntil);
    }

    @Nullable
    public Duration getCacheDuration() {
        return this.cacheDuration;
    }

    public void setCacheDuration(@Nullable Duration duration) {
        this.cacheDuration = (Duration)this.prepareForAssignment(this.cacheDuration, duration);
    }

    @Nullable
    public Extensions getExtensions() {
        return this.extensions;
    }

    public void setExtensions(@Nullable Extensions newExtensions) {
        this.extensions = (Extensions)this.prepareForAssignment((XMLObject)this.extensions, (XMLObject)newExtensions);
    }

    @Nonnull
    @Live
    public List<RoleDescriptor> getRoleDescriptors() {
        return this.roleDescriptors;
    }

    @Nonnull
    @Live
    public List<RoleDescriptor> getRoleDescriptors(@Nonnull QName typeOrName) {
        return this.roleDescriptors.subList(typeOrName);
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public List<RoleDescriptor> getRoleDescriptors(@Nonnull QName type, @Nonnull @NotEmpty String supportedProtocol) {
        ArrayList<RoleDescriptor> supportingRoleDescriptors = new ArrayList<RoleDescriptor>();
        for (RoleDescriptor descriptor : this.roleDescriptors.subList(type)) {
            if (!descriptor.isSupportedProtocol(supportedProtocol)) continue;
            supportingRoleDescriptors.add(descriptor);
        }
        return supportingRoleDescriptors;
    }

    @Nullable
    public IDPSSODescriptor getIDPSSODescriptor(@Nonnull @NotEmpty String supportedProtocol) {
        List<RoleDescriptor> descriptors = this.getRoleDescriptors(IDPSSODescriptor.DEFAULT_ELEMENT_NAME, supportedProtocol);
        if (descriptors.size() > 0) {
            return (IDPSSODescriptor)descriptors.get(0);
        }
        return null;
    }

    @Nullable
    public SPSSODescriptor getSPSSODescriptor(@Nonnull @NotEmpty String supportedProtocol) {
        List<RoleDescriptor> descriptors = this.getRoleDescriptors(SPSSODescriptor.DEFAULT_ELEMENT_NAME, supportedProtocol);
        if (descriptors.size() > 0) {
            return (SPSSODescriptor)descriptors.get(0);
        }
        return null;
    }

    @Nullable
    public AuthnAuthorityDescriptor getAuthnAuthorityDescriptor(@Nonnull @NotEmpty String supportedProtocol) {
        List<RoleDescriptor> descriptors = this.getRoleDescriptors(AuthnAuthorityDescriptor.DEFAULT_ELEMENT_NAME, supportedProtocol);
        if (descriptors.size() > 0) {
            return (AuthnAuthorityDescriptor)descriptors.get(0);
        }
        return null;
    }

    @Nullable
    public AttributeAuthorityDescriptor getAttributeAuthorityDescriptor(@Nonnull @NotEmpty String supportedProtocol) {
        List<RoleDescriptor> descriptors = this.getRoleDescriptors(AttributeAuthorityDescriptor.DEFAULT_ELEMENT_NAME, supportedProtocol);
        if (descriptors.size() > 0) {
            return (AttributeAuthorityDescriptor)descriptors.get(0);
        }
        return null;
    }

    @Nullable
    public PDPDescriptor getPDPDescriptor(@Nonnull @NotEmpty String supportedProtocol) {
        List<RoleDescriptor> descriptors = this.getRoleDescriptors(PDPDescriptor.DEFAULT_ELEMENT_NAME, supportedProtocol);
        if (descriptors.size() > 0) {
            return (PDPDescriptor)descriptors.get(0);
        }
        return null;
    }

    @Nullable
    public AffiliationDescriptor getAffiliationDescriptor() {
        return this.affiliationDescriptor;
    }

    public void setAffiliationDescriptor(@Nullable AffiliationDescriptor descriptor) {
        this.affiliationDescriptor = (AffiliationDescriptor)this.prepareForAssignment((XMLObject)this.affiliationDescriptor, (XMLObject)descriptor);
    }

    @Nullable
    public Organization getOrganization() {
        return this.organization;
    }

    public void setOrganization(@Nullable Organization newOrganization) {
        this.organization = (Organization)this.prepareForAssignment((XMLObject)this.organization, (XMLObject)newOrganization);
    }

    @Nonnull
    @Live
    public List<ContactPerson> getContactPersons() {
        return this.contactPersons;
    }

    @Nonnull
    @Live
    public List<AdditionalMetadataLocation> getAdditionalMetadataLocations() {
        return this.additionalMetadata;
    }

    @Nonnull
    public AttributeMap getUnknownAttributes() {
        return this.unknownAttributes;
    }

    @Nullable
    public String getSignatureReferenceID() {
        return this.id;
    }

    @Nullable
    @NotLive
    @Unmodifiable
    public List<XMLObject> getOrderedChildren() {
        ArrayList<Object> children = new ArrayList<Object>();
        Signature sig = this.getSignature();
        if (sig != null) {
            children.add(sig);
        }
        if (this.extensions != null) {
            children.add(this.extensions);
        }
        children.addAll((Collection<Object>)this.roleDescriptors);
        if (this.getAffiliationDescriptor() != null) {
            children.add(this.getAffiliationDescriptor());
        }
        if (this.getOrganization() != null) {
            children.add(this.getOrganization());
        }
        children.addAll((Collection<Object>)this.contactPersons);
        children.addAll((Collection<Object>)this.additionalMetadata);
        return CollectionSupport.copyToList(children);
    }
}

