/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.intercept;

import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.UnproxyableResolutionException;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.PassivationCapable;
import jakarta.inject.Provider;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.apache.webbeans.config.WebBeansContext;

public class NormalScopedBeanInterceptorHandler
implements Provider,
Serializable {
    private transient BeanManager beanManager;
    protected transient Bean<?> bean;
    private String beanPassivationId;

    public NormalScopedBeanInterceptorHandler(BeanManager beanManager, Bean<?> bean) {
        this.beanManager = beanManager;
        this.bean = bean;
        if (bean instanceof PassivationCapable) {
            this.beanPassivationId = ((PassivationCapable)bean).getId();
        }
    }

    public Object get() {
        return this.getContextualInstance();
    }

    public Bean<?> getBean() {
        return this.bean;
    }

    protected BeanManager getBeanManager() {
        return this.beanManager;
    }

    protected Object getContextualInstance() {
        Context context = this.beanManager.getContext(this.bean.getScope());
        Object webbeansInstance = context.get(this.bean);
        if (webbeansInstance != null) {
            return webbeansInstance;
        }
        CreationalContext cc = this.beanManager.createCreationalContext(this.bean);
        webbeansInstance = context.get(this.bean, cc);
        if (webbeansInstance == null) {
            throw new UnproxyableResolutionException("Cannot find a contextual instance of bean " + this.bean.toString());
        }
        return webbeansInstance;
    }

    protected Object readResolve() throws ObjectStreamException {
        WebBeansContext webBeansContext = WebBeansContext.getInstance();
        this.beanManager = webBeansContext.getBeanManagerImpl();
        this.bean = this.beanManager.getPassivationCapableBean(this.beanPassivationId);
        if (this.bean == null) {
            throw new NotSerializableException("Failure during de-serialisation: Cannot load Bean with passivationId " + this.beanPassivationId);
        }
        return webBeansContext.getNormalScopeProxyFactory().createNormalScopeProxy(this.bean);
    }
}

