/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.cmp.cmp2;

import jakarta.ejb.EJBLocalObject;
import jakarta.ejb.EJBObject;
import jakarta.ejb.EntityBean;
import java.lang.reflect.Field;
import org.apache.openejb.BeanContext;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.core.cmp.CmpContainer;
import org.apache.openejb.core.cmp.KeyGenerator;
import org.apache.openejb.core.ivm.EjbObjectProxyHandler;
import org.apache.openejb.util.proxy.ProxyManager;

public class Cmp2Util {
    public static Object getPrimaryKey(BeanContext beanContext, EntityBean entity) {
        if (entity == null) {
            return null;
        }
        KeyGenerator kg = beanContext.getKeyGenerator();
        Object primaryKey = kg.getPrimaryKey(entity);
        return primaryKey;
    }

    public static <Bean extends EntityBean> Bean getEntityBean(EJBLocalObject proxy) {
        if (proxy == null) {
            return null;
        }
        EjbObjectProxyHandler handler = (EjbObjectProxyHandler)ProxyManager.getInvocationHandler(proxy);
        if (handler.container == null) {
            return null;
        }
        if (!(handler.container instanceof CmpContainer)) {
            throw new IllegalArgumentException("Proxy is not connected to a CMP container but is conect to " + handler.container.getClass().getName());
        }
        CmpContainer container = (CmpContainer)handler.container;
        EntityBean entity = (EntityBean)container.getEjbInstance(handler.getBeanContext(), handler.primaryKey);
        return (Bean)entity;
    }

    public static <Bean extends EntityBean> Bean getEntityBean(EJBObject proxy) {
        if (proxy == null) {
            return null;
        }
        EjbObjectProxyHandler handler = (EjbObjectProxyHandler)ProxyManager.getInvocationHandler(proxy);
        if (handler.container == null) {
            return null;
        }
        if (!(handler.container instanceof CmpContainer)) {
            throw new IllegalArgumentException("Proxy is not connected to a CMP container but is conect to " + handler.container.getClass().getName());
        }
        CmpContainer container = (CmpContainer)handler.container;
        EntityBean entity = (EntityBean)container.getEjbInstance(handler.getBeanContext(), handler.primaryKey);
        return (Bean)entity;
    }

    public static <Proxy extends EJBLocalObject> Proxy getEjbProxy(BeanContext beanContext, EntityBean entity) {
        if (entity == null) {
            return null;
        }
        Object primaryKey = Cmp2Util.getPrimaryKey(beanContext, entity);
        if (!(beanContext.getContainer() instanceof CmpContainer)) {
            throw new IllegalArgumentException("Proxy is not connected to a CMP container but is conect to " + beanContext.getContainer().getClass().getName());
        }
        EJBLocalObject proxy = (EJBLocalObject)EjbObjectProxyHandler.createProxy(beanContext, primaryKey, InterfaceType.EJB_LOCAL_HOME, beanContext.getLocalInterface());
        return (Proxy)proxy;
    }

    public static BeanContext getBeanContext(Class type) {
        BeanContext beanContext;
        try {
            Field deploymentInfoField = type.getField("deploymentInfo");
            beanContext = (BeanContext)deploymentInfoField.get(null);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("EntityBean class " + type.getName() + " does not contain a deploymentInfo field.  Is this a generated CMP 2 entity implementation?", e);
        }
        return beanContext;
    }
}

