/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.util.asm;

import org.apache.openjpa.util.asm.AsmHelper;
import org.apache.openjpa.util.asm.ClassNodeTracker;
import org.apache.openjpa.util.asm.EnhancementProject;

public class EnhancementClassLoader
extends ClassLoader {
    private final EnhancementProject project;

    public EnhancementClassLoader(EnhancementProject project) {
        this.project = project;
    }

    public EnhancementClassLoader(EnhancementProject project, ClassLoader parent) {
        super(parent);
        this.project = project;
    }

    public EnhancementProject getProject() {
        return this.project;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        byte[] bytes;
        try {
            ClassNodeTracker type = !this.project.containsClass(name) ? this.createClass(name) : this.project.loadClass(name);
            if (type == null) {
                throw new ClassNotFoundException(name);
            }
            bytes = AsmHelper.toByteArray(type);
        }
        catch (RuntimeException re) {
            throw new ClassNotFoundException(re.toString());
        }
        return this.defineClass(name, bytes, 0, bytes.length);
    }

    protected ClassNodeTracker createClass(String name) {
        return null;
    }
}

