/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.slice.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.apache.openjpa.slice.jdbc.DistributedPreparedStatement;
import org.apache.openjpa.slice.jdbc.DistributedStatement;

public class DistributedConnection
implements Connection {
    private final List<Connection> real;
    private final Connection master;

    public DistributedConnection(List<Connection> connections) {
        if (connections == null || connections.isEmpty()) {
            throw new NullPointerException();
        }
        this.real = connections;
        this.master = connections.get(0);
    }

    public boolean contains(Connection c) {
        return this.real.contains(c);
    }

    @Override
    public void clearWarnings() throws SQLException {
        for (Connection c : this.real) {
            c.clearWarnings();
        }
    }

    @Override
    public void close() throws SQLException {
        for (Connection c : this.real) {
            c.close();
        }
    }

    @Override
    public void commit() throws SQLException {
        for (Connection c : this.real) {
            c.commit();
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        DistributedStatement ret = new DistributedStatement(this);
        for (Connection c : this.real) {
            ret.add(c.createStatement());
        }
        return ret;
    }

    @Override
    public Statement createStatement(int arg0, int arg1) throws SQLException {
        DistributedStatement ret = new DistributedStatement(this);
        for (Connection c : this.real) {
            ret.add(c.createStatement(arg0, arg1));
        }
        return ret;
    }

    @Override
    public Statement createStatement(int arg0, int arg1, int arg2) throws SQLException {
        DistributedStatement ret = new DistributedStatement(this);
        for (Connection c : this.real) {
            ret.add(c.createStatement(arg0, arg1, arg2));
        }
        return ret;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.master.getAutoCommit();
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.master.getCatalog();
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.master.getHoldability();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.master.getMetaData();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.master.getTransactionIsolation();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.master.getTypeMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.master.getWarnings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        boolean ret = true;
        for (Connection c : this.real) {
            ret &= c.isClosed();
        }
        return ret;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        boolean ret = true;
        for (Connection c : this.real) {
            ret &= c.isReadOnly();
        }
        return ret;
    }

    @Override
    public String nativeSQL(String arg0) throws SQLException {
        return this.master.nativeSQL(arg0);
    }

    @Override
    public CallableStatement prepareCall(String arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public CallableStatement prepareCall(String arg0, int arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public CallableStatement prepareCall(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PreparedStatement prepareStatement(String arg0) throws SQLException {
        if (arg0.indexOf("OPENJPA_SEQUENCE_TABLE") != -1) {
            return this.master.prepareStatement(arg0);
        }
        DistributedPreparedStatement ret = new DistributedPreparedStatement(this);
        for (Connection c : this.real) {
            ret.add(c.prepareStatement(arg0));
        }
        return ret;
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, int arg1) throws SQLException {
        DistributedPreparedStatement ret = new DistributedPreparedStatement(this);
        for (Connection c : this.real) {
            ret.add(c.prepareStatement(arg0, arg1));
        }
        return ret;
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, int[] arg1) throws SQLException {
        DistributedPreparedStatement ret = new DistributedPreparedStatement(this);
        for (Connection c : this.real) {
            ret.add(c.prepareStatement(arg0, arg1));
        }
        return ret;
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, String[] arg1) throws SQLException {
        DistributedPreparedStatement ret = new DistributedPreparedStatement(this);
        for (Connection c : this.real) {
            ret.add(c.prepareStatement(arg0, arg1));
        }
        return ret;
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, int arg1, int arg2) throws SQLException {
        DistributedPreparedStatement ret = new DistributedPreparedStatement(this);
        for (Connection c : this.real) {
            ret.add(c.prepareStatement(arg0, arg1, arg2));
        }
        return ret;
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        DistributedPreparedStatement ret = new DistributedPreparedStatement(this);
        for (Connection c : this.real) {
            ret.add(c.prepareStatement(arg0, arg1, arg2));
        }
        return ret;
    }

    @Override
    public void releaseSavepoint(Savepoint arg0) throws SQLException {
        for (Connection c : this.real) {
            c.releaseSavepoint(arg0);
        }
    }

    @Override
    public void rollback() throws SQLException {
        for (Connection c : this.real) {
            c.rollback();
        }
    }

    @Override
    public void rollback(Savepoint arg0) throws SQLException {
        for (Connection c : this.real) {
            c.rollback(arg0);
        }
    }

    @Override
    public void setAutoCommit(boolean arg0) throws SQLException {
        for (Connection c : this.real) {
            c.setAutoCommit(arg0);
        }
    }

    @Override
    public void setCatalog(String arg0) throws SQLException {
        for (Connection c : this.real) {
            c.setCatalog(arg0);
        }
    }

    @Override
    public void setHoldability(int arg0) throws SQLException {
        for (Connection c : this.real) {
            c.setHoldability(arg0);
        }
    }

    @Override
    public void setReadOnly(boolean arg0) throws SQLException {
        for (Connection c : this.real) {
            c.setReadOnly(arg0);
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Savepoint setSavepoint(String arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTransactionIsolation(int arg0) throws SQLException {
        for (Connection c : this.real) {
            c.setTransactionIsolation(arg0);
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> arg0) throws SQLException {
        for (Connection c : this.real) {
            c.setTypeMap(arg0);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Array createArrayOf(String arg0, Object[] arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Struct createStruct(String arg0, Object[] arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getClientInfo(String arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isValid(int arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClientInfo(Properties arg0) throws SQLClientInfoException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClientInfo(String arg0, String arg1) throws SQLClientInfoException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSchema() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

