/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.el.resolver;

import jakarta.el.BeanELResolver;
import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.PropertyNotFoundException;
import jakarta.el.PropertyNotWritableException;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.myfaces.core.api.shared.lang.LambdaPropertyDescriptor;
import org.apache.myfaces.core.api.shared.lang.PropertyDescriptorUtils;
import org.apache.myfaces.core.api.shared.lang.PropertyDescriptorWrapper;

public class LambdaBeanELResolver
extends BeanELResolver {
    private final ConcurrentHashMap<String, Map<String, ? extends PropertyDescriptorWrapper>> cache = new ConcurrentHashMap(1000);

    public Class<?> getType(ELContext context, Object base, Object property) {
        Objects.requireNonNull(context);
        if (base == null || property == null) {
            return null;
        }
        context.setPropertyResolved(base, property);
        PropertyDescriptorWrapper pdw = this.getPropertyDescriptor(base, property);
        if (pdw.getWrapped().getWriteMethod() == null) {
            return null;
        }
        return pdw.getPropertyType();
    }

    public Object getValue(ELContext context, Object base, Object property) {
        Objects.requireNonNull(context);
        if (base == null || property == null) {
            return null;
        }
        context.setPropertyResolved(base, property);
        try {
            PropertyDescriptorWrapper pd = this.getPropertyDescriptor(base, property);
            Function readFunction = null;
            if (pd instanceof LambdaPropertyDescriptor) {
                readFunction = ((LambdaPropertyDescriptor)pd).getReadFunction();
            }
            if (readFunction != null) {
                return readFunction.apply(base);
            }
            return pd.getWrapped().getReadMethod().invoke(base, new Object[0]);
        }
        catch (Exception e) {
            throw new ELException((Throwable)e);
        }
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        Objects.requireNonNull(context);
        if (base == null || property == null) {
            return;
        }
        context.setPropertyResolved(base, property);
        PropertyDescriptorWrapper pd = this.getPropertyDescriptor(base, property);
        if (pd.getWrapped().getWriteMethod() == null) {
            throw new PropertyNotWritableException("Property \"" + property + "\" in \"" + base.getClass().getName() + "\" is not writable!");
        }
        try {
            BiConsumer writeFunction = null;
            if (pd instanceof LambdaPropertyDescriptor) {
                writeFunction = ((LambdaPropertyDescriptor)pd).getWriteFunction();
            }
            if (writeFunction != null) {
                writeFunction.accept(base, value);
            } else {
                pd.getWrapped().getWriteMethod().invoke(base, value);
            }
        }
        catch (Exception e) {
            throw new ELException((Throwable)e);
        }
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        Objects.requireNonNull(context);
        if (base == null || property == null) {
            return false;
        }
        context.setPropertyResolved(base, property);
        return this.getPropertyDescriptor(base, property).getWrapped().getWriteMethod() == null;
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base != null) {
            return Object.class;
        }
        return null;
    }

    protected PropertyDescriptorWrapper getPropertyDescriptor(Object base, Object property) {
        PropertyDescriptorWrapper pd;
        Map beanCache = this.cache.get(base.getClass().getName());
        if (beanCache == null) {
            beanCache = PropertyDescriptorUtils.getCachedPropertyDescriptors((ExternalContext)FacesContext.getCurrentInstance().getExternalContext(), base.getClass());
            this.cache.put(base.getClass().getName(), beanCache);
        }
        if ((pd = beanCache.get((String)property)) == null) {
            throw new PropertyNotFoundException("Property [" + property + "] not found on type [" + base.getClass().getName() + "]");
        }
        return pd;
    }
}

