/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.handler;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.AttributeKey;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.tinkerpop.gremlin.driver.Channelizer;
import org.apache.tinkerpop.gremlin.driver.Result;
import org.apache.tinkerpop.gremlin.driver.ResultQueue;
import org.apache.tinkerpop.gremlin.driver.exception.ResponseException;
import org.apache.tinkerpop.gremlin.driver.handler.HttpGremlinResponseStreamDecoder;
import org.apache.tinkerpop.gremlin.process.remote.traversal.DefaultRemoteTraverser;
import org.apache.tinkerpop.gremlin.util.ExceptionHelper;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.apache.tinkerpop.gremlin.util.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.util.ser.SerializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GremlinResponseHandler
extends SimpleChannelInboundHandler<ResponseMessage> {
    public static final AttributeKey<Throwable> INBOUND_SSL_EXCEPTION = AttributeKey.valueOf((String)"inboundSslException");
    private static final Logger logger = LoggerFactory.getLogger(GremlinResponseHandler.class);
    private static final AttributeKey<ResponseException> CAUGHT_EXCEPTION = AttributeKey.valueOf((String)"caughtException");
    private final AtomicReference<ResultQueue> pending;

    public GremlinResponseHandler(AtomicReference<ResultQueue> pending) {
        this.pending = pending;
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        ResultQueue current = this.pending.getAndSet(null);
        if (current != null) {
            current.markError(new IllegalStateException("Connection to server is no longer active"));
        }
    }

    protected void channelRead0(ChannelHandlerContext channelHandlerContext, ResponseMessage response) {
        ResultQueue resultQueue;
        HttpResponseStatus statusCode = response.getStatus() == null ? null : response.getStatus().getCode();
        ResultQueue queue = this.pending.get();
        if (null == statusCode || statusCode == HttpResponseStatus.OK) {
            List data = response.getResult().getData();
            boolean bulked = (Boolean)channelHandlerContext.channel().attr(HttpGremlinResponseStreamDecoder.IS_BULKED).get();
            if (bulked) {
                Iterator iter = data.iterator();
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    long bulk = (Long)iter.next();
                    DefaultRemoteTraverser item2 = new DefaultRemoteTraverser(obj, bulk);
                    queue.add(new Result(item2));
                }
            } else {
                data.forEach(item -> queue.add(new Result(item)));
            }
        } else if (statusCode != HttpResponseStatus.NO_CONTENT) {
            channelHandlerContext.channel().attr(CAUGHT_EXCEPTION).set((Object)new ResponseException(response.getStatus().getCode(), response.getStatus().getMessage(), response.getStatus().getException()));
        }
        if (Channelizer.HttpChannelizer.LAST_CONTENT_READ_RESPONSE == response && (resultQueue = (ResultQueue)this.pending.getAndSet(null)) != null) {
            if (null == channelHandlerContext.channel().attr(CAUGHT_EXCEPTION).get()) {
                resultQueue.markComplete();
            } else {
                resultQueue.markError((Throwable)channelHandlerContext.channel().attr(CAUGHT_EXCEPTION).getAndSet(null));
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        logger.error("Could not process the response", cause);
        ResultQueue pendingQueue = this.pending.getAndSet(null);
        if (pendingQueue != null) {
            pendingQueue.markError(cause);
        }
        if (ExceptionHelper.getRootCause((Throwable)cause) instanceof SSLException) {
            ctx.channel().attr(INBOUND_SSL_EXCEPTION).set((Object)cause);
        }
        if (!IteratorUtils.anyMatch(ExceptionUtils.getThrowableList((Throwable)cause).iterator(), t -> t instanceof SerializationException) && ctx.channel().isActive()) {
            ctx.close();
        }
    }
}

