/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.records;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.dag.records.TezID;
import org.apache.tez.util.FastNumberFormat;

public class TezDAGID
extends TezID {
    private static TezID.TezIDCache<TezDAGID> tezDAGIDCache = new TezID.TezIDCache();
    private ApplicationId applicationId;
    public static final String DAG = "dag";
    static final ThreadLocal<FastNumberFormat> tezAppIdFormat = new ThreadLocal<FastNumberFormat>(){

        @Override
        public FastNumberFormat initialValue() {
            FastNumberFormat fmt = FastNumberFormat.getInstance();
            fmt.setMinimumIntegerDigits(4);
            return fmt;
        }
    };
    private static final String DAG_GROUPID_PREFIX = "daggroup";

    public static TezDAGID getInstance(ApplicationId applicationId, int id) {
        Preconditions.checkArgument((applicationId != null ? 1 : 0) != 0, (Object)"ApplicationID cannot be null");
        return tezDAGIDCache.getInstance(new TezDAGID(applicationId, id));
    }

    @InterfaceAudience.Private
    public static void clearCache() {
        tezDAGIDCache.clear();
    }

    public static TezDAGID getInstance(String yarnRMIdentifier, int appId, int id) {
        Preconditions.checkArgument((yarnRMIdentifier != null ? 1 : 0) != 0, (Object)"yarnRMIdentifier cannot be null");
        return tezDAGIDCache.getInstance(new TezDAGID(yarnRMIdentifier, appId, id));
    }

    public TezDAGID() {
    }

    private TezDAGID(ApplicationId applicationId, int id) {
        super(id);
        this.applicationId = applicationId;
    }

    private TezDAGID(String yarnRMIdentifier, int appId, int id) {
        this(ApplicationId.newInstance((long)Long.parseLong(yarnRMIdentifier), (int)appId), id);
    }

    public ApplicationId getApplicationId() {
        return this.applicationId;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        TezDAGID that = (TezDAGID)o;
        return this.applicationId.equals((Object)that.applicationId);
    }

    @Override
    public int compareTo(TezID o) {
        TezDAGID that = (TezDAGID)o;
        return this.applicationId.compareTo(that.applicationId);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.applicationId = ApplicationId.newInstance((long)in.readLong(), (int)in.readInt());
        super.readFields(in);
    }

    public static TezDAGID readTezDAGID(DataInput in) throws IOException {
        long clusterId = in.readLong();
        int appId = in.readInt();
        int dagIdInt = TezID.readID(in);
        TezDAGID dagID = TezDAGID.getInstance(ApplicationId.newInstance((long)clusterId, (int)appId), dagIdInt);
        return dagID;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeLong(this.applicationId.getClusterTimestamp());
        out.writeInt(this.applicationId.getId());
        super.write(out);
    }

    @Override
    public String toString() {
        return this.appendTo(new StringBuilder(DAG)).toString();
    }

    public String getGroupId(int numDagsPerGroup) {
        if (numDagsPerGroup <= 1) {
            throw new IllegalArgumentException("numDagsPerGroup has to be more than one. Got: " + numDagsPerGroup);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(DAG_GROUPID_PREFIX);
        sb.append('_');
        sb.append(this.getApplicationId().getClusterTimestamp());
        sb.append('_');
        tezAppIdFormat.get().format(this.getApplicationId().getId(), sb);
        sb.append('_');
        sb.append((this.id - 1) / numDagsPerGroup);
        return sb.toString();
    }

    public static TezDAGID fromString(String dagId) {
        int id = 0;
        int appId = 0;
        String[] split = dagId.split("_");
        if (split.length != 4 || !dagId.startsWith("dag_")) {
            throw new IllegalArgumentException("Invalid DAG Id format : " + dagId);
        }
        String rmId = split[1];
        try {
            appId = Integer.parseInt(split[2]);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Error while parsing App Id '" + split[2] + "' of DAG Id : " + dagId);
        }
        try {
            id = Integer.parseInt(split[3]);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Error while parsing Id '" + split[3] + "' of DAG Id : " + dagId);
        }
        return TezDAGID.getInstance(rmId, appId, id);
    }

    protected StringBuilder appendTo(StringBuilder builder) {
        builder.append('_');
        builder.append(this.applicationId.getClusterTimestamp());
        builder.append('_');
        tezAppIdFormat.get().format(this.applicationId.getId(), builder);
        return builder.append('_').append(this.id);
    }

    @Override
    public int hashCode() {
        return this.applicationId.hashCode() * 524287 + this.id;
    }
}

