/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.examples;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.tez.client.TezClient;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.Edge;
import org.apache.tez.dag.api.EdgeManagerPluginDescriptor;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.VertexManagerPluginDescriptor;
import org.apache.tez.examples.TezExampleBase;
import org.apache.tez.mapreduce.input.MRInput;
import org.apache.tez.mapreduce.output.MROutput;
import org.apache.tez.mapreduce.processor.SimpleMRProcessor;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.ProcessorContext;
import org.apache.tez.runtime.library.api.KeyValueReader;
import org.apache.tez.runtime.library.api.KeyValueWriter;
import org.apache.tez.runtime.library.api.Partitioner;
import org.apache.tez.runtime.library.cartesianproduct.CartesianProductConfig;
import org.apache.tez.runtime.library.cartesianproduct.CartesianProductEdgeManager;
import org.apache.tez.runtime.library.cartesianproduct.CartesianProductVertexManager;
import org.apache.tez.runtime.library.conf.UnorderedKVEdgeConfig;
import org.apache.tez.runtime.library.conf.UnorderedPartitionedKVEdgeConfig;
import org.apache.tez.runtime.library.processor.SimpleProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CartesianProduct
extends TezExampleBase {
    private static final String INPUT = "Input1";
    private static final String OUTPUT = "Output";
    private static final String VERTEX1 = "Vertex1";
    private static final String VERTEX2 = "Vertex2";
    private static final String VERTEX3 = "Vertex3";
    private static final String VERTEX4 = "Vertex4";
    private static final String PARTITIONED = "-partitioned";
    private static final String UNPARTITIONED = "-unpartitioned";
    private static final Logger LOG = LoggerFactory.getLogger(CartesianProduct.class);
    private static final int numPartition = 2;
    private static final String[] cpSources = new String[]{"Vertex1", "Vertex2"};

    private DAG createDAG(TezConfiguration tezConf, String inputPath1, String inputPath2, String inputPath3, String outputPath, boolean isPartitioned) throws IOException {
        EdgeProperty cpEdgeProperty;
        CartesianProductConfig cartesianProductConfig;
        Vertex v1 = Vertex.create((String)VERTEX1, (ProcessorDescriptor)ProcessorDescriptor.create((String)TokenProcessor.class.getName()));
        v1.addDataSource(INPUT, MRInput.createConfigBuilder((Configuration)new Configuration((Configuration)tezConf), TextInputFormat.class, (String)inputPath1).groupSplits(false).build());
        Vertex v2 = Vertex.create((String)VERTEX2, (ProcessorDescriptor)ProcessorDescriptor.create((String)TokenProcessor.class.getName()));
        v2.addDataSource(INPUT, MRInput.createConfigBuilder((Configuration)new Configuration((Configuration)tezConf), TextInputFormat.class, (String)inputPath2).groupSplits(false).build());
        Vertex v3 = Vertex.create((String)VERTEX3, (ProcessorDescriptor)ProcessorDescriptor.create((String)TokenProcessor.class.getName()));
        v3.addDataSource(INPUT, MRInput.createConfigBuilder((Configuration)new Configuration((Configuration)tezConf), TextInputFormat.class, (String)inputPath3).groupSplits(false).build());
        if (isPartitioned) {
            HashMap<String, Integer> vertexPartitionMap = new HashMap<String, Integer>();
            for (String vertex : cpSources) {
                vertexPartitionMap.put(vertex, 2);
            }
            cartesianProductConfig = new CartesianProductConfig(vertexPartitionMap);
        } else {
            cartesianProductConfig = new CartesianProductConfig(Arrays.asList(cpSources));
        }
        UserPayload userPayload = cartesianProductConfig.toUserPayload(tezConf);
        Vertex v4 = Vertex.create((String)VERTEX4, (ProcessorDescriptor)ProcessorDescriptor.create((String)JoinProcessor.class.getName()));
        v4.addDataSink(OUTPUT, MROutput.createConfigBuilder((Configuration)new Configuration((Configuration)tezConf), TextOutputFormat.class, (String)outputPath).build());
        v4.setVertexManagerPlugin((VertexManagerPluginDescriptor)VertexManagerPluginDescriptor.create((String)CartesianProductVertexManager.class.getName()).setUserPayload(userPayload));
        EdgeManagerPluginDescriptor cpEdgeManager = EdgeManagerPluginDescriptor.create((String)CartesianProductEdgeManager.class.getName());
        cpEdgeManager.setUserPayload(userPayload);
        if (isPartitioned) {
            UnorderedPartitionedKVEdgeConfig cpEdgeConf = UnorderedPartitionedKVEdgeConfig.newBuilder((String)Text.class.getName(), (String)IntWritable.class.getName(), (String)CustomPartitioner.class.getName()).build();
            cpEdgeProperty = cpEdgeConf.createDefaultCustomEdgeProperty(cpEdgeManager);
        } else {
            UnorderedKVEdgeConfig edgeConf = UnorderedKVEdgeConfig.newBuilder((String)Text.class.getName(), (String)IntWritable.class.getName()).build();
            cpEdgeProperty = edgeConf.createDefaultCustomEdgeProperty(cpEdgeManager);
        }
        UnorderedKVEdgeConfig broadcastEdgeConf = UnorderedKVEdgeConfig.newBuilder((String)Text.class.getName(), (String)IntWritable.class.getName()).build();
        EdgeProperty broadcastEdgeProperty = broadcastEdgeConf.createDefaultBroadcastEdgeProperty();
        return DAG.create((String)"CartesianProduct").addVertex(v1).addVertex(v2).addVertex(v3).addVertex(v4).addEdge(Edge.create((Vertex)v1, (Vertex)v4, (EdgeProperty)cpEdgeProperty)).addEdge(Edge.create((Vertex)v2, (Vertex)v4, (EdgeProperty)cpEdgeProperty)).addEdge(Edge.create((Vertex)v3, (Vertex)v4, (EdgeProperty)broadcastEdgeProperty));
    }

    @Override
    protected void printUsage() {
        System.err.println("Usage: args: [-partitioned|-unpartitioned <input_dir1> <input_dir2> <input_dir3> <output_dir>");
    }

    @Override
    protected int validateArgs(String[] otherArgs) {
        return otherArgs.length != 5 || !otherArgs[0].equals(PARTITIONED) && !otherArgs[0].equals(UNPARTITIONED) ? -1 : 0;
    }

    @Override
    protected int runJob(String[] args, TezConfiguration tezConf, TezClient tezClient) throws Exception {
        DAG dag = this.createDAG(tezConf, args[1], args[2], args[3], args[4], args[0].equals(PARTITIONED));
        return this.runDag(dag, this.isCountersLog(), LOG);
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new CartesianProduct(), (String[])args);
        System.exit(res);
    }

    public static class CustomPartitioner
    implements Partitioner {
        public int getPartition(Object key, Object value, int numPartitions) {
            return key.toString().charAt(0) % 2;
        }
    }

    public static class JoinProcessor
    extends SimpleMRProcessor {
        public JoinProcessor(ProcessorContext context) {
            super(context);
        }

        public void run() throws Exception {
            KeyValueWriter kvWriter = (KeyValueWriter)((LogicalOutput)this.getOutputs().get(CartesianProduct.OUTPUT)).getWriter();
            KeyValueReader kvReader1 = (KeyValueReader)((LogicalInput)this.getInputs().get(CartesianProduct.VERTEX1)).getReader();
            KeyValueReader kvReader2 = (KeyValueReader)((LogicalInput)this.getInputs().get(CartesianProduct.VERTEX2)).getReader();
            KeyValueReader kvReader3 = (KeyValueReader)((LogicalInput)this.getInputs().get(CartesianProduct.VERTEX3)).getReader();
            HashSet<String> v2TokenSet = new HashSet<String>();
            HashSet<String> v3TokenSet = new HashSet<String>();
            while (kvReader2.next()) {
                v2TokenSet.add(kvReader2.getCurrentKey().toString());
            }
            while (kvReader3.next()) {
                v3TokenSet.add(kvReader3.getCurrentKey().toString());
            }
            while (kvReader1.next()) {
                String left = kvReader1.getCurrentKey().toString();
                if (!v3TokenSet.contains(left)) continue;
                for (String right : v2TokenSet) {
                    kvWriter.write((Object)left, (Object)right);
                }
            }
        }
    }

    public static class TokenProcessor
    extends SimpleProcessor {
        public TokenProcessor(ProcessorContext context) {
            super(context);
        }

        public void run() throws Exception {
            Preconditions.checkArgument((this.getInputs().size() == 1 ? 1 : 0) != 0);
            Preconditions.checkArgument((this.getOutputs().size() == 1 ? 1 : 0) != 0);
            KeyValueReader kvReader = (KeyValueReader)((LogicalInput)this.getInputs().get(CartesianProduct.INPUT)).getReader();
            KeyValueWriter kvWriter = (KeyValueWriter)((LogicalOutput)this.getOutputs().get(CartesianProduct.VERTEX4)).getWriter();
            while (kvReader.next()) {
                StringTokenizer itr = new StringTokenizer(kvReader.getCurrentValue().toString());
                while (itr.hasMoreTokens()) {
                    kvWriter.write((Object)new Text(itr.nextToken()), (Object)new IntWritable(1));
                }
            }
        }
    }
}

