/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.input;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.tez.common.Preconditions;
import org.apache.tez.common.TezUtils;
import org.apache.tez.common.TezUtilsInternal;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.runtime.api.AbstractLogicalInput;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.InputContext;
import org.apache.tez.runtime.api.MemoryUpdateCallback;
import org.apache.tez.runtime.api.ProgressFailedException;
import org.apache.tez.runtime.api.TaskContext;
import org.apache.tez.runtime.library.api.KeyValueReader;
import org.apache.tez.runtime.library.common.MemoryUpdateCallbackHandler;
import org.apache.tez.runtime.library.common.readers.UnorderedKVReader;
import org.apache.tez.runtime.library.common.shuffle.ShuffleEventHandler;
import org.apache.tez.runtime.library.common.shuffle.ShuffleUtils;
import org.apache.tez.runtime.library.common.shuffle.impl.ShuffleInputEventHandlerImpl;
import org.apache.tez.runtime.library.common.shuffle.impl.ShuffleManager;
import org.apache.tez.runtime.library.common.shuffle.impl.SimpleFetchedInputAllocator;
import org.apache.tez.runtime.library.utils.CodecUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class UnorderedKVInput
extends AbstractLogicalInput {
    private static final Logger LOG = LoggerFactory.getLogger(UnorderedKVInput.class);
    private Configuration conf;
    private ShuffleManager shuffleManager;
    private final BlockingQueue<Event> pendingEvents = new LinkedBlockingQueue<Event>();
    private long firstEventReceivedTime = -1L;
    private MemoryUpdateCallbackHandler memoryUpdateCallbackHandler;
    private UnorderedKVReader kvReader;
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    private TezCounter inputRecordCounter;
    private SimpleFetchedInputAllocator inputManager;
    private ShuffleEventHandler inputEventHandler;
    private static final Set<String> confKeys = new HashSet<String>();

    public UnorderedKVInput(InputContext inputContext, int numPhysicalInputs) {
        super(inputContext, numPhysicalInputs);
    }

    public synchronized List<Event> initialize() throws Exception {
        Preconditions.checkArgument((this.getNumPhysicalInputs() != -1 ? 1 : 0) != 0, (Object)"Number of Inputs has not been set");
        this.conf = TezUtils.createConfFromBaseConfAndPayload((TaskContext)this.getContext());
        if (this.getNumPhysicalInputs() == 0) {
            this.getContext().requestInitialMemory(0L, null);
            this.isStarted.set(true);
            this.getContext().inputIsReady();
            LOG.info("input fetch not required since there are 0 physical inputs for input vertex: " + this.getContext().getInputOutputVertexNames());
            return Collections.emptyList();
        }
        long initialMemReq = this.getInitialMemoryReq();
        this.memoryUpdateCallbackHandler = new MemoryUpdateCallbackHandler();
        this.getContext().requestInitialMemory(initialMemReq, (MemoryUpdateCallback)this.memoryUpdateCallbackHandler);
        this.conf.setStrings("tez.runtime.framework.local.dirs", this.getContext().getWorkDirs());
        this.inputRecordCounter = this.getContext().getCounters().findCounter((Enum)TaskCounter.INPUT_RECORDS_PROCESSED);
        return Collections.emptyList();
    }

    public synchronized void start() throws IOException {
        if (!this.isStarted.get()) {
            this.memoryUpdateCallbackHandler.validateUpdateReceived();
            CompressionCodec codec = CodecUtils.getCodec(this.conf);
            boolean compositeFetch = ShuffleUtils.isTezShuffleHandler(this.conf);
            boolean ifileReadAhead = this.conf.getBoolean("tez.runtime.ifile.readahead", true);
            int ifileReadAheadLength = 0;
            int ifileBufferSize = 0;
            if (ifileReadAhead) {
                ifileReadAheadLength = this.conf.getInt("tez.runtime.ifile.readahead.bytes", 0x400000);
            }
            ifileBufferSize = this.conf.getInt("io.file.buffer.size", -1);
            this.inputManager = new SimpleFetchedInputAllocator(TezUtilsInternal.cleanVertexName((String)this.getContext().getSourceVertexName()), this.getContext().getUniqueIdentifier(), this.getContext().getDagIdentifier(), this.conf, this.getContext().getTotalMemoryAvailableToTask(), this.memoryUpdateCallbackHandler.getMemoryAssigned());
            this.shuffleManager = new ShuffleManager(this.getContext(), this.conf, this.getNumPhysicalInputs(), ifileBufferSize, ifileReadAhead, ifileReadAheadLength, codec, this.inputManager);
            this.inputEventHandler = new ShuffleInputEventHandlerImpl(this.getContext(), this.shuffleManager, this.inputManager, codec, ifileReadAhead, ifileReadAheadLength, compositeFetch);
            this.shuffleManager.run();
            this.kvReader = this.createReader(this.inputRecordCounter, codec, ifileBufferSize, ifileReadAhead, ifileReadAheadLength);
            LinkedList<Event> pending = new LinkedList<Event>();
            this.pendingEvents.drainTo(pending);
            if (pending.size() > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.getContext().getInputOutputVertexNames() + ": NoAutoStart delay in processing first event: " + (System.currentTimeMillis() - this.firstEventReceivedTime));
                }
                this.inputEventHandler.handleEvents(pending);
            }
            this.isStarted.set(true);
        }
    }

    public synchronized KeyValueReader getReader() throws Exception {
        Preconditions.checkState((boolean)this.isStarted.get(), (Object)"Must start input before invoking this method");
        if (this.getNumPhysicalInputs() == 0) {
            return new KeyValueReader(){

                @Override
                public boolean next() throws IOException {
                    UnorderedKVInput.this.getContext().notifyProgress();
                    this.hasCompletedProcessing();
                    this.completedProcessing = true;
                    return false;
                }

                @Override
                public Object getCurrentKey() throws IOException {
                    throw new RuntimeException("No data available in Input");
                }

                @Override
                public Object getCurrentValue() throws IOException {
                    throw new RuntimeException("No data available in Input");
                }
            };
        }
        return this.kvReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvents(List<Event> inputEvents) throws IOException {
        ShuffleEventHandler inputEventHandlerLocalRef;
        UnorderedKVInput unorderedKVInput = this;
        synchronized (unorderedKVInput) {
            if (this.getNumPhysicalInputs() == 0) {
                throw new RuntimeException("No input events expected as numInputs is 0");
            }
            if (!this.isStarted.get()) {
                if (this.firstEventReceivedTime == -1L) {
                    this.firstEventReceivedTime = System.currentTimeMillis();
                }
                this.pendingEvents.addAll(inputEvents);
                return;
            }
            inputEventHandlerLocalRef = this.inputEventHandler;
        }
        inputEventHandlerLocalRef.handleEvents(inputEvents);
    }

    public synchronized List<Event> close() throws Exception {
        if (this.inputEventHandler != null) {
            this.inputEventHandler.logProgress(true);
        }
        if (this.shuffleManager != null) {
            this.shuffleManager.shutdown();
        }
        long dataSize = this.getContext().getCounters().findCounter((Enum)TaskCounter.SHUFFLE_BYTES_DECOMPRESSED).getValue();
        this.getContext().getStatisticsReporter().reportDataSize(dataSize);
        long inputRecords = this.getContext().getCounters().findCounter((Enum)TaskCounter.INPUT_RECORDS_PROCESSED).getValue();
        this.getContext().getStatisticsReporter().reportItemsProcessed(inputRecords);
        return null;
    }

    private long getInitialMemoryReq() {
        return SimpleFetchedInputAllocator.getInitialMemoryReq(this.conf, this.getContext().getTotalMemoryAvailableToTask());
    }

    private UnorderedKVReader createReader(TezCounter inputRecordCounter, CompressionCodec codec, int ifileBufferSize, boolean ifileReadAheadEnabled, int ifileReadAheadLength) throws IOException {
        return new UnorderedKVReader(this.shuffleManager, this.conf, codec, ifileReadAheadEnabled, ifileReadAheadLength, ifileBufferSize, inputRecordCounter, this.getContext());
    }

    @InterfaceAudience.Private
    public static Set<String> getConfigurationKeySet() {
        return Collections.unmodifiableSet(confKeys);
    }

    public float getProgress() throws ProgressFailedException, InterruptedException {
        try {
            return this.kvReader.getProgress();
        }
        catch (IOException e) {
            throw new ProgressFailedException("getProgress encountered IOException ", (Throwable)e);
        }
    }

    static {
        confKeys.add("tez.runtime.ifile.readahead");
        confKeys.add("tez.runtime.ifile.readahead.bytes");
        confKeys.add("io.file.buffer.size");
        confKeys.add("tez.runtime.io.sort.factor");
        confKeys.add("tez.runtime.shuffle.use.async.http");
        confKeys.add("tez.runtime.shuffle.parallel.copies");
        confKeys.add("tez.runtime.shuffle.fetch.failures.limit");
        confKeys.add("tez.runtime.shuffle.fetch.max.task.output.at.once");
        confKeys.add("tez.runtime.shuffle.notify.readerror");
        confKeys.add("tez.runtime.shuffle.connect.timeout");
        confKeys.add("tez.runtime.shuffle.keep-alive.enabled");
        confKeys.add("tez.runtime.shuffle.keep-alive.max.connections");
        confKeys.add("tez.runtime.shuffle.read.timeout");
        confKeys.add("tez.runtime.shuffle.buffersize");
        confKeys.add("tez.runtime.shuffle.ssl.enable");
        confKeys.add("tez.runtime.shuffle.fetch.verify-disk-checksum");
        confKeys.add("tez.runtime.shuffle.fetch.buffer.percent");
        confKeys.add("tez.runtime.shuffle.memory.limit.percent");
        confKeys.add("tez.runtime.shuffle.merge.percent");
        confKeys.add("tez.runtime.shuffle.fetcher.use-shared-pool");
        confKeys.add("tez.runtime.task.input.post-merge.buffer.percent");
        confKeys.add("tez.runtime.key.class");
        confKeys.add("tez.runtime.value.class");
        confKeys.add("tez.runtime.compress");
        confKeys.add("tez.runtime.compress.codec");
        confKeys.add("tez.runtime.optimize.local.fetch");
        confKeys.add("tez.runtime.optimize.shared.fetch");
        confKeys.add("tez.runtime.convert.user-payload.to.history-text");
        confKeys.add("tez.counters.max");
        confKeys.add("tez.counters.group-name.max-length");
        confKeys.add("tez.counters.counter-name.max-length");
        confKeys.add("tez.counters.max.groups");
        confKeys.add("tez.runtime.cleanup.files.on.interrupt");
        confKeys.add("tez.runtime.task.memory");
        confKeys.add("tez.am.shuffle.auxiliary-service.id");
    }
}

