/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.logging.proto;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.tez.dag.history.logging.proto.DatePartitionedLogger;
import org.apache.tez.dag.history.logging.proto.HistoryLoggerProtos;

public class TezProtoLoggers {
    private DatePartitionedLogger<HistoryLoggerProtos.HistoryEventProto> appEventsLogger;
    private DatePartitionedLogger<HistoryLoggerProtos.HistoryEventProto> dagEventsLogger;
    private DatePartitionedLogger<HistoryLoggerProtos.ManifestEntryProto> manifestEventsLogger;

    public boolean setup(Configuration conf, Clock clock) throws IOException {
        String logDir = conf.get("tez.history.logging.proto-base-dir");
        if (logDir == null) {
            return false;
        }
        this.appEventsLogger = new DatePartitionedLogger<HistoryLoggerProtos.HistoryEventProto>(HistoryLoggerProtos.HistoryEventProto.PARSER, new Path(logDir, "app_data"), conf, clock);
        this.dagEventsLogger = new DatePartitionedLogger<HistoryLoggerProtos.HistoryEventProto>(HistoryLoggerProtos.HistoryEventProto.PARSER, new Path(logDir, "dag_data"), conf, clock);
        this.manifestEventsLogger = new DatePartitionedLogger<HistoryLoggerProtos.ManifestEntryProto>(HistoryLoggerProtos.ManifestEntryProto.PARSER, new Path(logDir, "dag_meta"), conf, clock);
        return true;
    }

    public DatePartitionedLogger<HistoryLoggerProtos.HistoryEventProto> getAppEventsLogger() {
        return this.appEventsLogger;
    }

    public DatePartitionedLogger<HistoryLoggerProtos.HistoryEventProto> getDagEventsLogger() {
        return this.dagEventsLogger;
    }

    public DatePartitionedLogger<HistoryLoggerProtos.ManifestEntryProto> getManifestEventsLogger() {
        return this.manifestEventsLogger;
    }
}

