/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import org.apache.sysds.common.Types;
import org.apache.sysds.conf.CompilerConfig;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.io.WriterCompressed;
import org.apache.sysds.runtime.io.FileFormatProperties;
import org.apache.sysds.runtime.io.FileFormatPropertiesCSV;
import org.apache.sysds.runtime.io.FileFormatPropertiesHDF5;
import org.apache.sysds.runtime.io.FileFormatPropertiesLIBSVM;
import org.apache.sysds.runtime.io.MatrixWriter;
import org.apache.sysds.runtime.io.WriterBinaryBlock;
import org.apache.sysds.runtime.io.WriterBinaryBlockParallel;
import org.apache.sysds.runtime.io.WriterHDF5;
import org.apache.sysds.runtime.io.WriterHDF5Parallel;
import org.apache.sysds.runtime.io.WriterMatrixMarket;
import org.apache.sysds.runtime.io.WriterTextCSV;
import org.apache.sysds.runtime.io.WriterTextCSVParallel;
import org.apache.sysds.runtime.io.WriterTextCell;
import org.apache.sysds.runtime.io.WriterTextCellParallel;
import org.apache.sysds.runtime.io.WriterTextLIBSVM;
import org.apache.sysds.runtime.io.WriterTextLIBSVMParallel;

public class MatrixWriterFactory {
    public static MatrixWriter createMatrixWriter(Types.FileFormat fmt) {
        return MatrixWriterFactory.createMatrixWriter(fmt, -1, null);
    }

    public static MatrixWriter createMatrixWriter(Types.FileFormat fmt, int replication, FileFormatProperties props) {
        MatrixWriter writer = null;
        switch (fmt) {
            case TEXT: {
                if (ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_WRITE_TEXTFORMATS)) {
                    writer = new WriterTextCellParallel();
                    break;
                }
                writer = new WriterTextCell();
                break;
            }
            case MM: {
                writer = new WriterMatrixMarket();
                break;
            }
            case CSV: {
                if (props != null && !(props instanceof FileFormatPropertiesCSV)) {
                    throw new DMLRuntimeException("Wrong type of file format properties for CSV writer.");
                }
                if (ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_WRITE_TEXTFORMATS)) {
                    writer = new WriterTextCSVParallel((FileFormatPropertiesCSV)props);
                    break;
                }
                writer = new WriterTextCSV((FileFormatPropertiesCSV)props);
                break;
            }
            case LIBSVM: {
                if (props != null && !(props instanceof FileFormatPropertiesLIBSVM)) {
                    throw new DMLRuntimeException("Wrong type of file format properties for LIBSVM writer.");
                }
                if (ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_WRITE_TEXTFORMATS)) {
                    writer = new WriterTextLIBSVMParallel((FileFormatPropertiesLIBSVM)props);
                    break;
                }
                writer = new WriterTextLIBSVM((FileFormatPropertiesLIBSVM)props);
                break;
            }
            case BINARY: {
                if (ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_WRITE_BINARYFORMATS)) {
                    writer = new WriterBinaryBlockParallel(replication);
                    break;
                }
                writer = new WriterBinaryBlock(replication);
                break;
            }
            case HDF5: {
                if (props != null && !(props instanceof FileFormatPropertiesHDF5)) {
                    throw new DMLRuntimeException("Wrong type of file format properties for HDF5 writer.");
                }
                if (ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_WRITE_TEXTFORMATS)) {
                    return new WriterHDF5Parallel((FileFormatPropertiesHDF5)props);
                }
                return new WriterHDF5((FileFormatPropertiesHDF5)props);
            }
            case COMPRESSED: {
                return WriterCompressed.create(props);
            }
            default: {
                throw new DMLRuntimeException("Failed to create matrix writer for unknown format: " + fmt.toString());
            }
        }
        return writer;
    }
}

