/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.lineage;

import java.util.concurrent.atomic.LongAdder;

public class LineageCacheStatistics {
    private static final LongAdder _numHitsMem = new LongAdder();
    private static final LongAdder _numHitsFS = new LongAdder();
    private static final LongAdder _numHitsDel = new LongAdder();
    private static final LongAdder _numHitsInst = new LongAdder();
    private static final LongAdder _numHitsSB = new LongAdder();
    private static final LongAdder _numHitsFunc = new LongAdder();
    private static final LongAdder _numWritesMem = new LongAdder();
    private static final LongAdder _numWritesFS = new LongAdder();
    private static final LongAdder _numMemDel = new LongAdder();
    private static final LongAdder _numRewrites = new LongAdder();
    private static final LongAdder _ctimeFSRead = new LongAdder();
    private static final LongAdder _ctimeFSWrite = new LongAdder();
    private static final LongAdder _ctimeSaved = new LongAdder();
    private static final LongAdder _ctimeMissed = new LongAdder();
    private static final LongAdder _numHitsGpu = new LongAdder();
    private static final LongAdder _numAsyncEvictGpu = new LongAdder();
    private static final LongAdder _numSyncEvictGpu = new LongAdder();

    public static void reset() {
        _numHitsMem.reset();
        _numHitsFS.reset();
        _numHitsDel.reset();
        _numHitsInst.reset();
        _numHitsSB.reset();
        _numHitsFunc.reset();
        _numWritesMem.reset();
        _numWritesFS.reset();
        _numMemDel.reset();
        _numRewrites.reset();
        _ctimeFSRead.reset();
        _ctimeFSWrite.reset();
        _ctimeSaved.reset();
        _ctimeMissed.reset();
        _numHitsGpu.reset();
        _numAsyncEvictGpu.reset();
        _numSyncEvictGpu.reset();
    }

    public static void incrementMemHits() {
        _numHitsMem.increment();
    }

    public static void incrementFSHits() {
        _numHitsFS.increment();
    }

    public static void incrementDelHits() {
        _numHitsDel.increment();
    }

    public static void incrementInstHits() {
        _numHitsInst.increment();
    }

    public static long getInstHits() {
        return _numHitsInst.longValue();
    }

    public static void incrementSBHits() {
        _numHitsSB.increment();
    }

    public static void incrementFuncHits() {
        _numHitsFunc.increment();
    }

    public static void incrementMemWrites() {
        _numWritesMem.increment();
    }

    public static void incrementPRewrites() {
        _numRewrites.increment();
    }

    public static void incrementFSWrites() {
        _numWritesFS.increment();
    }

    public static void incrementMemDeletes() {
        _numMemDel.increment();
    }

    public static long getMemDeletes() {
        return _numMemDel.longValue();
    }

    public static void incrementFSReadTime(long delta) {
        _ctimeFSRead.add(delta);
    }

    public static void incrementFSWriteTime(long delta) {
        _ctimeFSWrite.add(delta);
    }

    public static void incrementSavedComputeTime(long delta) {
        _ctimeSaved.add(delta);
    }

    public static void incrementMissedComputeTime(long delta) {
        _ctimeMissed.add(delta);
    }

    public static long getMultiLevelFnHits() {
        return _numHitsFunc.longValue();
    }

    public static long getMultiLevelSBHits() {
        return _numHitsSB.longValue();
    }

    public static void incrementGpuHits() {
        _numHitsGpu.increment();
    }

    public static void incrementGpuAsyncEvicts() {
        _numAsyncEvictGpu.increment();
    }

    public static void incrementGpuSyncEvicts() {
        _numSyncEvictGpu.increment();
    }

    public static String displayHits() {
        StringBuilder sb = new StringBuilder();
        sb.append(_numHitsMem.longValue());
        sb.append("/");
        sb.append(_numHitsFS.longValue());
        sb.append("/");
        sb.append(_numHitsDel.longValue());
        return sb.toString();
    }

    public static String displayMultiLevelHits() {
        StringBuilder sb = new StringBuilder();
        sb.append(_numHitsInst.longValue());
        sb.append("/");
        sb.append(_numHitsSB.longValue());
        sb.append("/");
        sb.append(_numHitsFunc.longValue());
        return sb.toString();
    }

    public static String displayWtrites() {
        StringBuilder sb = new StringBuilder();
        sb.append(_numWritesMem.longValue());
        sb.append("/");
        sb.append(_numWritesFS.longValue());
        sb.append("/");
        sb.append(_numMemDel.longValue());
        return sb.toString();
    }

    public static String displayRewrites() {
        StringBuilder sb = new StringBuilder();
        sb.append(_numRewrites.longValue());
        return sb.toString();
    }

    public static String displayFSTime() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%.3f", (double)_ctimeFSRead.longValue() / 1.0E9));
        sb.append("/");
        sb.append(String.format("%.3f", (double)_ctimeFSWrite.longValue() / 1.0E9));
        return sb.toString();
    }

    public static String displayComputeTime() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%.3f", (double)_ctimeSaved.longValue() / 1.0E9));
        sb.append("/");
        sb.append(String.format("%.3f", (double)_ctimeMissed.longValue() / 1.0E9));
        return sb.toString();
    }

    public static String displayGpuStats() {
        StringBuilder sb = new StringBuilder();
        sb.append(_numHitsGpu.longValue());
        sb.append("/");
        sb.append(_numAsyncEvictGpu.longValue());
        sb.append("/");
        sb.append(_numSyncEvictGpu.longValue());
        return sb.toString();
    }
}

