/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.trace;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.ipc.trace.Span;
import org.apache.avro.ipc.trace.SpanEvent;
import org.apache.avro.ipc.trace.TimestampedEvent;
import org.apache.avro.ipc.trace.Trace;
import org.apache.avro.ipc.trace.TraceNode;
import org.apache.avro.ipc.trace.Util;
import org.junit.Assert;
import org.junit.Test;

public class TestSpanTraceFormation {
    @Test
    public void testSpanEquality() {
        Span root = new Span();
        root.setSpanID(Util.idValue((long)10L));
        root.setParentSpanID(null);
        root.setMessageName(new String("startCall"));
        Span a = new Span();
        a.setSpanID(Util.idValue((long)11L));
        a.setParentSpanID(Util.idValue((long)10L));
        a.setMessageName(new String("childCall1"));
        Span b = new Span();
        b.setSpanID(Util.idValue((long)12L));
        b.setParentSpanID(Util.idValue((long)10L));
        b.setMessageName(new String("childCall2"));
        Span c = new Span();
        c.setSpanID(Util.idValue((long)13L));
        c.setParentSpanID(Util.idValue((long)10L));
        c.setMessageName(new String("childCall3"));
        LinkedList<Span> spans = new LinkedList<Span>();
        spans.add(root);
        spans.add(a);
        spans.add(b);
        spans.add(c);
        Trace trace1 = Trace.extractTrace(spans);
        Span d = new Span();
        d.setSpanID(Util.idValue((long)11L));
        d.setParentSpanID(Util.idValue((long)10L));
        d.setMessageName(new String("childCall1"));
        Span e = new Span();
        e.setSpanID(Util.idValue((long)12L));
        e.setParentSpanID(Util.idValue((long)10L));
        e.setMessageName(new String("childCall2"));
        Span f = new Span();
        f.setSpanID(Util.idValue((long)13L));
        f.setParentSpanID(Util.idValue((long)10L));
        f.setMessageName(new String("childCall3"));
        spans.clear();
        spans.add(d);
        spans.add(e);
        spans.add(f);
        spans.add(root);
        Trace trace2 = Trace.extractTrace(spans);
        Assert.assertEquals((long)trace1.executionPathHash(), (long)trace2.executionPathHash());
    }

    @Test
    public void testSpanEquality2() {
        Span root = new Span();
        root.setSpanID(Util.idValue((long)10L));
        root.setParentSpanID(null);
        root.setMessageName(new String("startCall"));
        Span a = new Span();
        a.setSpanID(Util.idValue((long)11L));
        a.setParentSpanID(Util.idValue((long)10L));
        a.setMessageName(new String("childCall1"));
        Span b = new Span();
        b.setSpanID(Util.idValue((long)12L));
        b.setParentSpanID(Util.idValue((long)10L));
        b.setMessageName(new String("childCall2"));
        Span c = new Span();
        c.setSpanID(Util.idValue((long)13L));
        c.setParentSpanID(Util.idValue((long)10L));
        c.setMessageName(new String("childCall3"));
        LinkedList<Span> spans = new LinkedList<Span>();
        spans.add(root);
        spans.add(a);
        spans.add(b);
        spans.add(c);
        Trace trace1 = Trace.extractTrace(spans);
        Span d = new Span();
        d.setSpanID(Util.idValue((long)11L));
        d.setParentSpanID(Util.idValue((long)10L));
        d.setMessageName(new String("childCall1"));
        Span e = new Span();
        e.setSpanID(Util.idValue((long)12L));
        e.setParentSpanID(Util.idValue((long)10L));
        e.setMessageName(new String("childCall2"));
        Span f = new Span();
        f.setSpanID(Util.idValue((long)13L));
        f.setParentSpanID(Util.idValue((long)10L));
        f.setMessageName(new String("childCall3"));
        Span g = new Span();
        g.setSpanID(Util.idValue((long)14L));
        g.setParentSpanID(Util.idValue((long)13L));
        g.setMessageName(new String("childCall4"));
        spans.clear();
        spans.add(d);
        spans.add(e);
        spans.add(f);
        spans.add(g);
        spans.add(root);
        Trace trace2 = Trace.extractTrace(spans);
        Assert.assertFalse((trace1.executionPathHash() == trace2.executionPathHash() ? 1 : 0) != 0);
    }

    public static Span createFullSpan(Long id, Long parentID, String messageName) {
        Span out = new Span();
        out.setSpanID(Util.idValue((long)id));
        if (parentID != null) {
            out.setParentSpanID(Util.idValue((long)parentID));
        }
        out.setMessageName(new String(messageName));
        out.setEvents((List)new GenericData.Array(4, Schema.createArray((Schema)TimestampedEvent.SCHEMA$)));
        for (SpanEvent ev : SpanEvent.values()) {
            TimestampedEvent newEvent = new TimestampedEvent();
            newEvent.setTimeStamp(Long.valueOf(System.currentTimeMillis() * 1000000L));
            newEvent.setEvent((Object)ev);
            out.getEvents().add(newEvent);
        }
        out.setComplete(Boolean.valueOf(true));
        return out;
    }

    @Test
    public void testSpanEquality3() {
        Span a = TestSpanTraceFormation.createFullSpan(1L, null, "a");
        Span b1 = TestSpanTraceFormation.createFullSpan(2L, 1L, "b");
        Span b2 = TestSpanTraceFormation.createFullSpan(3L, 1L, "b");
        Span d = TestSpanTraceFormation.createFullSpan(4L, 1L, "d");
        Span e = TestSpanTraceFormation.createFullSpan(5L, 4L, "e");
        Span f = TestSpanTraceFormation.createFullSpan(6L, 5L, "f");
        Span g1 = TestSpanTraceFormation.createFullSpan(7L, 6L, "g");
        Span g2 = TestSpanTraceFormation.createFullSpan(8L, 6L, "g");
        Span i1 = TestSpanTraceFormation.createFullSpan(9L, 7L, "i");
        Span i2 = TestSpanTraceFormation.createFullSpan(10L, 8L, "i");
        LinkedList<Span> spans = new LinkedList<Span>();
        spans.addAll(Arrays.asList(a, b1, b2, d, e, f, g1, g2, i1, i2));
        Trace trace1 = Trace.extractTrace(spans);
        spans.clear();
        spans.addAll(Arrays.asList(i2, b1, g1, e, f, d, b2, g2, i1, a));
        Trace trace2 = Trace.extractTrace(spans);
        Assert.assertNotNull((Object)trace1);
        Assert.assertNotNull((Object)trace2);
        Assert.assertEquals((long)trace1.executionPathHash(), (long)trace2.executionPathHash());
        Assert.assertEquals((long)trace1.executionPathHash(), (long)trace2.executionPathHash());
        spans.clear();
        spans.addAll(Arrays.asList(i2, b1, g1, e, f, d, b2, g2, a));
        Trace trace3 = Trace.extractTrace(spans);
        Assert.assertNotNull((Object)trace3);
        Assert.assertTrue((trace1.executionPathHash() == trace2.executionPathHash() ? 1 : 0) != 0);
        Assert.assertTrue((trace1.executionPathHash() != trace3.executionPathHash() ? 1 : 0) != 0);
        Assert.assertTrue((trace2.executionPathHash() != trace3.executionPathHash() ? 1 : 0) != 0);
    }

    @Test
    public void testBasicTraceFormation() {
        Span root = new Span();
        root.setSpanID(Util.idValue((long)10L));
        root.setParentSpanID(null);
        root.setMessageName(new String("startCall"));
        Span a = new Span();
        a.setSpanID(Util.idValue((long)11L));
        a.setParentSpanID(Util.idValue((long)10L));
        a.setMessageName(new String("childCall1"));
        Span b = new Span();
        b.setSpanID(Util.idValue((long)12L));
        b.setParentSpanID(Util.idValue((long)10L));
        b.setMessageName(new String("childCall2"));
        Span c = new Span();
        c.setSpanID(Util.idValue((long)13L));
        c.setParentSpanID(Util.idValue((long)10L));
        c.setMessageName(new String("childCall3"));
        LinkedList<Span> spans = new LinkedList<Span>();
        spans.add(root);
        spans.add(a);
        spans.add(b);
        spans.add(c);
        Trace trace = Trace.extractTrace(spans);
        Assert.assertNotNull((Object)trace);
        TraceNode rootNode = trace.getRoot();
        Assert.assertEquals((Object)rootNode.span.getMessageName(), (Object)new String("startCall"));
        Assert.assertEquals((long)3L, (long)rootNode.children.size());
        boolean found3 = false;
        boolean found2 = false;
        boolean found1 = false;
        for (TraceNode tn : rootNode.children) {
            if (tn.span.getMessageName().equals(new String("childCall1"))) {
                found1 = true;
            }
            if (tn.span.getMessageName().equals(new String("childCall2"))) {
                found2 = true;
            }
            if (tn.span.getMessageName().equals(new String("childCall3"))) {
                found3 = true;
            }
            Assert.assertNotNull((Object)tn.children);
            Assert.assertEquals((long)0L, (long)tn.children.size());
        }
        Assert.assertTrue((boolean)found1);
        Assert.assertTrue((boolean)found2);
        Assert.assertTrue((boolean)found3);
    }
}

