/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.federated;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContextFactory;

public class ExecutionContextMap {
    private final ExecutionContext _main = ExecutionContextMap.createExecutionContext();
    private final Map<Long, ExecutionContext> _parEc = new ConcurrentHashMap<Long, ExecutionContext>();

    public ExecutionContext get(long tid) {
        if (tid <= 0L) {
            return this._main;
        }
        return this._parEc.computeIfAbsent(tid, k -> ExecutionContextMap.deriveExecutionContext(this._main));
    }

    public void clear() {
        for (String varName : new ArrayList<String>(this._main.getVariables().keySet())) {
            this._main.cleanupDataObject(this._main.removeVariable(varName));
        }
        for (ExecutionContext ec : this._parEc.values()) {
            for (String varName : ec.getVariables().keySet()) {
                this._main.cleanupDataObject(ec.removeVariable(varName));
            }
        }
        this._parEc.clear();
    }

    private static ExecutionContext createExecutionContext() {
        ExecutionContext ec = ExecutionContextFactory.createContext();
        ec.setAutoCreateVars(true);
        return ec;
    }

    private static ExecutionContext deriveExecutionContext(ExecutionContext ec) {
        ExecutionContext ec2 = ExecutionContextFactory.createContext(ec.getVariables(), ec.getProgram());
        ec2.setAutoCreateVars(true);
        return ec2;
    }
}

